/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.api.controller;

import com.humuson.tms.api.controller.AnalyticsBaseController;
import com.humuson.tms.common.util.DateConverter;
import com.humuson.tms.model.BaseApiInfo;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AnalyticsPlatformController
extends AnalyticsBaseController {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticsPlatformController.class);

    @RequestMapping(value={"/api/apps/{appGrpId}/analytics/platform"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectAll(@PathVariable(value="appGrpId") String appGrpId, ModelMap model, @RequestParam Map<String, String> params) {
        String startDate = DateConverter.addCurrentDays((int)-7);
        String endDate = DateConverter.getCurrentDate((String)"yyyyMMdd");
        params.put("dataType", "OS_VERSION");
        return this.selectAll(appGrpId, startDate, endDate, model, params);
    }

    @RequestMapping(value={"/api/apps/{appGrpId}/analytics/platform/{startDate}/{endDate}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectAll(@PathVariable(value="appGrpId") String appGrpId, @PathVariable(value="startDate") String startDate, @PathVariable(value="endDate") String endDate, ModelMap model, @RequestParam Map<String, String> params) {
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        params.put("dataType", "OS_VERSION");
        BaseApiInfo baseApiInfo = new BaseApiInfo(appGrpId, "A", "selectAll()");
        return this.getResponseEntity(baseApiInfo, params, 1, logger);
    }

    @RequestMapping(value={"/api/apps/{appGrpId}/analytics/platform/total/{startDate}/{endDate}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectTotal(@PathVariable(value="appGrpId") String appGrpId, @PathVariable(value="startDate") String startDate, @PathVariable(value="endDate") String endDate, ModelMap model, @RequestParam Map<String, String> params) {
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        params.put("dataType", "OS_VERSION");
        BaseApiInfo baseApiInfo = new BaseApiInfo(appGrpId, "A", "selectAll()");
        return this.getResponseEntity(baseApiInfo, params, 2, logger);
    }

    @RequestMapping(value={"/api/apps/{appGrpId}/analytics/platform/list/{startDate}/{endDate}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectList(@PathVariable(value="appGrpId") String appGrpId, @PathVariable(value="startDate") String startDate, @PathVariable(value="endDate") String endDate, ModelMap model, @RequestParam Map<String, String> params) {
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        params.put("dataType", "OS_VERSION");
        BaseApiInfo baseApiInfo = new BaseApiInfo(appGrpId, "A", "selectAll()");
        return this.getResponseEntity(baseApiInfo, params, 3, logger);
    }

    @Override
    public void setRequiredValue(BaseApiInfo baseApiInfo, Map<String, String> params) throws Exception {
        super.setRequiredValue(baseApiInfo, params);
        String startDate = params.get("startDate");
        String endDate = params.get("endDate");
        if (startDate == null || "".equals(startDate) || endDate == null || "".equals(endDate)) {
            params.put("startDate", DateConverter.addCurrentDays((int)-7));
            params.put("endDate", DateConverter.getCurrentDate((String)"yyyyMMdd"));
        }
    }
}

