/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.template;

import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.mapper.template.TemplateMapper;
import com.humuson.tms.model.template.Template;
import com.humuson.tms.model.template.TemplateForm;
import com.humuson.tms.model.template.TemplateTreeNode;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.template.TemplateService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    @Value(value="${template.path}")
    String tempaltePathBase;
    @Autowired
    TemplateMapper templateMapper;

    private TemplateTreeNode getRootNode() {
        TemplateTreeNode node = new TemplateTreeNode();
        node.setKey("0");
        node.setTitle("Root");
        node.setFolder(true);
        return node;
    }

    private int getDepth(int id) {
        Integer depth = this.templateMapper.getParentDepth(id);
        depth = depth == null ? 0 : depth;
        return depth + 1;
    }

    @Override
    public TemplateTreeNode[] getTemplateTreeList(TmsUserSession tmsUserSession, String group) {
        final HashMap<String, TemplateTreeNode> nodeMap = new HashMap<String, TemplateTreeNode>();
        TemplateTreeNode rootNode = this.getRootNode();
        nodeMap.put(rootNode.getKey(), rootNode);
        this.templateMapper.getTemplateTreeList(tmsUserSession, group, new ResultHandler(){

            public void handleResult(ResultContext context) {
                TemplateTreeNode node = (TemplateTreeNode)context.getResultObject();
                if ("F".equals(node.getType())) {
                    node.setFolder(true);
                }
                nodeMap.put(node.getKey(), node);
                TemplateTreeNode parentNode = (TemplateTreeNode)nodeMap.get(node.getParentKey());
                List<TemplateTreeNode> childrenNodeList = parentNode.getChildren();
                if (childrenNodeList == null) {
                    childrenNodeList = new ArrayList<TemplateTreeNode>();
                    parentNode.setChildren(childrenNodeList);
                }
                childrenNodeList.add(node);
            }
        });
        TemplateTreeNode[] tree = new TemplateTreeNode[]{rootNode};
        return tree;
    }

    @Override
    public Template getItem(TmsUserSession tmsUserSession, int id) {
        Template template = this.templateMapper.getTemplate(tmsUserSession, id);
        if (StringUtils.isNotEmpty((String)template.getFileName())) {
            String content = null;
            try {
                content = FileUtil.readLocal((String)(this.tempaltePathBase + File.separator + template.getFileName()));
                template.setContent(content);
            }
            catch (IOException e) {
                log.error("template content read error", (Throwable)e);
            }
        }
        return template;
    }

    private File makeNewFile(String basePath) {
        try {
            FileUtil.makeUrl((String)basePath);
        }
        catch (IOException e) {
            log.error("TemplatePath Make error : {}", (Throwable)e);
        }
        int count = 0;
        String fileNameBase = basePath;
        String fileName = String.valueOf(System.currentTimeMillis());
        File file = null;
        while ((file = new File(fileNameBase, fileName = fileName + count++)).exists()) {
        }
        return file;
    }

    private String makeTemplateFileAndGetFileName(String content) {
        File file = this.makeNewFile(this.tempaltePathBase);
        try {
            FileUtil.writeLocal((File)file, (String)content, (String)"UTF-8", (boolean)false);
        }
        catch (IOException e) {
            log.error("make template file error", (Throwable)e);
        }
        return file.getName();
    }

    @Override
    public int makeItem(TmsUserSession tmsUserSession, TemplateForm templateForm) {
        Template template = new Template();
        template.setParentId(templateForm.getParentId()).setGroup(templateForm.getGroup()).setType(templateForm.getType()).setName(templateForm.getName()).setChannelType(templateForm.getChannelType()).setSwitchYn(templateForm.getSwitchYn()).setSmsSubject(templateForm.getSmsSubject()).setNameCode(templateForm.getNameCode()).setDepth(this.getDepth(templateForm.getParentId()));
        if (StringUtils.isNotEmpty((String)templateForm.getContent())) {
            String fileName = this.makeTemplateFileAndGetFileName(templateForm.getContent());
            template.setFileName(fileName);
        }
        this.templateMapper.insertTemplate(tmsUserSession, template);
        return template.getId();
    }

    @Override
    public int updateItem(TmsUserSession tmsUserSession, TemplateForm templateForm) {
        Template template = new Template();
        template.setId(templateForm.getId()).setGroup(templateForm.getGroup()).setType(templateForm.getType()).setChannelType(templateForm.getChannelType()).setSwitchYn(templateForm.getSwitchYn()).setSmsSubject(templateForm.getSmsSubject()).setNameCode(templateForm.getNameCode()).setName(templateForm.getName());
        if (templateForm.getParentId() != null) {
            template.setParentId(templateForm.getParentId()).setDepth(this.getDepth(templateForm.getParentId()));
        }
        if (StringUtils.isNotEmpty((String)templateForm.getContent())) {
            String fileName = this.makeTemplateFileAndGetFileName(templateForm.getContent());
            template.setFileName(fileName);
        }
        return this.templateMapper.updateTempalte(tmsUserSession, template);
    }

    @Override
    public int deleteItem(TmsUserSession tmsUserSession, int id) {
        return this.templateMapper.deleteTemplate(tmsUserSession, id);
    }

    @Override
    public int deleteItems(TmsUserSession tmsUserSession, int[] ids) {
        return this.templateMapper.deleteTemplates(tmsUserSession, ids);
    }
}

