/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.system;

import com.humuson.tms.common.DynamicDatabaseDao;
import com.humuson.tms.mapper.system.TargetDbMgrMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.system.TmsDbInfo;
import com.humuson.tms.model.vo.EntityMap;
import com.humuson.tms.service.system.TargetDbMgrService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.stereotype.Service;

@Service
public class TargetDbMgrServiceImpl
implements TargetDbMgrService {
    public static final String TEMPLATE_QUERY_ORACLE = "SELECT * FROM ( #table ) #alias WHERE ROWNUM = 1";
    public static final String TEMPLATE_QUERY_MYSQL = "SELECT * FROM ( #table ) #alias LIMIT 1";
    public static final String TEMPLATE_QUERY_MSSQL = "SELECT TOP 1 * FROM #table A";
    public static final String TEMPLATE_QUERY_TERA = "SELECT TOP 1 * FROM ( #table ) #alias";
    public static final String TEMPLATE_QUERY_ELSE = "SELECT * FROM ( #table ) #alias";
    @Autowired
    TargetDbMgrMapper targetDbMgrMapper;
    @Autowired
    DynamicDatabaseDao dynaDB;

    @Override
    public List<TmsDbInfo> selectTgtDB(PageInfo pageInfo, TmsDbInfo tmsDbInfo) {
        if (pageInfo != null) {
            pageInfo.calculate(this.selectTgtDBTotal(tmsDbInfo));
        }
        return this.targetDbMgrMapper.selectTgtDB(pageInfo, tmsDbInfo);
    }

    @Override
    public int selectTgtDBTotal(TmsDbInfo tmsDbInfo) {
        return this.targetDbMgrMapper.selectTgtDBTotal(tmsDbInfo);
    }

    @Override
    public int insertTgtDB(TmsDbInfo tmsDbInfo) {
        return this.targetDbMgrMapper.insertTgtDB(tmsDbInfo);
    }

    @Override
    public int updateTgtDB(TmsDbInfo tmsDbInfo) {
        return this.targetDbMgrMapper.updateTgtDB(tmsDbInfo);
    }

    @Override
    public int deleteTgtDB(TmsDbInfo tmsDbInfo) {
        return this.targetDbMgrMapper.deleteTgtDB(tmsDbInfo);
    }

    @Override
    public EntityMap DBInfo(TmsDbInfo tmsDbInfo, String tableName) {
        EntityMap dbInfo = new EntityMap();
        List<TmsDbInfo> tgtDBList = this.targetDbMgrMapper.selectTgtDB(null, tmsDbInfo);
        TmsDbInfo tgtDB = tgtDBList.get(0);
        String checkCon = this.dynaDB.connectTest(tgtDB.getDbDrv(), tgtDB.getDbUrl(), tgtDB.getDbUsr(), tgtDB.getDbPwd());
        Map<String, Object> resultMap = null;
        if ("".equals(checkCon)) {
            String driverName = tgtDB.getDbDrv();
            String url = tgtDB.getDbUrl();
            String username = tgtDB.getDbUsr();
            String password = tgtDB.getDbPwd();
            String exception = "";
            String dbType = tgtDB.getDbType();
            String queryTemplate = null;
            String query = null;
            Exception isException = null;
            queryTemplate = dbType.equals("Oracle") ? TEMPLATE_QUERY_ORACLE : (dbType.equals("SqlServer") ? TEMPLATE_QUERY_MSSQL : (dbType.equals("MySQL") ? TEMPLATE_QUERY_MYSQL : (dbType.equals("TeraData") ? TEMPLATE_QUERY_TERA : TEMPLATE_QUERY_ELSE)));
            try {
                query = queryTemplate.replace("#table", tableName).replace("#alias", "");
                resultMap = this.dynaDB.queryForMap(query, this.dynaDB.createDataSource(driverName, url, username, password));
            }
            catch (Exception e) {
                isException = e;
                exception = e.toString();
                try {
                    query = queryTemplate.replace("#table", tableName).replace("#alias", "A");
                    resultMap = this.dynaDB.queryForMap(query, this.dynaDB.createDataSource(driverName, url, username, password));
                }
                catch (Exception e2) {
                    exception = e2.toString();
                }
            }
            if (resultMap != null && resultMap.size() > 0) {
                ArrayList<EntityMap> result = new ArrayList<EntityMap>();
                for (String key : resultMap.keySet()) {
                    EntityMap valMap = new EntityMap();
                    valMap.put("colName", (Object)key);
                    valMap.put("colVal", resultMap.get(key));
                    result.add(valMap);
                }
                dbInfo.put("result", (Object)"ok");
                dbInfo.put("columnList", (Object)result);
                dbInfo.put("dbType", (Object)tgtDB.getDbType());
            } else if (isException instanceof BadSqlGrammarException) {
                dbInfo.put("result", (Object)"table");
            } else if (isException instanceof EmptyResultDataAccessException) {
                dbInfo.put("result", (Object)"dataZero");
            } else {
                dbInfo.put("result", (Object)"otherErr");
            }
        } else {
            dbInfo.put("result", (Object)"db");
        }
        return dbInfo;
    }

    @Override
    public List<TmsDbInfo> selectTgtList() {
        return this.targetDbMgrMapper.selectTgtList();
    }
}

