/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.site;

import com.humuson.tms.common.security.HumusonEncryptor;
import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.common.util.PrivateServerAppKeyManage;
import com.humuson.tms.convert.aop.ConvertTarget;
import com.humuson.tms.convert.bind.Decrypt;
import com.humuson.tms.convert.bind.Encrypt;
import com.humuson.tms.mapper.SiteMapper;
import com.humuson.tms.model.AmcInfo;
import com.humuson.tms.model.AppGrpInfo;
import com.humuson.tms.model.ListInfo;
import com.humuson.tms.model.SiteInfo;
import com.humuson.tms.model.form.AppManageForm;
import com.humuson.tms.model.vo.AppInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.SiteService;
import com.humuson.tms.service.TempImgUploadService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SiteServiceImpl
implements SiteService {
    private static final Logger log = LoggerFactory.getLogger(SiteServiceImpl.class);
    @Autowired
    private SiteMapper siteMapper;
    @Autowired
    PrivateServerAppKeyManage psam;
    private String typeAndroid = "A";
    private String typeiOS = "I";
    private String typeAll = "AI";
    @Value(value="${apns.file.path}")
    private String apnsFilePath;
    @Value(value="${db.enc.key}")
    private String dbEncKey;
    @Value(value="${img.upload.path}")
    private String iconPath;
    @Autowired
    private TempImgUploadService tempImgUploadService;

    @Override
    @Cacheable(value={"siteInfoCache"}, key="#userId")
    public List<SiteInfo> selectSiteInfo(String userId) {
        return this.siteMapper.selectSiteInfo(userId);
    }

    @Override
    public List<SiteInfo> selectSiteList(String userId) {
        return this.siteMapper.selectSiteList(userId);
    }

    @Override
    public List<SiteInfo> selectAppCountBySite() {
        return this.siteMapper.selectAppCountBySite();
    }

    @Override
    public int selectAppGrpCnt(int siteId) {
        return this.siteMapper.selectAppGrpCnt(siteId);
    }

    @Override
    public List<AppGrpInfo> selectAppGrpInfo(int siteId) {
        return this.siteMapper.selectAppGrpInfo(siteId);
    }

    @Override
    public int selectDirectSiteId(String userId) {
        return this.siteMapper.selectDirectSiteId(userId);
    }

    @Override
    public int insertSiteInfo(SiteInfo siteInfo) {
        return this.siteMapper.insertSiteInfo(siteInfo);
    }

    @Override
    public int insertAppGrpInfo(AppInfo appInfo) {
        return this.siteMapper.insertAppGrpInfo(appInfo);
    }

    @Override
    public int insertAppInfo(AppInfo appInfo) {
        return this.siteMapper.insertAppInfo(appInfo);
    }

    @Override
    @ConvertTarget
    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public String insertEmailList(TmsUserSession tmsUserSession, @Encrypt(prop={"eMail"}) @RequestParam Map<String, String> params) {
        JSONObject resultJSON = new JSONObject();
        int siteId = Integer.parseInt(params.get("siteId"));
        String email = params.get("eMail");
        String regId = tmsUserSession.getRegId();
        ListInfo emailInfo = this.siteMapper.selectEmailInfoBySiteIdAndRegIdAndEmail(siteId, regId, email);
        if (emailInfo != null) {
            resultJSON.put((Object)"result", (Object)"duplicate");
            log.info("insertEmailList Fail!!! -> duplicate");
            return resultJSON.toString();
        }
        ListInfo listInfo = new ListInfo();
        listInfo.setSiteId(siteId);
        listInfo.setEMail(params.get("eMail"));
        listInfo.setName(params.get("name"));
        listInfo.setReturnPath(params.get("returnPath"));
        listInfo.setTrackingDate(params.get("trackingDate"));
        listInfo.setTrackingFlag(params.get("trackingFlag"));
        listInfo.setRegisterId(tmsUserSession.getRegId());
        int count = this.siteMapper.insertEmailList(listInfo);
        log.info("Insert Email Information: {}, {}", (Object)listInfo, (Object)count);
        if (count < 1) {
            resultJSON.put((Object)"result", (Object)"fail");
            return resultJSON.toString();
        }
        resultJSON.put((Object)"result", (Object)"success");
        return resultJSON.toString();
    }

    @Override
    @ConvertTarget
    public int insertSMSList(@Encrypt ListInfo listInfo) {
        return this.siteMapper.insertSMSList(listInfo);
    }

    @Override
    @ConvertTarget
    public int insertKAKAOList(@Encrypt ListInfo listInfo) {
        return this.siteMapper.insertKAKAOList(listInfo);
    }

    @Override
    public int selectEmailListId(int siteId) {
        return this.siteMapper.selectEmailListId(siteId);
    }

    @Override
    public int selectPhoneListId(int siteId) {
        return this.siteMapper.selectPhoneListId(siteId);
    }

    @Override
    public int selectKakaoListId(int siteId) {
        return this.siteMapper.selectKakaoListId(siteId);
    }

    @Override
    public int deleteAppInfo(AppInfo appInfo) {
        return this.siteMapper.deleteAppInfo(appInfo);
    }

    @Override
    @CacheEvict(value={"siteInfoCache"}, key="#siteInfo.siteId")
    public int deleteSiteInfo(SiteInfo siteInfo) {
        return this.siteMapper.deleteSiteInfo(siteInfo);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int addAndroid(TmsUserSession tmsUserSession, int appGrpId, AppManageForm argForm, String job, AppInfo app) {
        String appKey = UUID.randomUUID().toString().replaceAll("-", "");
        app.setAppGrpId(appGrpId);
        app.setAppName(argForm.getAppGrpName() + "_Android");
        this.setApiKey(app, argForm);
        app.setRegisterId(tmsUserSession.getRegId());
        app.setOs(this.typeAndroid);
        app.setAppKey(appKey.substring(0, 20));
        app.setAutoBlockStart(argForm.getAutoBlockStart());
        app.setAutoBlockEnd(argForm.getAutoBlockEnd());
        if (job == "insert") {
            app.setInvalidList(argForm.getInvalidList());
        }
        int insertCnt = this.insertAppInfo(app);
        this.psam.appKeyRegistRedis(app);
        return insertCnt;
    }

    public void setApiKey(AppInfo argAppInfo, AppManageForm argForm) {
        String gcmKey3;
        String gcmKey1 = argForm.getApiKey1() != null && argForm.getApiKey1().length() > 0 ? argForm.getApiKey1() : "";
        String gcmKey2 = argForm.getApiKey2() != null && argForm.getApiKey2().length() > 0 ? argForm.getApiKey2() : "";
        String string = gcmKey3 = argForm.getApiKey3() != null && argForm.getApiKey3().length() > 0 ? argForm.getApiKey3() : "";
        if (gcmKey1.equals("")) {
            if (!gcmKey2.equals("")) {
                gcmKey1 = gcmKey2;
                gcmKey2 = gcmKey3;
                gcmKey3 = "";
            } else if (!gcmKey3.equals("")) {
                gcmKey1 = gcmKey3;
                gcmKey3 = "";
            }
        }
        if (gcmKey2.equals("")) {
            gcmKey2 = gcmKey1;
        }
        if (gcmKey3.equals("")) {
            gcmKey3 = gcmKey2;
        }
        argAppInfo.setApiKey1(gcmKey1);
        argAppInfo.setApiKey2(gcmKey2);
        argAppInfo.setApiKey3(gcmKey3);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int addiOS(TmsUserSession tmsUserSession, int argGrpId, AppManageForm argForm, MultipartFile argCertFile, String job, String productionYn) {
        String appKey = UUID.randomUUID().toString().replaceAll("-", "");
        String saveFileName = this.certFileSubmit(argForm.getUpfile());
        if (saveFileName != null) {
            AppInfo app = new AppInfo();
            app.setAppGrpId(argGrpId);
            app.setAppName(argForm.getAppGrpName() + "_iOS");
            app.setPushCert(saveFileName);
            app.setOs(this.typeiOS);
            app.setAppKey(appKey.substring(0, 20));
            app.setPushPwd(HumusonEncryptor.encrypt((String)argForm.getApnsPW(), (String)this.dbEncKey));
            app.setBadgeFlag(argForm.getBadgeFlag());
            app.setPushSound(argForm.getPushSound());
            app.setRegisterId(tmsUserSession.getRegId());
            app.setAutoBlockStart(argForm.getAutoBlockStart());
            app.setAutoBlockEnd(argForm.getAutoBlockEnd());
            app.setProductionYn(productionYn);
            if (job == "insert") {
                app.setInvalidList(argForm.getInvalidList());
            }
            return this.insertAppInfo(app);
        }
        return 0;
    }

    public String certFileSubmit(MultipartFile uploadfile) {
        String savedfileName = "";
        if (uploadfile != null) {
            try {
                File f = new File(this.apnsFilePath);
                if (!f.exists()) {
                    log.debug("directory no exist : create path : {}" + this.apnsFilePath);
                    f.mkdir();
                }
                String fileName = uploadfile.getOriginalFilename();
                int indexNum = 0;
                do {
                    savedfileName = "apns_" + (indexNum == 0 ? "" : indexNum + "_") + fileName;
                    ++indexNum;
                } while (FileUtil.existsLocal((String)savedfileName, (String)this.apnsFilePath));
                uploadfile.transferTo(new File(this.apnsFilePath, savedfileName));
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return savedfileName;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int insertAppGrp(TmsUserSession tmsUserSession, AppInfo appInfo, AppManageForm appManageform) {
        int result = 0;
        int appGrpId = 0;
        int addResultAndroid = 0;
        int addResultiOS = 0;
        result = this.insertAppGrpInfo(appInfo);
        if (result > 0) {
            appGrpId = appInfo.getAppGrpId();
            log.info("OS : " + appManageform.getOs());
            if (appManageform.getOs().equals(this.typeAndroid) || appManageform.getOs().equals(this.typeAll)) {
                addResultAndroid = this.addAndroid(tmsUserSession, appInfo.getAppGrpId(), appManageform, "insert", appInfo);
                if (addResultAndroid > 0) {
                    log.debug("addGrpInfo Android Success");
                } else {
                    log.debug("addGrpInfo Android Fail");
                }
            } else {
                log.debug("addGrpInfo Android PASS");
                addResultAndroid = 1;
            }
            if (appManageform.getOs().equals(this.typeiOS) || appManageform.getOs().equals(this.typeAll)) {
                addResultiOS = this.addiOS(tmsUserSession, appInfo.getAppGrpId(), appManageform, appManageform.getUpfile(), "insert", appInfo.getProductionYn());
                if (addResultiOS > 0) {
                    log.debug("addGrpInfo iOS Success");
                } else {
                    log.debug("addGrpInfo iOS Fail");
                }
            } else {
                log.debug("addGrpInfo iOS PASS");
                addResultiOS = 1;
            }
        } else {
            log.debug("addGrpInfo Fail");
        }
        return appGrpId;
    }

    @Override
    @Cacheable(value={"siteInfoCache"}, key="#siteId")
    public List<SiteInfo> selectSiteInfoBySiteId(int siteId) {
        return this.siteMapper.selectSiteInfoBySiteId(siteId);
    }

    @Override
    @CacheEvict(value={"siteInfoCache"}, key="#siteInfo.siteId")
    public int updateSiteInfo(SiteInfo siteInfo) {
        return this.siteMapper.updateSiteInfo(siteInfo);
    }

    @Override
    public int updateTotalUserCnt(int siteId) {
        return this.siteMapper.updateTotalUserCnt(siteId);
    }

    @Override
    @ConvertTarget
    @Decrypt
    public List<ListInfo> selectEmailListBySiteId(int siteId) {
        return this.siteMapper.selectEmailListBySiteId(siteId);
    }

    @Override
    @ConvertTarget
    @Decrypt
    public List<ListInfo> selectEmailInfoBySiteIdAndRegId(int siteId, String regId) {
        return this.siteMapper.selectEmailInfoBySiteIdAndRegId(siteId, regId);
    }

    @Override
    @ConvertTarget
    @Decrypt
    public List<ListInfo> selectPhoneListBySiteId(int siteId) {
        return this.siteMapper.selectPhoneListBySiteId(siteId);
    }

    @Override
    @ConvertTarget
    @Decrypt
    public List<ListInfo> selectKakaoSenderInfoListBySiteId(int siteId) {
        return this.siteMapper.selectKakaoSenderInfoListBySiteId(siteId);
    }

    @Override
    @ConvertTarget
    @Decrypt
    public List<ListInfo> selectPhoneListBySiteIdAndRegId(int siteId, String regId) {
        return this.siteMapper.selectPhoneListBySiteIdAndRegId(siteId, regId);
    }

    @Override
    @ConvertTarget
    @Decrypt
    public List<ListInfo> selectSenderKeyListBySiteIdAndRegId(int siteId, String regId) {
        return this.siteMapper.selectSenderKeyListBySiteIdAndRegId(siteId, regId);
    }

    @Override
    @ConvertTarget
    public int updateEmailList(@Encrypt ListInfo listInfo) {
        return this.siteMapper.updateEmailList(listInfo);
    }

    @Override
    public int deleteEmailList(ListInfo listInfo) {
        return this.siteMapper.deleteEmailList(listInfo);
    }

    @Override
    @ConvertTarget
    public int updatePhoneList(@Encrypt ListInfo listInfo) {
        return this.siteMapper.updatePhoneList(listInfo);
    }

    @Override
    @ConvertTarget
    public int updateKakaoList(@Encrypt ListInfo listInfo) {
        return this.siteMapper.updateKakaoList(listInfo);
    }

    @Override
    public int deletePhoneList(ListInfo listInfo) {
        return this.siteMapper.deletePhoneList(listInfo);
    }

    @Override
    public int deleteKakaoList(ListInfo listInfo) {
        return this.siteMapper.deleteKakaoList(listInfo);
    }

    @Override
    public int deleteAppGrp(AppGrpInfo appGrpInfo) {
        return this.siteMapper.deleteAppGrp(appGrpInfo);
    }

    @Override
    public List<AppInfo> selectAppInfo(int appGrpId) {
        return this.siteMapper.selectAppInfo(appGrpId);
    }

    @Override
    public int updateAppGrpInfo(AppInfo appInfo) {
        return this.siteMapper.updateAppGrpInfo(appInfo);
    }

    @Override
    public int updateAppInfoTypeAndroid(AppInfo appInfo) {
        return this.siteMapper.updateAppInfoTypeAndroid(appInfo);
    }

    @Override
    public int updateAppInfoTypeiOS(AppInfo appInfo) {
        return this.siteMapper.updateAppInfoTypeiOS(appInfo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int updateAppGrp(TmsUserSession tmsUserSession, AppInfo appInfo, AppManageForm appManageform, int appGrpId) {
        int result = 0;
        int resultAndroid = 0;
        int resultiOS = 0;
        result = this.updateAppGrpInfo(appInfo);
        if (result > 0) {
            log.info("updateGrpInfo Success with GrpID : " + appGrpId);
            String originOs = appManageform.getOriginOs();
            String newOs = appManageform.getOs();
            log.info("originOs:" + originOs + " newOs:" + newOs);
            if ((originOs.equals(this.typeAndroid) || originOs.equals(this.typeAll)) && newOs.equals(this.typeiOS)) {
                log.info("Delete originOs:" + originOs + " newOs:" + newOs);
                appInfo.setAppGrpId(appGrpId);
                appInfo.setOs(this.typeAndroid);
                resultAndroid = this.deleteAppInfo(appInfo);
                if (resultAndroid <= 0) {
                    log.error("delete Android Fail [{}]", (Object)appInfo.toString());
                }
            } else if (originOs.equals(this.typeiOS) && (newOs.equals(this.typeAndroid) || newOs.equals(this.typeAll))) {
                log.info("Add originOs:" + originOs + " newOs:" + newOs);
                resultAndroid = this.addAndroid(tmsUserSession, appGrpId, appManageform, "insert", appInfo);
            } else if ((originOs.equals(this.typeAndroid) || originOs.equals(this.typeAll)) && (newOs.equals(this.typeAndroid) || newOs.equals(this.typeAll))) {
                log.info("Modify originOs:" + originOs + " newOs:" + newOs);
                resultAndroid = this.modifyAndroid(appGrpId, appManageform);
                if (resultAndroid <= 0) {
                    log.error("modify Android Fail [grpId:{}, form:{}]", (Object)appGrpId, (Object)appManageform.toString());
                }
            } else {
                resultAndroid = 1;
                log.debug("modify Android PASS");
            }
            if ((originOs.equals(this.typeiOS) || originOs.equals(this.typeAll)) && newOs.equals(this.typeAndroid)) {
                log.info("Delete originOs:" + originOs + " newOs:" + newOs);
                appInfo.setAppGrpId(appGrpId);
                appInfo.setOs(this.typeiOS);
                resultiOS = this.deleteAppInfo(appInfo);
                if (resultiOS <= 0) {
                    log.error("delete iOS Fail [{}]", (Object)appInfo.toString());
                }
            } else if (originOs.equals(this.typeAndroid) && (newOs.equals(this.typeiOS) || newOs.equals(this.typeAll))) {
                log.info("Add originOs:" + originOs + " newOs:" + newOs);
                resultiOS = this.addiOS(tmsUserSession, appGrpId, appManageform, appManageform.getUpfile(), "update", appInfo.getProductionYn());
                if (resultiOS <= 0) {
                    log.error("add iOS Fail [grpId:{}, form:{}]", (Object)appGrpId, (Object)appManageform.toString());
                }
            } else if ((originOs.equals(this.typeiOS) || originOs.equals(this.typeAll)) && (newOs.equals(this.typeiOS) || newOs.equals(this.typeAll))) {
                log.info("Modify originOs:" + originOs + " newOs:" + newOs);
                resultiOS = this.modifyiOS(appGrpId, appManageform, appManageform.getUpfile(), appInfo.getProductionYn());
                if (resultiOS <= 0) {
                    log.debug("modify iOS Fail [grpId:{}, form:{}]", (Object)appGrpId, (Object)appManageform.toString());
                }
            } else {
                resultiOS = 1;
                log.debug("modify iOS PASS");
            }
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int modifyAndroid(int argGrpId, AppManageForm argForm) {
        AppInfo app = new AppInfo();
        app.setAppGrpId(argGrpId);
        app.setAppName(argForm.getAppGrpName() + "_Android");
        this.setApiKey(app, argForm);
        app.setOs(this.typeAndroid);
        app.setAutoBlockStart(argForm.getAutoBlockStart());
        app.setAutoBlockEnd(argForm.getAutoBlockEnd());
        app.setPrivateFlag(argForm.getPrivateYN());
        app.setPrivateProtocol(argForm.getPrivateProtocol());
        app.setGcmNum(argForm.getGcmNum());
        return this.updateAppInfoTypeAndroid(app);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int modifyiOS(int argGrpId, AppManageForm argForm, MultipartFile argCertFile, String productionYn) {
        AppInfo app = new AppInfo();
        app.setAppGrpId(argGrpId);
        app.setOs(this.typeiOS);
        app.setAppName(argForm.getAppGrpName() + "_iOS");
        app.setPushSound(argForm.getPushSound());
        app.setBadgeFlag(argForm.getBadgeFlag());
        app.setProductionYn(productionYn);
        app.setPushPwd(HumusonEncryptor.encrypt((String)argForm.getApnsPW(), (String)this.dbEncKey));
        if (argForm.getIsCertFileChange() == 1) {
            String saveFileName = this.certFileSubmit(argCertFile);
            if (saveFileName == null || saveFileName == "") {
                return 0;
            }
            app.setPushCert(saveFileName);
        } else {
            app.setPushCert(argForm.getOriginFileName());
        }
        return this.updateAppInfoTypeiOS(app);
    }

    @Override
    public int updateDirectSiteId(int siteId, String userId) {
        return this.siteMapper.updateDirectSiteId(siteId, userId);
    }

    @Override
    public int selectAppGrpCount(int siteId) {
        return this.siteMapper.selectAppGrpCount(siteId);
    }

    @Override
    public int selectPhoneCount(int siteId) {
        return this.siteMapper.selectPhoneCount(siteId);
    }

    @Override
    public int selectKakaoCount(int siteId) {
        return this.siteMapper.selectKakaoCount(siteId);
    }

    @Override
    public int selectEmailCount(int siteId) {
        return this.siteMapper.selectEmailCount(siteId);
    }

    @Override
    public int deleteCancelPhone(int siteId) {
        return this.siteMapper.deleteCancelPhone(siteId);
    }

    @Override
    public int deleteCancelEmail(int siteId) {
        return this.siteMapper.deleteCancelEmail(siteId);
    }

    @Override
    public int deleteCancelAppGrp(int siteId) {
        return this.siteMapper.deleteCancelAppGrp(siteId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int cancelSite(int siteId) {
        List<Object> list = new ArrayList();
        SiteInfo siteInfo = new SiteInfo();
        siteInfo.setSiteId(siteId);
        list = this.selectSiteInfoBySiteId(siteId);
        String emailFlag = ((SiteInfo)list.get(0)).getEmailFlag();
        String smsFlag = ((SiteInfo)list.get(0)).getSmsFlag();
        String pushFlag = ((SiteInfo)list.get(0)).getPushFlag();
        this.deleteSiteInfo(siteInfo);
        if (emailFlag.equals("Y")) {
            this.deleteCancelEmail(siteId);
        }
        if (smsFlag.equals("Y")) {
            this.deleteCancelPhone(siteId);
        }
        if (pushFlag.equals("Y")) {
            this.deleteCancelAppGrp(siteId);
        }
        return 0;
    }

    @Override
    public int insertSiteAccessUserInfo(SiteInfo siteInfo) {
        return this.siteMapper.insertSiteAccessUserInfo(siteInfo);
    }

    @Override
    public String saveSiteImgByTempImg(String tempImgFileName) {
        String imgPath = this.iconPath + File.separator + tempImgFileName;
        this.tempImgUploadService.moveTempImgToPath(tempImgFileName, imgPath);
        return tempImgFileName;
    }

    @Override
    public AmcInfo getAmcUserInfo(int siteId, String msgId) {
        return this.siteMapper.getAmcUserInfo(siteId, msgId);
    }

    @Override
    public AmcInfo getCampAmcUserInfo(int siteId, String postId) {
        return this.siteMapper.getCampAmcUserInfo(siteId, postId);
    }

    @Override
    public AmcInfo getAutoAmcUserInfo(String msgType, String msgTypeSeq) {
        return this.siteMapper.getAutoAmcUserInfo(msgType, msgTypeSeq);
    }

    @Override
    public AmcInfo getAmcWebKey(int siteId) {
        return this.siteMapper.getAmcWebKey(siteId);
    }

    @Override
    public AmcInfo getAmcAppKey(int appId) {
        return this.siteMapper.getAmcAppKey(appId);
    }

    @Override
    public int updateAmcSiteKey(int siteId, String amcSiteKey) {
        return this.siteMapper.updateAmcSiteKey(siteId, amcSiteKey);
    }

    @Override
    public int updateAmcWebKey(int siteId, String amcWebKey) {
        return this.siteMapper.updateAmcWebKey(siteId, amcWebKey);
    }

    @Override
    public int updateAmcAppKey(int appId, String amcAppKey) {
        return this.siteMapper.updateAmcAppKey(appId, amcAppKey);
    }
}

