/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.safemail;

import com.humuson.tms.mapper.safemail.TmsSafeMailMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.safemail.TmsSafeMailInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.safemail.TmsSafeMailService;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TmsSafeMailServiceImpl
implements TmsSafeMailService {
    private static final Logger log = LoggerFactory.getLogger(TmsSafeMailServiceImpl.class);
    @Autowired
    TmsSafeMailMapper tmsSafeMailMapper;

    @Override
    public List<TmsSafeMailInfo> campSafeMailPagingList(@Param(value="pageInfo") PageInfo pageInfo, @Param(value="param") Map<String, String> param, @Param(value="tmsUserSession") TmsUserSession tmsUserSession) {
        if (param.get("msg_search_period") != null) {
            String[] period = param.get("msg_search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null) {
            String[] period = param.get("search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.tmsSafeMailMapper.campSafeMailTotalCnt(param, tmsUserSession));
        return this.tmsSafeMailMapper.campSafeMailPagingList(pageInfo, param, tmsUserSession);
    }

    @Override
    public int campSafeMailTotalCnt(@Param(value="param") Map<String, String> param, @Param(value="tmsUserSession") TmsUserSession tmsUserSession) {
        return this.tmsSafeMailMapper.campSafeMailTotalCnt(param, tmsUserSession);
    }

    @Override
    public List<TmsSafeMailInfo> autoSafeMailPagingList(@Param(value="pageInfo") PageInfo pageInfo, @Param(value="param") Map<String, String> param, @Param(value="tmsUserSession") TmsUserSession tmsUserSession) {
        if (param.get("msg_search_period") != null) {
            String[] period = param.get("msg_search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null) {
            String[] period = param.get("search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.tmsSafeMailMapper.autoSafeMailTotalCnt(param, tmsUserSession));
        return this.tmsSafeMailMapper.autoSafeMailPagingList(pageInfo, param, tmsUserSession);
    }

    @Override
    public int autoSafeMailTotalCnt(@Param(value="param") Map<String, String> param, @Param(value="tmsUserSession") TmsUserSession tmsUserSession) {
        return this.tmsSafeMailMapper.campSafeMailTotalCnt(param, tmsUserSession);
    }

    @Override
    public int updateCampSafeState(@Param(value="param") Map<String, Object> param) {
        return this.tmsSafeMailMapper.updateCampSafeState(param);
    }

    @Override
    public int updateAutoSafeState(@Param(value="param") Map<String, Object> param) {
        return this.tmsSafeMailMapper.updateAutoSafeState(param);
    }
}

