/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.link;

import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.mapper.link.LinkMgrMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.TmsLinkInfo;
import com.humuson.tms.service.link.LinkMgrService;
import gui.ava.html.image.generator.HtmlImageGenerator;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LinkMgrServiceImpl
implements LinkMgrService {
    private static final Logger log = LoggerFactory.getLogger(LinkMgrServiceImpl.class);
    @Autowired
    LinkMgrMapper linkMgrMapper;
    @Value(value="${sns.content.path}")
    private String fileSnsUploadPath;
    @Value(value="${sns.content.url}")
    private String fileSnsUploadUrl;
    @Value(value="${sns.thumbnail.url}")
    private String thumbNailUrl;

    @Override
    public int linkListTotal(Map<String, String> param) {
        return this.linkMgrMapper.linkListTotal(param);
    }

    @Override
    public List<TmsLinkInfo> searchLinkList(PageInfo pageInfo, Map<String, String> param) {
        log.info("[searchLinkList] param :{}", param);
        pageInfo.calculate(this.linkListTotal(param));
        List<TmsLinkInfo> searchLinkList = this.linkMgrMapper.searchLinkList(pageInfo, param);
        return searchLinkList;
    }

    @Override
    public TmsLinkInfo getLinkDetail(Map<String, String> param) {
        return this.linkMgrMapper.getLinkDetail(param);
    }

    @Override
    public int linkMgrDelete(Map<String, String> param) {
        return this.linkMgrMapper.linkMgrDelete(param);
    }

    @Override
    public int linkMgrUpdate(Map<String, String> param) {
        int updateCnt = 0;
        String linkFileName = param.get("linkFileName");
        String name = linkFileName.substring(0, linkFileName.indexOf("."));
        String linkFilePath = this.fileSnsUploadPath + "/" + linkFileName;
        String linkThumbNailTempFilePath = this.fileSnsUploadPath + "/thumbnail/" + name + ".png";
        String linkThumbNailFilePath = this.fileSnsUploadPath + "/thumbnail/" + name + ".jpg";
        try {
            this.saveSnsFile(param);
            this.createThumbNail(linkFileName, linkFilePath, linkThumbNailTempFilePath, linkThumbNailFilePath, "FILE");
            updateCnt = this.linkMgrMapper.linkMgrUpdate(param);
        }
        catch (Exception e) {
            log.error("[LinkMgrServiceImpl] LinkMgrUpdate ERROR:", (Throwable)e);
            updateCnt = 0;
        }
        return updateCnt;
    }

    @Override
    public int linkMgrRegist(Map<String, String> param) {
        int insertCnt = 0;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            Date now = new Date();
            String today = format.format(now);
            String linkFileName = today + ".html";
            String linkFilePath = this.fileSnsUploadPath + "/" + today + ".html";
            String linkUrl = this.fileSnsUploadUrl + "/" + today + ".html";
            String linkThumbNailTempFilePath = this.fileSnsUploadPath + "/thumbnail/" + today + ".png";
            String linkThumbNailFilePath = this.fileSnsUploadPath + "/thumbnail/" + today + ".jpg";
            String linkThumbNailUrl = this.thumbNailUrl + "/" + today + ".jpg";
            try {
                FileUtil.makeUrl((String)(this.fileSnsUploadPath + "/thumbnail"));
            }
            catch (IOException e1) {
                log.error("sns makeUrl error : {}", (Throwable)e1);
            }
            param.put("linkFilePath", linkFilePath);
            param.put("linkUrl", linkUrl);
            param.put("linkThumbNailFilePath", linkThumbNailFilePath);
            param.put("linkThumbNailUrl", linkThumbNailUrl);
            this.saveSnsFile(param);
            this.createThumbNail(linkFileName, linkFilePath, linkThumbNailTempFilePath, linkThumbNailFilePath, "FILE");
            insertCnt = this.linkMgrMapper.linkMgrRegist(param);
        }
        catch (Exception e) {
            log.error("[LinkMgrServiceImpl] LinkMgrRegist ERROR:", (Throwable)e);
            insertCnt = 0;
        }
        return insertCnt;
    }

    public void saveSnsFile(Map<String, String> param) throws Exception {
        String linkId = param.get("linkId");
        String linkFileName = param.get("linkFileName");
        String html_base_path = this.fileSnsUploadPath;
        try {
            FileUtil.makeUrl((String)html_base_path);
        }
        catch (IOException e1) {
            log.error("sns makeUrl error : {}", (Throwable)e1);
        }
        String baseContentPath = html_base_path;
        baseContentPath = !"".equals(linkFileName) && linkFileName != null ? baseContentPath + "/" + linkFileName : param.get("linkFilePath");
        try {
            FileUtil.writeLocal((String)baseContentPath, (String)StringUtils.validString((String)param.get("content")), (boolean)false);
        }
        catch (Exception e2) {
            log.error("sns writeLocal error : {}", (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createThumbNail(String htmlName, String target, String tempFilePath, String filePath, String type) {
        HtmlImageGenerator imageGenerator = new HtmlImageGenerator();
        if ("FILE".equals(type)) {
            String html = null;
            StringBuffer fileData = new StringBuffer(1000);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(target));
                char[] buf = new char[1024];
                int numRead = 0;
                while ((numRead = reader.read(buf)) != -1) {
                    String readData = String.valueOf(buf, 0, numRead);
                    fileData.append(readData);
                    buf = new char[1024];
                }
            }
            catch (Exception e) {
                log.error("createThumbNail Err...", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                }
            }
            html = fileData.toString();
            imageGenerator.loadHtml(html);
            imageGenerator.saveAsImage(tempFilePath);
            imageGenerator.saveAsHtmlWithMap(htmlName, filePath);
        } else {
            imageGenerator.loadUrl(target);
            imageGenerator.saveAsImage(tempFilePath);
        }
        log.info("[createThumbNail] [Html] -> [ThumbNail|PNG] Success");
        try {
            int thumbnail_width = 110;
            int thumbnail_height = 120;
            File origin_file_name = new File(tempFilePath);
            File thumb_file_name = new File(filePath);
            BufferedImage buffer_original_image = ImageIO.read(origin_file_name);
            BufferedImage buffer_thumbnail_image = new BufferedImage(thumbnail_width, thumbnail_height, 5);
            Graphics2D graphic = buffer_thumbnail_image.createGraphics();
            graphic.drawImage(buffer_original_image, 0, 0, thumbnail_width, thumbnail_height, null);
            ImageIO.write((RenderedImage)buffer_thumbnail_image, "jpg", thumb_file_name);
            origin_file_name.delete();
            log.info("[createThumbNail] [PNG] -> [ThumbNail|JPG] Success");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

