/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign.single;

import com.humuson.tms.common.util.MaskingUtil;
import com.humuson.tms.config.TmsConfig;
import com.humuson.tms.convert.aop.ConvertTarget;
import com.humuson.tms.convert.bind.DecryptAndMasking;
import com.humuson.tms.mapper.campaign.single.CampaignSingleTestMapper;
import com.humuson.tms.model.CampaignChannelInfo;
import com.humuson.tms.model.account.TmsTestUserInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.CommonCodeService;
import com.humuson.tms.service.MemberFieldSecurityService;
import com.humuson.tms.service.campaign.single.CampaignSingleTestService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CampaignSingleTestServiceImpl
implements CampaignSingleTestService {
    private static final Logger log = LoggerFactory.getLogger(CampaignSingleTestServiceImpl.class);
    @Autowired
    TmsConfig tmsConfig;
    @Autowired
    CampaignSingleTestMapper campaignSingleTestMapper;
    @Autowired
    CommonCodeService commonCodeService;
    @Autowired
    MemberFieldSecurityService memberFieldSecurityService;

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<TmsTestUserInfo> testUserList(TmsUserSession tmsUserSession, int appGrpId, String channelType) {
        List<TmsTestUserInfo> list = this.campaignSingleTestMapper.testUserList(tmsUserSession, appGrpId, channelType);
        for (TmsTestUserInfo user : list) {
            user.setEmail(user.getMemberEmail());
            user.setPhone(user.getMemberPhone());
        }
        return list;
    }

    @Override
    public int insertTestSend(Map<String, String> param) {
        int resultCnt = this.campaignSingleTestMapper.insertTestSend(param);
        return resultCnt;
    }

    @Override
    public List<CampaignChannelInfo> selectPostId(String msgId, String abTestYn) {
        if (abTestYn.equals("Y")) {
            return this.campaignSingleTestMapper.selectABPostId(msgId);
        }
        return this.campaignSingleTestMapper.selectPostId(msgId);
    }

    @Override
    public List<Map<String, String>> selectTestSendList(String msgId) {
        List<Map<String, String>> testSendList = this.campaignSingleTestMapper.selectTestSendList(msgId);
        ArrayList<Map<String, String>> newTestSendList = new ArrayList<Map<String, String>>();
        if (!this.tmsConfig.isMemberFieldEncrypted()) {
            return testSendList;
        }
        for (Map<String, String> testSendMap : testSendList) {
            if (testSendMap.get("channelType").equals("PU")) {
                return testSendList;
            }
            String sendList = testSendMap.get("list");
            String newSendList = "";
            String[] memberInfo = sendList.split(":");
            for (int i = 0; i < memberInfo.length; ++i) {
                String info = memberInfo[i];
                log.info("info : {}", (Object)info);
                info = this.memberFieldSecurityService.decrypt(info);
                info = MaskingUtil.getMaskedStr((String)info);
                newSendList = newSendList + info;
                if (i == memberInfo.length - 1) continue;
                newSendList = newSendList + ":";
            }
            testSendMap.put("list", newSendList);
            newTestSendList.add(testSendMap);
        }
        return newTestSendList;
    }
}

