/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign.single;

import com.humuson.tms.common.util.ExcelDataConvertor;
import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.common.util.SiteUtil;
import com.humuson.tms.config.TmsConfig;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.constrants.ContentType;
import com.humuson.tms.constrants.StatusType;
import com.humuson.tms.convert.aop.ConvertTarget;
import com.humuson.tms.convert.bind.Decrypt;
import com.humuson.tms.convert.bind.DecryptAndMasking;
import com.humuson.tms.convert.bind.Encrypt;
import com.humuson.tms.mapper.TmsCampLinkInfoMapper;
import com.humuson.tms.mapper.campaign.TmsCampChnInfoMapper;
import com.humuson.tms.mapper.campaign.TmsCampMsgInfoMapper;
import com.humuson.tms.mapper.campaign.TmsCampSchdInfoMapper;
import com.humuson.tms.mapper.campaign.single.CampaignSingleManagerMapper;
import com.humuson.tms.model.CampSchdInfo;
import com.humuson.tms.model.CampaignChannelInfo;
import com.humuson.tms.model.CampaignMsgInfo;
import com.humuson.tms.model.MappingCodeInfo;
import com.humuson.tms.model.MassSendListInfo;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.TargetConditionInfo;
import com.humuson.tms.model.TargetServerInfo;
import com.humuson.tms.model.TargetTableQueryInfo;
import com.humuson.tms.model.TmsCampChnInfo;
import com.humuson.tms.model.system.TmsTargetTableConditionInfo;
import com.humuson.tms.model.targeting.TmsCampTargetInfo;
import com.humuson.tms.model.targeting.TmsCampTargetTableInfo;
import com.humuson.tms.model.vo.EntityMap;
import com.humuson.tms.model.vo.TmsMemberInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.CommonCodeService;
import com.humuson.tms.service.MemberFieldSecurityService;
import com.humuson.tms.service.campaign.single.CampaignSingleManagerService;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class CampaignSingleManagerServiceImpl
implements CampaignSingleManagerService {
    private static final Logger log = LoggerFactory.getLogger(CampaignSingleManagerServiceImpl.class);
    @Autowired
    TmsConfig tmsConfig;
    @Value(value="${camp.content.path}")
    private String fileMsgUploadPath;
    @Value(value="${target.upload.path}")
    private String path;
    @Autowired
    private CampaignSingleManagerMapper campaignSingleManagerMapper;
    @Autowired
    private TmsCampMsgInfoMapper tmsCampMsgInfoMapper;
    @Autowired
    private TmsCampLinkInfoMapper tmsCampLinkInfoMapper;
    @Autowired
    private TmsCampChnInfoMapper tmsCampChnInfoMapper;
    @Autowired
    private TmsCampSchdInfoMapper tmsCampSchdInfoMapper;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    MemberFieldSecurityService memberFieldSecurityService;

    @Override
    public List<CampaignMsgInfo> selectCampMsgInfo(String msgId) {
        log.info("msgId : {}", (Object)msgId);
        return this.campaignSingleManagerMapper.selectCampMsgInfo(msgId);
    }

    @Override
    public int insertCampMsg(CampaignMsgInfo campaignMsgInfo) {
        return this.campaignSingleManagerMapper.insertCampMsg(campaignMsgInfo);
    }

    @Override
    public int saveCampChannelInfo(CampaignChannelInfo campaignChannelInfo) {
        return this.campaignSingleManagerMapper.saveCampChannelInfo(campaignChannelInfo);
    }

    @Override
    public String getMktYnByMsgId(String msgId) {
        return this.tmsCampMsgInfoMapper.getMktYnByMsgId(msgId);
    }

    @Override
    public String insertCampaignMsgChn(CampaignMsgInfo campaignMsgInfo, CampaignChannelInfo campaignChannelInfo) {
        String[] msgNameArray = new String[]{"Type A_", "Type B_", "Type C_", "Type D_", "Type E_", "Type F_"};
        String resultMsgId = "fail";
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Date now = new Date();
        String today = format.format(now);
        if (campaignMsgInfo.getAbTestYn().equals("N")) {
            log.info("AB TEST OFF");
            int todayMsgCnt = this.selectCountMsgId();
            int todayChnCnt = this.selectCountChnId();
            if (todayMsgCnt == 0) {
                campaignMsgInfo.setMsgId(today + "00001");
            } else {
                campaignMsgInfo.setMsgId(this.selectMsgId());
            }
            campaignChannelInfo.setMsgId(campaignMsgInfo.getMsgId());
            if (todayChnCnt == 0) {
                campaignChannelInfo.setPostId(today + "00001");
            }
            campaignChannelInfo.setChannelMsgName(campaignMsgInfo.getMsgName());
            this.insertCampMsg(campaignMsgInfo);
            this.saveCampChannelInfo(campaignChannelInfo);
            resultMsgId = campaignMsgInfo.getMsgId();
        } else {
            log.info("AB TEST ON");
            int todayMsgCnt = this.selectCountMsgId();
            int todayChnCnt = this.selectCountChnId();
            if (todayMsgCnt == 0) {
                campaignMsgInfo.setMsgId(today + "00001");
            } else {
                campaignMsgInfo.setMsgId(this.selectMsgId());
            }
            this.insertCampMsg(campaignMsgInfo);
            campaignChannelInfo.setMsgId(campaignMsgInfo.getMsgId());
            for (int i = 0; i < campaignMsgInfo.getAbTestCount(); ++i) {
                campaignChannelInfo.setChannelMsgName(msgNameArray[i] + campaignMsgInfo.getMsgName());
                if (todayChnCnt == 0 && i == 0) {
                    campaignChannelInfo.setPostId(today + "00001");
                } else {
                    campaignChannelInfo.setPostId(null);
                }
                this.saveCampChannelInfo(campaignChannelInfo);
            }
            campaignChannelInfo.setChannelMsgName("AB result_" + campaignMsgInfo.getMsgName());
            this.saveCampChannelInfo(campaignChannelInfo);
            resultMsgId = campaignMsgInfo.getMsgId();
        }
        return resultMsgId;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int updateCampaignMsgChn(Map<String, String> params) {
        String msgName = params.get("msgName");
        String campId = params.get("campId");
        String msgId = params.get("msgId");
        String channelType = params.get("channelType");
        String abTestYn = params.get("abTestYn");
        String filterUseYn = params.get("filterUseYn");
        String kakaoType = params.get("kakaoType");
        CampaignMsgInfo msgInfo = new CampaignMsgInfo();
        msgInfo.setMsgName(msgName);
        msgInfo.setCampId(campId);
        msgInfo.setMsgId(msgId);
        msgInfo.setChannelType(channelType);
        msgInfo.setAbTestYn(abTestYn);
        CampaignChannelInfo channelInfo = new CampaignChannelInfo();
        channelInfo.setMsgName(msgName);
        channelInfo.setCampId(campId);
        channelInfo.setMsgId(msgId);
        channelInfo.setChannelType(channelType);
        channelInfo.setAbTestYn(abTestYn);
        channelInfo.setFilterUseYn(filterUseYn);
        channelInfo.setKakaoType(kakaoType);
        int msgResult = this.campaignSingleManagerMapper.updateCampMsgInfo(msgInfo);
        int channelResult = this.campaignSingleManagerMapper.updateCampChannelInfo(channelInfo);
        return msgResult * channelResult;
    }

    @Override
    public String selectChnId() {
        return this.campaignSingleManagerMapper.selectChnId();
    }

    @Override
    public String selectMsgId() {
        return this.campaignSingleManagerMapper.selectMsgId();
    }

    @Override
    public int selectCountChnId() {
        return this.campaignSingleManagerMapper.selectCountChnId();
    }

    @Override
    public int selectCountMsgId() {
        return this.campaignSingleManagerMapper.selectCountMsgId();
    }

    @Override
    public List<CampaignChannelInfo> selectChnInfo(String msgId) {
        return this.campaignSingleManagerMapper.selectPushChnInfo(msgId);
    }

    @Override
    public List<CampaignChannelInfo> getContent(List<CampaignChannelInfo> list) {
        String html_base_path = this.fileMsgUploadPath;
        for (int i = 0; i < list.size(); ++i) {
            String content;
            String thisContentPath;
            CampaignChannelInfo channelInfo = list.get(i);
            if (ChannelType.PUSH.same(channelInfo.getChannelType())) {
                if (channelInfo.getContentHtml() != null && !channelInfo.getContentHtml().equals("")) {
                    thisContentPath = html_base_path + "/" + channelInfo.getContentHtml();
                    try {
                        content = FileUtil.readLocal((String)thisContentPath);
                        if (ContentType.RICH_PUSH.same(channelInfo.getContentType())) {
                            String[] contents = content.split("/\\*\\*PUSH_DELIM\\*\\*/");
                            String popupContent = "";
                            String inAppContent = "";
                            if (contents.length > 0) {
                                popupContent = contents[0];
                                inAppContent = contents[1];
                            }
                            list.get(i).setPopupContent(popupContent);
                            list.get(i).setInAppContent(inAppContent);
                            continue;
                        }
                        list.get(i).setInAppContent(content);
                    }
                    catch (IOException e) {
                        log.error("file read local error : {}", (Throwable)e);
                    }
                    continue;
                }
                list.get(i).setPopupContent("");
                list.get(i).setInAppContent("");
                continue;
            }
            if (ChannelType.EMAIL.same(channelInfo.getChannelType())) {
                if (channelInfo.getContentHtml() == null || channelInfo.getContentHtml().equals("")) continue;
                thisContentPath = html_base_path + "/" + channelInfo.getContentHtml();
                try {
                    content = FileUtil.readLocal((String)thisContentPath);
                    list.get(i).setEmailContent(content);
                }
                catch (IOException e) {
                    log.error("file read local error : {}", (Throwable)e);
                }
                continue;
            }
            if (ChannelType.SMS.same(channelInfo.getChannelType())) {
                if (channelInfo.getContentHtml() == null || channelInfo.getContentHtml().equals("")) continue;
                thisContentPath = html_base_path + "/" + channelInfo.getContentHtml();
                try {
                    content = FileUtil.readLocal((String)thisContentPath);
                    list.get(i).setSmsContent(content);
                }
                catch (IOException e) {
                    log.error("file read local error : {}", (Throwable)e);
                }
                continue;
            }
            if (!ChannelType.KAKAO.same(channelInfo.getChannelType()) || channelInfo.getContentHtml() == null || channelInfo.getContentHtml().equals("")) continue;
            thisContentPath = html_base_path + "/" + channelInfo.getContentHtml();
            try {
                content = FileUtil.readLocal((String)thisContentPath);
                list.get(i).setKakaoContent(content);
                continue;
            }
            catch (IOException e) {
                log.error("file read local error : {}", (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public int updatePushMsg(CampaignChannelInfo campaignChannelInfo) {
        return this.campaignSingleManagerMapper.updatePushMsg(campaignChannelInfo);
    }

    @Override
    public String checkABComplete(String msgId) {
        int cnt = 0;
        String result = "complete";
        List<Object> list = new ArrayList();
        list = this.selectChnInfo(msgId);
        for (CampaignChannelInfo campaignChannelInfo : list) {
            if (campaignChannelInfo.getPushTitle() != "" && campaignChannelInfo.getPushTitle() != null && !campaignChannelInfo.getPushTitle().equals("")) continue;
            ++cnt;
        }
        if (cnt > 1) {
            result = "fail";
        }
        log.info("checkAB:" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String targetFileSave(Map<String, String> param, MultipartHttpServletRequest mpRequest) {
        Iterator fileNameIterator = mpRequest.getFileNames();
        String charSet = param.get("charSet");
        if (charSet == null) {
            log.info("file upload charset is null");
            charSet = "utf-8";
        }
        String fileName = "";
        InputStream stream = null;
        while (fileNameIterator.hasNext()) {
            int idx;
            String fileExt;
            MultipartFile multiFile = mpRequest.getFile((String)fileNameIterator.next());
            if (multiFile.getSize() <= 0L) continue;
            OutputStream bos = null;
            try {
                String t_fileName = multiFile.getOriginalFilename();
                stream = multiFile.getInputStream();
                int u = 0;
                do {
                    fileName = "tms_" + u + "_" + t_fileName;
                    ++u;
                } while (FileUtil.existsLocal((String)fileName, (String)this.path));
                bos = new FileOutputStream(this.path + "/" + fileName);
                fileName = this.path + "/" + fileName;
                int bytesRead = 0;
                byte[] buffer = new byte[8192];
                while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
            }
            catch (Exception e) {
                log.error("file write error", (Throwable)e);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception e) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e) {}
                }
            }
            if (!(fileExt = fileName.substring((idx = fileName.lastIndexOf(".")) + 1)).toUpperCase().equals("XLS") && !fileExt.toUpperCase().equals("XLSX")) continue;
            String csvFileName = fileName.substring(0, fileName.lastIndexOf(".")).concat(".txt");
            if (fileExt.toUpperCase().equals("XLSX")) {
                try {
                    ExcelDataConvertor.XSLXToCSV((String)fileName, (String)csvFileName, (String)charSet);
                }
                catch (Exception e) {
                    log.error("Xslx convert error", (Throwable)e);
                }
            } else if (fileExt.toUpperCase().equals("XLS")) {
                try {
                    ExcelDataConvertor.XSLToCSV((String)fileName, (String)csvFileName, (String)charSet);
                }
                catch (Exception e) {
                    log.error("Xslx convert error", (Throwable)e);
                }
            }
            fileName = csvFileName;
        }
        log.info("fileName :{}", (Object)fileName);
        return fileName;
    }

    @Override
    public int insertTargetServerTask(Map<String, String> param) {
        TargetServerInfo targetServerInfo = new TargetServerInfo();
        List<EntityMap> serverList = this.commonCodeService.commonCodeList("02");
        int insertCnt = 0;
        this.deleteTargetServer(param.get("msgId"));
        for (EntityMap server : serverList) {
            int rate;
            if (!param.containsKey(server.get("CODE1") + "_" + param.get("targetType") + "_SERVER_" + server.get("CODE4")) || (rate = Integer.parseInt(param.get(server.get("CODE1") + "_" + param.get("targetType") + "_SERVER_" + server.get("CODE4")))) == 0) continue;
            targetServerInfo.setChannelType(server.get("CODE1").toString());
            targetServerInfo.setPostId(param.get("postId"));
            targetServerInfo.setMsgId(param.get("msgId"));
            targetServerInfo.setServerId(server.get("CODE4").toString());
            targetServerInfo.setParticipationRate(rate);
            insertCnt += this.insertTargetServer(targetServerInfo);
        }
        return insertCnt;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int insertTargetAbTestTask(Map<String, String> param) {
        TargetServerInfo targetServerInfo = new TargetServerInfo();
        List<EntityMap> serverList = this.commonCodeService.commonCodeList("02");
        int insertCnt = 0;
        param.put("isAll", "Y");
        this.deleteTargetServer(param.get("msgId"));
        List<CampaignChannelInfo> postList = this.selectChnInfo(param.get("msgId"));
        for (CampaignChannelInfo postMap : postList) {
            targetServerInfo.setPostId(postMap.getPostId());
            targetServerInfo.setMsgId(postMap.getMsgId());
            for (EntityMap server : serverList) {
                int rate;
                if (!param.containsKey(server.get("CODE1") + "_" + param.get("targetType") + "_SERVER_" + server.get("CODE4")) || (rate = Integer.parseInt(param.get(server.get("CODE1") + "_" + param.get("targetType") + "_SERVER_" + server.get("CODE4")))) == 0) continue;
                targetServerInfo.setChannelType(server.get("CODE1").toString());
                targetServerInfo.setServerId(server.get("CODE4").toString());
                targetServerInfo.setParticipationRate(rate);
                insertCnt += this.insertTargetServer(targetServerInfo);
            }
        }
        return insertCnt;
    }

    @Override
    public int insertTargetServer(TargetServerInfo targetServerInfo) {
        return this.campaignSingleManagerMapper.insertTargetServer(targetServerInfo);
    }

    @Override
    public List<MappingCodeInfo> fileTargetMappingCode(String channelType) {
        return this.campaignSingleManagerMapper.fileTargetMappingCode(channelType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertTargetTask(Map<String, String> param) {
        TmsCampTargetInfo targetDataInfo = new TmsCampTargetInfo();
        int result = 0;
        targetDataInfo.setTargetType(param.get("targetType"));
        targetDataInfo.setChannelType(param.get("channelType"));
        targetDataInfo.setAbTestYn(param.get("abTestYn"));
        targetDataInfo.setRegId(param.get("regId"));
        targetDataInfo.setTargetFileHeadFlag(param.get("targetFileHeaderFlag"));
        targetDataInfo.setTargetFileDelim(param.get("targetFileDelim"));
        targetDataInfo.setUseCondition("N");
        targetDataInfo.setDeduplicationYn(param.get("deduplicationYn"));
        if (param.get("targetType").equals("FILE")) {
            targetDataInfo.setAddSiteUserYn(param.get("addSiteUserYn"));
            String FileName = param.get("FILE_NAME");
            int idx = FileName.lastIndexOf("/");
            String targetFileName = FileName.substring(idx + 1);
            targetDataInfo.setTargetFileName(targetFileName);
            targetDataInfo.setTargetStatus("T1");
            try {
                String tmpFileType = FileName.substring(FileName.lastIndexOf(".")).toUpperCase();
                if (tmpFileType.equals(".CSV")) {
                    targetDataInfo.setTargetFileEncoding("UTF-8");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                targetDataInfo.setTargetFileEncoding("UTF-8");
            }
            StringBuffer indexBuffer = new StringBuffer(256);
            int cnt = 1;
            String val = null;
            while ((val = param.get("idx" + cnt++)) != null) {
                indexBuffer.append(val + "|");
            }
            targetDataInfo.setTargetFileIdx(indexBuffer.substring(0, indexBuffer.length() - 1));
        }
        if (param.get("targetType").equals("DB")) {
            targetDataInfo.setAddSiteUserYn(param.get("addSiteUserDBYn"));
            targetDataInfo.setTargetDbId(param.get("targetDBId"));
            targetDataInfo.setTargetDbQuery(param.get("query"));
            targetDataInfo.setTargetStatus("T1");
        }
        if (param.get("targetType").equals("COND")) {
            targetDataInfo.setUsePlatform(param.get("usePlatform"));
            targetDataInfo.setUseLogin(param.get("useLogin"));
            targetDataInfo.setUseCondition(param.get("useCondition"));
            targetDataInfo.setAddSiteUserYn("N");
            targetDataInfo.setAppSessEnd(param.get("endDate").replaceAll("/", ""));
            targetDataInfo.setAppSessStart(param.get("startDate").replaceAll("/", ""));
            targetDataInfo.setTargetStatus("T1");
        }
        if (param.containsKey(param.get("targetType") + "_encrypt_yn")) {
            targetDataInfo.setEncryptYN(param.get(param.get("targetType") + "_encrypt_yn"));
        }
        if (param.get("targetType").equals("AMC")) {
            targetDataInfo.setAudienceSeq(param.get("audienceSeq"));
            targetDataInfo.setTargetStatus("T1");
        }
        targetDataInfo.setPostId(this.selectMaxPostId(param.get("msgId")));
        targetDataInfo.setMsgId(param.get("msgId"));
        result = this.insertTarget(targetDataInfo);
        return result;
    }

    @Override
    public int insertTarget(TmsCampTargetInfo targetDataInfo) {
        return this.campaignSingleManagerMapper.insertTarget(targetDataInfo);
    }

    @Override
    public List<TmsCampTargetInfo> targetInfoList(String msgId) {
        return this.campaignSingleManagerMapper.targetInfoList(msgId);
    }

    @Override
    public TmsCampTargetInfo targetInfoDetail(String msgId) {
        return this.campaignSingleManagerMapper.targetInfoDetail(msgId);
    }

    @Override
    public int updateTargetingReset(String msgId) {
        return this.campaignSingleManagerMapper.updateTargetingReset(msgId);
    }

    @Override
    public int updateTargetingStop(String msgId, String targetStatus) {
        return this.campaignSingleManagerMapper.updateTargetingStop(msgId, targetStatus);
    }

    @Override
    public int deleteTargetServer(String msgId) {
        return this.campaignSingleManagerMapper.deleteTargetServer(msgId);
    }

    @Override
    public List<TmsCampTargetInfo> tgtDBQueryList(String targetDBId, String regId) {
        return this.campaignSingleManagerMapper.tgtDBQueryList(targetDBId, regId);
    }

    @Override
    public List<TmsCampTargetTableInfo> selectTargetTableInfo(@Param(value="targetId") String targetDBId) {
        return this.campaignSingleManagerMapper.selectTargetTableInfo(targetDBId);
    }

    @Override
    public List<TmsTargetTableConditionInfo> tgtDBConditionCheckbox(@Param(value="targetId") String targetDBId) {
        return this.campaignSingleManagerMapper.tgtDBConditionCheckbox(targetDBId);
    }

    @Override
    public List<TmsTargetTableConditionInfo> tgtDBConditionTextbox(@Param(value="targetId") String targetDBId) {
        return this.campaignSingleManagerMapper.tgtDBConditionTextbox(targetDBId);
    }

    @Override
    public int tgtDBQueryCreate(TargetTableQueryInfo targetTableQueryInfo) {
        return this.campaignSingleManagerMapper.tgtDBQueryCreate(targetTableQueryInfo);
    }

    @Override
    public int tgtDBQuerySave(TargetTableQueryInfo targetTableQueryInfo) {
        return this.campaignSingleManagerMapper.tgtDBQuerySave(targetTableQueryInfo);
    }

    @Override
    public int tgtDBQueryDelete(TargetTableQueryInfo targetTableQueryInfo) {
        return this.campaignSingleManagerMapper.tgtDBQueryDelete(targetTableQueryInfo);
    }

    @Override
    public int insertSchedule(CampSchdInfo campSchdInfo) {
        return this.campaignSingleManagerMapper.insertSchedule(campSchdInfo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int emailSend(Map<String, String> param) {
        int resultCnt;
        block6: {
            List<CampaignChannelInfo> campaignChannelInfo;
            CampSchdInfo campSchdInfo;
            int j;
            String abTestYn;
            String servers;
            block5: {
                resultCnt = 0;
                servers = param.get("servers");
                String postId = param.get("postId");
                String msgId = param.get("msgId");
                abTestYn = param.get("abTestYn");
                j = 0;
                param.put("channelType", "EM");
                campSchdInfo = new CampSchdInfo();
                campSchdInfo.setChannelType("EM");
                campSchdInfo.setMsgId(param.get("msgId"));
                campSchdInfo.setPostId(postId);
                campSchdInfo.setReqDate(param.get("reqDate"));
                campSchdInfo.setApprovalReqYn(param.get("approvalReqYn"));
                campSchdInfo.setApprovalReqId(param.get("approvalReqId"));
                campaignChannelInfo = this.selectPostIdByAbTest(msgId);
                if (!abTestYn.equals("N") && abTestYn != null && !"".equals(abTestYn)) break block5;
                List<TargetServerInfo> targetServerInfo = this.selectServerInfo(campaignChannelInfo.get(0).getPostId());
                if (servers.equals("")) break block6;
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setPostId(campaignChannelInfo.get(0).getPostId());
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + campaignChannelInfo.get(0).getPostId()));
                    campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + campaignChannelInfo.get(0).getPostId())));
                    campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + campaignChannelInfo.get(0).getPostId())));
                    resultCnt += this.insertSchedule(campSchdInfo);
                }
                break block6;
            }
            List<TargetServerInfo> targetServerInfo = this.selectServerInfo(campaignChannelInfo.get(0).getPostId());
            if (!servers.equals("")) {
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    for (j = 0; j < campaignChannelInfo.size(); ++j) {
                        if (campaignChannelInfo.get(j).getPostId().equals(campaignChannelInfo.get(j).getPPostId())) {
                            campSchdInfo.setAbTestYn(abTestYn);
                        }
                        campSchdInfo.setPostId(campaignChannelInfo.get(j).getPostId());
                        campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + campaignChannelInfo.get(j).getPostId()));
                        campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + campaignChannelInfo.get(j).getPostId())));
                        campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + campaignChannelInfo.get(j).getPostId())));
                        resultCnt += this.insertSchedule(campSchdInfo);
                    }
                    campSchdInfo.setAbTestYn("N");
                }
            }
        }
        return resultCnt;
    }

    @Override
    @Transactional
    public int smsSend(Map<String, String> param) {
        int resultCnt;
        block6: {
            List<CampaignChannelInfo> campaignChannelInfo;
            CampSchdInfo campSchdInfo;
            String abTestYn;
            String servers;
            int j;
            block5: {
                resultCnt = 0;
                j = 0;
                servers = param.get("servers");
                String postId = param.get("postId");
                String msgId = param.get("msgId");
                abTestYn = param.get("abTestYn");
                param.put("channelType", "SM");
                campSchdInfo = new CampSchdInfo();
                campSchdInfo.setChannelType("SM");
                campSchdInfo.setMsgId(param.get("msgId"));
                campSchdInfo.setPostId(postId);
                campSchdInfo.setReqDate(param.get("reqDate"));
                campSchdInfo.setApprovalReqYn(param.get("approvalReqYn"));
                campSchdInfo.setApprovalReqId(param.get("approvalReqId"));
                campaignChannelInfo = this.selectPostIdByAbTest(msgId);
                if (!abTestYn.equals("N") && abTestYn != null && !"".equals(abTestYn)) break block5;
                List<TargetServerInfo> targetServerInfo = this.selectServerInfo(campaignChannelInfo.get(0).getPostId());
                if (servers.equals("")) break block6;
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setPostId(campaignChannelInfo.get(0).getPostId());
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + campaignChannelInfo.get(0).getPostId()));
                    campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + campaignChannelInfo.get(0).getPostId())));
                    campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + campaignChannelInfo.get(0).getPostId())));
                    resultCnt += this.insertSchedule(campSchdInfo);
                }
                break block6;
            }
            List<TargetServerInfo> targetServerInfo = this.selectServerInfo(campaignChannelInfo.get(0).getPostId());
            if (!servers.equals("")) {
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    for (j = 0; j < campaignChannelInfo.size(); ++j) {
                        if (campaignChannelInfo.get(j).getPostId().equals(campaignChannelInfo.get(j).getPPostId())) {
                            campSchdInfo.setAbTestYn(abTestYn);
                        }
                        campSchdInfo.setPostId(campaignChannelInfo.get(j).getPostId());
                        campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + campaignChannelInfo.get(j).getPostId()));
                        campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + campaignChannelInfo.get(j).getPostId())));
                        campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + campaignChannelInfo.get(j).getPostId())));
                        resultCnt += this.insertSchedule(campSchdInfo);
                    }
                    campSchdInfo.setAbTestYn("N");
                }
            }
        }
        return resultCnt;
    }

    @Override
    @Transactional
    public int kakaoSend(Map<String, String> param) {
        int resultCnt = 0;
        boolean j = false;
        String servers = param.get("servers");
        String postId = param.get("postId");
        String msgId = param.get("msgId");
        String abTestYn = param.get("abTestYn");
        param.put("channelType", "KA");
        CampSchdInfo campSchdInfo = new CampSchdInfo();
        campSchdInfo.setChannelType("KA");
        campSchdInfo.setMsgId(param.get("msgId"));
        campSchdInfo.setPostId(postId);
        campSchdInfo.setReqDate(param.get("reqDate"));
        campSchdInfo.setApprovalReqYn(param.get("approvalReqYn"));
        campSchdInfo.setApprovalReqId(param.get("approvalReqId"));
        List<CampaignChannelInfo> campaignChannelInfo = this.selectPostIdByAbTest(msgId);
        if (abTestYn.equals("N") || abTestYn == null || "".equals(abTestYn)) {
            List<TargetServerInfo> targetServerInfo = this.selectServerInfo(campaignChannelInfo.get(0).getPostId());
            if (!servers.equals("")) {
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setPostId(campaignChannelInfo.get(0).getPostId());
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + campaignChannelInfo.get(0).getPostId()));
                    campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + campaignChannelInfo.get(0).getPostId())));
                    campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + campaignChannelInfo.get(0).getPostId())));
                    resultCnt += this.insertSchedule(campSchdInfo);
                }
            }
        }
        return resultCnt;
    }

    @Override
    @Transactional
    public int pushSend(Map<String, String> param) {
        int resultCnt;
        block6: {
            List<CampaignChannelInfo> campaignChannelInfo;
            CampSchdInfo campSchdInfo;
            String abTestYn;
            String servers;
            int j;
            block5: {
                resultCnt = 0;
                j = 0;
                servers = param.get("servers");
                String postId = param.get("postId");
                String msgId = param.get("msgId");
                abTestYn = param.get("abTestYn");
                param.put("channelType", "PU");
                campSchdInfo = new CampSchdInfo();
                campSchdInfo.setChannelType("PU");
                campSchdInfo.setMsgId(param.get("msgId"));
                campSchdInfo.setPostId(postId);
                campSchdInfo.setReqDate(param.get("reqDate"));
                campSchdInfo.setApprovalReqYn(param.get("approvalReqYn"));
                campSchdInfo.setApprovalReqId(param.get("approvalReqId"));
                campaignChannelInfo = this.selectPostIdByAbTest(msgId);
                if (!abTestYn.equals("N") && abTestYn != null && !"".equals(abTestYn)) break block5;
                List<TargetServerInfo> targetServerInfo = this.selectServerInfo(campaignChannelInfo.get(0).getPostId());
                if (servers.equals("")) break block6;
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setPostId(campaignChannelInfo.get(0).getPostId());
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + campaignChannelInfo.get(0).getPostId()));
                    campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + campaignChannelInfo.get(0).getPostId())));
                    campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + campaignChannelInfo.get(0).getPostId())));
                    resultCnt += this.insertSchedule(campSchdInfo);
                }
                break block6;
            }
            List<TargetServerInfo> targetServerInfo = this.selectServerInfo(campaignChannelInfo.get(0).getPostId());
            if (!servers.equals("")) {
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    for (j = 0; j < campaignChannelInfo.size(); ++j) {
                        if (campaignChannelInfo.get(j).getPostId().equals(campaignChannelInfo.get(j).getPPostId())) {
                            log.info("serverId:{}, postId:{}, pPostId:{}", new Object[]{targetServerInfo.get(i).getServerId(), campaignChannelInfo.get(j).getPostId(), campaignChannelInfo.get(j).getPPostId()});
                            campSchdInfo.setAbTestYn(abTestYn);
                        }
                        campSchdInfo.setPostId(campaignChannelInfo.get(j).getPostId());
                        campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + campaignChannelInfo.get(j).getPostId()));
                        campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + campaignChannelInfo.get(j).getPostId())));
                        campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + campaignChannelInfo.get(j).getPostId())));
                        resultCnt += this.insertSchedule(campSchdInfo);
                    }
                    campSchdInfo.setAbTestYn("N");
                }
            }
        }
        return resultCnt;
    }

    @Override
    @Transactional
    public String updatePostIdTask(String abTestYn, String msgId) {
        String pPostId = "";
        if (abTestYn.equals("Y")) {
            pPostId = this.selectMaxPostId(msgId);
            this.updatePostId(msgId, pPostId);
        }
        return pPostId;
    }

    @Override
    public CampaignChannelInfo selectChannelInfo(String postId, String channelType) {
        return this.campaignSingleManagerMapper.selectChannelInfo(postId, channelType);
    }

    @Override
    public List<CampSchdInfo> checkSchdInfo(String msgId) {
        return this.campaignSingleManagerMapper.checkSchdInfo(msgId);
    }

    @Override
    public List<EntityMap> commonServerList(String msgId) {
        return this.campaignSingleManagerMapper.commonServerList(msgId);
    }

    @Override
    public CampaignChannelInfo messageChannelInfos(String postId, String msgId, String abTestYn, String channelType) {
        return this.campaignSingleManagerMapper.messageChannelInfos(postId, msgId, abTestYn, channelType);
    }

    @Override
    public List<CampaignMsgInfo> messageInfo(String msgId) {
        return this.campaignSingleManagerMapper.messageInfo(msgId);
    }

    @Override
    public List<CampaignChannelInfo> selectPostIdByAbTest(String msgId) {
        return this.campaignSingleManagerMapper.selectPostIdByAbTest(msgId);
    }

    @Override
    public List<TargetServerInfo> selectServerInfo(String postId) {
        return this.campaignSingleManagerMapper.selectServerInfo(postId);
    }

    @Override
    public int deleteCampaign(String msgId) {
        return this.campaignSingleManagerMapper.deleteCampaign(msgId);
    }

    @Override
    public List<TargetConditionInfo> selectTargetClass() {
        return this.campaignSingleManagerMapper.selectTargetClass();
    }

    @Override
    public List<Map<String, String>> selectTargetClassDetail(String infoCode) {
        return this.campaignSingleManagerMapper.selectTargetClassDetail(infoCode);
    }

    @Override
    public int insertTargetConditionData(TargetConditionInfo targetConditionInfo) {
        return this.campaignSingleManagerMapper.insertTargetConditionData(targetConditionInfo);
    }

    @Override
    public String selectMaxPostId(String msgId) {
        return this.campaignSingleManagerMapper.selectMaxPostId(msgId);
    }

    @Override
    public int updatePostId(String msgId, String pPostId) {
        return this.campaignSingleManagerMapper.updatePostId(msgId, pPostId);
    }

    @Override
    public List<EntityMap> selectTargetStatus(Map<String, String> params) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(params);
        return this.campaignSingleManagerMapper.selectTargetInfo(entityMap);
    }

    @Override
    public int selectSchdInfoCnt(Map<String, String> params) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(params);
        return this.campaignSingleManagerMapper.selectSchdInfoCnt(entityMap);
    }

    @Override
    public String selectReqDate(String msgId) {
        return this.campaignSingleManagerMapper.selectReqDate(msgId);
    }

    @Override
    public List<EntityMap> selectCampMsg(Map<String, String> params) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(params);
        entityMap.put("CHANNEL_TYPE", (Object)ChannelType.EMAIL.getCode());
        return this.campaignSingleManagerMapper.selectCampMsg(entityMap);
    }

    @Override
    public List<EntityMap> selectCampMsgByPostId(Map<String, String> params) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(params);
        entityMap.put("CHANNEL_TYPE", (Object)ChannelType.EMAIL.getCode());
        return this.campaignSingleManagerMapper.selectCampMsgByPostId(entityMap);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> randomTargetList(String msgId) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.targetListTable();
        log.info(ms.toString());
        List<MassSendListInfo> masssendList = this.campaignSingleManagerMapper.randomTargetList(ms);
        return masssendList;
    }

    @Override
    public String selectAppImg(String appGrpId) {
        return this.campaignSingleManagerMapper.selectAppImg(appGrpId);
    }

    @Override
    public int sendResendSchduleInfo(String msgId, String postId, String serverId) {
        return this.campaignSingleManagerMapper.sendResendSchduleInfo(msgId, postId, serverId);
    }

    @Override
    public int sendErrResendSchduleInfo(String msgId, String postId, String serverId) {
        return this.campaignSingleManagerMapper.sendErrResendSchduleInfo(msgId, postId, serverId);
    }

    @Override
    public Map<String, Object> sendResendSchduleCheck(String msgId, String postId, String jobStatus) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int hour = this.campaignSingleManagerMapper.sendResendSchduleHourCheck(msgId, postId, jobStatus);
        int day = this.campaignSingleManagerMapper.sendResendSchduleDayCheck(msgId, postId, jobStatus);
        if (hour > 0) {
            result.put("HOUR_YN", "Y");
        } else {
            result.put("HOUR_YN", "N");
        }
        if (day > 0) {
            result.put("DAY_YN", "Y");
        } else {
            result.put("DAY_YN", "N");
        }
        if (hour > 0 && day > 0 || StatusType.ERROR.getCode().equals(jobStatus) || StatusType.STOP_SEND_COMPLETE.getCode().equals(jobStatus)) {
            result.put("RESEND_YN", "Y");
        }
        return result;
    }

    @Override
    public int sendApprovalSchduleInfo(String msgId, String postId, String serverId, String userId) {
        return this.campaignSingleManagerMapper.sendApprovalSchduleInfo(msgId, postId, serverId, userId);
    }

    @Override
    public int sendApprovalRequestSchduleInfo(String msgId, String postId, String serverId, String userId) {
        return this.campaignSingleManagerMapper.sendApprovalRequestSchduleInfo(msgId, postId, serverId, userId);
    }

    @Override
    public int sendApprovalRejectedSchdUpdate(String msgId, String postId, String serverId, String userId) {
        return this.campaignSingleManagerMapper.sendApprovalRejectedSchdUpdate(msgId, postId, serverId, userId);
    }

    @Override
    public int sendApprovalRejectSchduleInfo(String msgId, String postId, String serverId, String userId) {
        return this.campaignSingleManagerMapper.sendApprovalRejectSchduleInfo(msgId, postId, serverId, userId);
    }

    @Override
    public int sendSchduleInfoUpdate(String msgId, String postId, String serverId, String reqDate) {
        return this.campaignSingleManagerMapper.sendSchduleInfoUpdate(msgId, postId, serverId, reqDate);
    }

    @Override
    public int sendStopSchduleInfo(String msgId, String postId, String serverId) {
        return this.campaignSingleManagerMapper.sendStopSchduleInfo(msgId, postId, serverId);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> randomTargetListByMemberId(String msgId, String memberId) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.setMEMBER_ID(memberId);
        ms.targetListTable();
        log.info(ms.toString());
        List<MassSendListInfo> masssendList = this.campaignSingleManagerMapper.randomTargetListByMemberId(ms);
        return masssendList;
    }

    @Override
    public int deleteConditionTarget(String msgId) {
        return this.campaignSingleManagerMapper.deleteConditionTarget(msgId);
    }

    @Override
    public List<CampaignChannelInfo> selectCopyList(TmsUserSession tmsUserSession, PageInfo pageInfo, String channelType, String regId, int siteId, String searchValue, String deptId, String kakaoType) {
        pageInfo.calculate(this.selectCountCopyList(tmsUserSession, channelType, regId, siteId, searchValue, deptId, kakaoType));
        return this.campaignSingleManagerMapper.selectCopyList(tmsUserSession, pageInfo, channelType, regId, siteId, searchValue, deptId, kakaoType);
    }

    @Override
    public int selectCountCopyList(TmsUserSession tmsUserSession, String channelType, String regId, int siteId, String searchValue, String deptId, String kakaoType) {
        return this.campaignSingleManagerMapper.selectCountCopyList(tmsUserSession, channelType, regId, siteId, searchValue, deptId, kakaoType);
    }

    @Override
    public List<CampaignChannelInfo> selectCopyChnInfo(String postId) {
        return this.campaignSingleManagerMapper.selectCopyChnInfo(postId);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> targetList(MassSendListInfo msSendListInfo, PageInfo pageInfo) {
        List<TmsCampChnInfo> campChnInfoList = this.selectCampChnInfoByMsgId(msSendListInfo.getMSG_ID());
        pageInfo.calculate(this.campaignSingleManagerMapper.targetTotal(msSendListInfo, campChnInfoList));
        return this.campaignSingleManagerMapper.targetList(msSendListInfo, pageInfo, campChnInfoList);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> targetErrList(MassSendListInfo msSendListInfo, PageInfo pageInfo) {
        String searchType = msSendListInfo.getSearchType();
        String searchWord = msSendListInfo.getSearchWord();
        String channelType = msSendListInfo.getCHANNEL_TYPE();
        boolean isEncryptSearchWord = false;
        if (!"".equals(searchType) && searchType != null) {
            boolean bl = isEncryptSearchWord = (channelType.equalsIgnoreCase(ChannelType.EMAIL.getCode()) || channelType.equalsIgnoreCase(ChannelType.SMS.getCode())) && this.tmsConfig.isMemberFieldEncrypted();
        }
        if (!"".equals(searchWord) && searchWord != null) {
            msSendListInfo.setSearchWord(isEncryptSearchWord && "DUPLICATE_KEY".equals(searchType) ? this.memberFieldSecurityService.encrypt(searchWord) : searchWord);
        }
        pageInfo.calculate(this.campaignSingleManagerMapper.targetErrTotal(msSendListInfo));
        return this.campaignSingleManagerMapper.targetErrList(msSendListInfo, pageInfo);
    }

    @Override
    public int targetDuplCheck(MassSendListInfo msSendListInfo) {
        return this.campaignSingleManagerMapper.targetDuplCheck(msSendListInfo);
    }

    @Override
    @ConvertTarget
    public int registTarget(@Encrypt MassSendListInfo msSendListInfo) {
        String serverId = this.campaignSingleManagerMapper.randomServerId(msSendListInfo.getMSG_ID());
        msSendListInfo.setSERVER_ID(serverId);
        return this.campaignSingleManagerMapper.registTarget(msSendListInfo);
    }

    @Override
    public int updateTargetCnt(MassSendListInfo msSendListInfo, int targetCnt, String updateType) {
        return this.campaignSingleManagerMapper.updateTargetCnt(msSendListInfo, targetCnt, updateType);
    }

    @Override
    public int updateTargetServerCnt(MassSendListInfo msSendListInfo, int targetCnt, String updateType) {
        return this.campaignSingleManagerMapper.updateTargetServerCnt(msSendListInfo, targetCnt, updateType);
    }

    @Override
    public int deleteTarget(MassSendListInfo msSendListInfo) {
        return this.campaignSingleManagerMapper.deleteTarget(msSendListInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<TmsMemberInfo> memberList(String custId, String siteId, int appGrpId) {
        TmsMemberInfo tmsMemberInfo = new TmsMemberInfo();
        tmsMemberInfo.setCustId(custId);
        tmsMemberInfo.setSiteId(siteId);
        tmsMemberInfo.setAppGrpId(String.valueOf(appGrpId));
        return this.campaignSingleManagerMapper.memberList(tmsMemberInfo);
    }

    @Override
    @ConvertTarget
    @Decrypt
    public TmsMemberInfo memberInfo(String custId, String siteId) {
        return this.memberInfo(custId, siteId, null);
    }

    @Override
    @ConvertTarget
    @Decrypt
    public TmsMemberInfo memberInfo(String custId, String siteId, String appGrpId) {
        TmsMemberInfo tmsMemberInfo = new TmsMemberInfo();
        tmsMemberInfo.setCustId(custId);
        tmsMemberInfo.setSiteId(siteId);
        tmsMemberInfo.setAppGrpId(appGrpId);
        return this.campaignSingleManagerMapper.memberInfo(tmsMemberInfo);
    }

    @Override
    public void insertPushClickUrl(String postId, String pushContent) throws Exception {
        String[] splitPushContent = pushContent.split("/\\*\\*PUSH_DELIM\\*\\*/");
        if (splitPushContent.length == 2) {
            int i;
            String pushPopupContent = splitPushContent[0];
            String inAppMsg = splitPushContent[1];
            Map popupContentLinkUrl = SiteUtil.getLinkFromHtml((String)pushPopupContent);
            Map inAppMsgLinkUrl = SiteUtil.getLinkFromHtml((String)inAppMsg);
            int clickInsertCnt = 0;
            this.tmsCampLinkInfoMapper.deleteLinkInfo(postId);
            for (i = 1; i <= popupContentLinkUrl.size(); ++i) {
                clickInsertCnt = this.tmsCampLinkInfoMapper.insertLinkInfo(postId, "P" + String.format("%02d", i), (String)popupContentLinkUrl.get(i));
                if (clickInsertCnt != 0) continue;
                throw new Exception("Click Url Insert Fail Exception");
            }
            for (i = 1; i <= inAppMsgLinkUrl.size(); ++i) {
                clickInsertCnt = this.tmsCampLinkInfoMapper.insertLinkInfo(postId, "M" + String.format("%02d", i), (String)inAppMsgLinkUrl.get(i));
                if (clickInsertCnt != 0) continue;
                throw new Exception("Click Url Insert Fail Exception");
            }
        }
    }

    @Override
    public int updateDivideFlagCampMsgInfo(String msgId, String divideSendUseYn) {
        return this.tmsCampMsgInfoMapper.updateDivideFlagCampMsgInfo(msgId, divideSendUseYn);
    }

    @Override
    public List<TmsCampChnInfo> selectCampChnInfoByMsgId(String msgId) {
        return this.tmsCampChnInfoMapper.selectCampChnInfoByMsgId(msgId);
    }

    @Override
    public int updateCampChnInfo(String msgId, String postId, String divideSendUseYn, int divideCnt, int divideMinute) {
        return this.tmsCampChnInfoMapper.updateCampChnInfo(msgId, postId, divideSendUseYn, divideCnt, divideMinute);
    }

    @Override
    @Transactional
    public int campSchdDivideInfoUpdate(Map<String, String> param) {
        String msgId = param.get("msgId");
        List<CampSchdInfo> campSchdInfoList = this.tmsCampSchdInfoMapper.selectCampSchdInfo(msgId);
        int result = 1;
        for (CampSchdInfo campSchdInfo : campSchdInfoList) {
            result *= this.tmsCampSchdInfoMapper.updateSchdDivideInfo(msgId, campSchdInfo.getPostId(), param.get("divideDetailFlag_" + campSchdInfo.getPostId()), Integer.parseInt(param.get("divideCnt_" + campSchdInfo.getPostId())), Integer.parseInt(param.get("divideMinute_" + campSchdInfo.getPostId())));
        }
        return result;
    }

    @Override
    public int getAppGrpIdByMsgId(String msgId) {
        return this.campaignSingleManagerMapper.getAppGrpIdByMsgId(msgId);
    }

    @Override
    public int getAppGrpIdByDeviceId(long deviceId) {
        return this.campaignSingleManagerMapper.getAppGrpIdByDeviceId(deviceId);
    }
}

