/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign.multi;

import com.google.gson.Gson;
import com.humuson.tms.mapper.campaign.multi.CampaignMultiManagerMapper;
import com.humuson.tms.model.CampaignChannelInfo;
import com.humuson.tms.model.CampaignMsgInfo;
import com.humuson.tms.model.CampaignOptmzChnInfo;
import com.humuson.tms.model.MultiMsgPlanGson;
import com.humuson.tms.service.campaign.multi.CampaignMultiManagerService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CampaignMultiManagerServiceImpl
implements CampaignMultiManagerService {
    private static final Logger log = LoggerFactory.getLogger(CampaignMultiManagerServiceImpl.class);
    @Autowired
    private CampaignMultiManagerMapper campaignMultiManagerMapper;

    @Override
    public String getNewMsgId() {
        return this.campaignMultiManagerMapper.getNewMsgId();
    }

    @Override
    public String multiMsgChnSave(CampaignMsgInfo campaignMsgInfo, CampaignChannelInfo campaignChannelInfo) {
        String[] msgNameArray = new String[]{"Type A_", "Type B_", "Type C_", "Type D_", "Type E_", "Type F_"};
        String resultMsgId = "fail";
        String msgId = this.getNewMsgId();
        campaignMsgInfo.setMsgId(msgId);
        campaignChannelInfo.setMsgId(msgId);
        this.campaignMultiManagerMapper.multiMsgSave(campaignMsgInfo);
        if (campaignMsgInfo.getAbTestYn().equals("N")) {
            campaignChannelInfo.setChannelMsgName("1\ucc28_" + campaignMsgInfo.getMsgName());
            this.campaignMultiManagerMapper.saveCampChannelInfo(campaignChannelInfo);
            resultMsgId = campaignMsgInfo.getMsgId();
        } else {
            for (int i = 0; i < campaignMsgInfo.getAbTestCount(); ++i) {
                campaignChannelInfo.setChannelMsgName("1\ucc28_" + msgNameArray[i] + campaignMsgInfo.getMsgName());
                this.campaignMultiManagerMapper.saveCampChannelInfo(campaignChannelInfo);
            }
            campaignChannelInfo.setChannelMsgName("1\ucc28_AB result_" + campaignMsgInfo.getMsgName());
            this.campaignMultiManagerMapper.saveCampChannelInfo(campaignChannelInfo);
            resultMsgId = campaignMsgInfo.getMsgId();
        }
        return resultMsgId;
    }

    @Override
    @Transactional
    public String updatePostIdTask(String msgId, String abTestYn) {
        int result = 0;
        String pPostId = this.selectMaxPostId(msgId);
        if (abTestYn.equals("Y")) {
            result = this.updatePostId(msgId, pPostId);
        }
        return pPostId;
    }

    @Override
    @Transactional
    public Map<String, String> multiMsgPlanSave(String planJson, String regId, String removedPostIds, String filterUseYn) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("result", "N");
        String[] msgNameArray = new String[]{"Type A_", "Type B_", "Type C_", "Type D_", "Type E_", "Type F_"};
        String firstPpostId = "";
        String secondPpostId = "";
        String channelName = "";
        MultiMsgPlanGson multiMsgPlanGson = (MultiMsgPlanGson)new Gson().fromJson(planJson, MultiMsgPlanGson.class);
        String msgId = multiMsgPlanGson.getMsgId();
        firstPpostId = multiMsgPlanGson.getPostId();
        String channelType = multiMsgPlanGson.getChannel();
        if (firstPpostId.equals("") || firstPpostId == null) {
            log.info("firstPpostId \uc5c6\uc74c");
            return resultMap;
        }
        CampaignMsgInfo campaignMsgInfo = this.campaignMultiManagerMapper.getMsgInfo(msgId);
        if (channelType.equals("EM")) {
            channelName = "\uc774\uba54\uc77c";
        } else if (channelType.equals("SM")) {
            channelName = "\ubb38\uc790";
        } else if (channelType.equals("PU")) {
            channelName = "\ud478\uc2dc";
        }
        if (campaignMsgInfo.getAbTestYn().equals("N")) {
            this.campaignMultiManagerMapper.updateChnInfo("1\ucc28_" + campaignMsgInfo.getMsgName() + "_" + channelName, channelType, firstPpostId, filterUseYn);
        } else {
            List<Map<String, String>> postIdList = this.campaignMultiManagerMapper.getPostIds(msgId);
            for (int i = 0; i < postIdList.size(); ++i) {
                this.campaignMultiManagerMapper.updateChnInfo("1\ucc28_" + msgNameArray[i] + campaignMsgInfo.getMsgName() + "_" + channelName, channelType, postIdList.get(i).get("POST_ID"), filterUseYn);
            }
            this.campaignMultiManagerMapper.updateChnInfo("1\ucc28_AB result_" + campaignMsgInfo.getMsgName() + "_" + channelName, channelType, firstPpostId, filterUseYn);
        }
        if (this.campaignMultiManagerMapper.checkOptmzChnInfo(msgId) > 0) {
            this.campaignMultiManagerMapper.updateOptmzChnInfo(firstPpostId, channelType);
        } else {
            this.campaignMultiManagerMapper.insertOptmzChnInfo(firstPpostId, firstPpostId, multiMsgPlanGson.getMsgId(), multiMsgPlanGson.getChannel(), 1, multiMsgPlanGson.getTarget());
        }
        if (removedPostIds != null && !removedPostIds.equals("")) {
            String[] removePostIds;
            for (String postId : removePostIds = removedPostIds.split(",")) {
                this.campaignMultiManagerMapper.deleteChnInfo(postId);
                this.campaignMultiManagerMapper.deleteOptmzChnInfo(postId);
            }
        }
        for (MultiMsgPlanGson mChild : multiMsgPlanGson.getChildren().values()) {
            if (mChild.getChannel().equals("EM")) {
                channelName = "\uc774\uba54\uc77c";
            } else if (mChild.getChannel().equals("SM")) {
                channelName = "\ubb38\uc790";
            } else if (mChild.getChannel().equals("PU")) {
                channelName = "\ud478\uc2dc";
            }
            if (mChild.getPostId().equals("") || mChild.getPostId() == null) {
                String newPostId = this.campaignMultiManagerMapper.getNewPostId();
                mChild.setPostId(newPostId);
                this.campaignMultiManagerMapper.insertChildChnInfo(mChild.getChannel(), mChild.getPostId(), msgId, "2\ucc28_" + campaignMsgInfo.getMsgName() + "_" + channelName, regId, filterUseYn);
                if (mChild.getTimeUnit().equals("D")) {
                    mChild.setTimeValue(String.valueOf(Integer.parseInt(mChild.getTimeValue()) * 24));
                }
                this.campaignMultiManagerMapper.insertChildOptmzChnInfo(mChild.getPostId(), firstPpostId, msgId, mChild.getChannel(), 2, mChild.getTarget(), mChild.getTimeUnit(), mChild.getTimeValue());
                secondPpostId = mChild.getPostId();
            } else {
                this.campaignMultiManagerMapper.updateChildChnInfo("2\ucc28_" + campaignMsgInfo.getMsgName() + "_" + channelName, mChild.getPostId(), mChild.getChannel());
                if (mChild.getTimeUnit().equals("D")) {
                    mChild.setTimeValue(String.valueOf(Integer.parseInt(mChild.getTimeValue()) * 24));
                }
                this.campaignMultiManagerMapper.updateChildOptmzChnInfo(mChild.getPostId(), mChild.getChannel(), mChild.getTarget(), mChild.getTimeUnit(), mChild.getTimeValue());
                secondPpostId = mChild.getPostId();
            }
            for (MultiMsgPlanGson mmChild : mChild.getChildren().values()) {
                if (mmChild.getChannel().equals("EM")) {
                    channelName = "\uc774\uba54\uc77c";
                } else if (mmChild.getChannel().equals("SM")) {
                    channelName = "\ubb38\uc790";
                } else if (mmChild.getChannel().equals("PU")) {
                    channelName = "\ud478\uc2dc";
                }
                if (mmChild.getPostId().equals("") || mmChild.getPostId() == null) {
                    String newPostId = this.campaignMultiManagerMapper.getNewPostId();
                    mmChild.setPostId(newPostId);
                    this.campaignMultiManagerMapper.insertChildChnInfo(mmChild.getChannel(), mmChild.getPostId(), msgId, "3\ucc28_" + campaignMsgInfo.getMsgName() + "_" + channelName, regId, filterUseYn);
                    if (mmChild.getTimeUnit().equals("D")) {
                        mmChild.setTimeValue(String.valueOf(Integer.parseInt(mmChild.getTimeValue()) * 24));
                    }
                    this.campaignMultiManagerMapper.insertChildOptmzChnInfo(mmChild.getPostId(), secondPpostId, msgId, mmChild.getChannel(), 3, mmChild.getTarget(), mmChild.getTimeUnit(), mmChild.getTimeValue());
                    continue;
                }
                this.campaignMultiManagerMapper.updateChildChnInfo("3\ucc28_" + campaignMsgInfo.getMsgName() + "_" + channelName, mmChild.getPostId(), mmChild.getChannel());
                if (mmChild.getTimeUnit().equals("D")) {
                    mmChild.setTimeValue(String.valueOf(Integer.parseInt(mmChild.getTimeValue()) * 24));
                }
                this.campaignMultiManagerMapper.updateChildOptmzChnInfo(mmChild.getPostId(), mmChild.getChannel(), mmChild.getTarget(), mmChild.getTimeUnit(), mmChild.getTimeValue());
            }
        }
        resultMap.put("result", "Y");
        resultMap.put("channelType", channelType);
        return resultMap;
    }

    @Override
    public String selectMaxPostId(String msgId) {
        return this.campaignMultiManagerMapper.selectMaxPostId(msgId);
    }

    @Override
    public int updatePostId(String msgId, String pPostId) {
        return this.campaignMultiManagerMapper.updatePostId(msgId, pPostId);
    }

    @Override
    public MultiMsgPlanGson getMultiMsgPlan(String msgId) {
        MultiMsgPlanGson multiMsgPlanGson = new MultiMsgPlanGson();
        MultiMsgPlanGson childMsgPlanGson = new MultiMsgPlanGson();
        List<CampaignOptmzChnInfo> optmzPlanList = this.campaignMultiManagerMapper.selectOptmzPlan(msgId);
        for (CampaignOptmzChnInfo optmzChnInfo : optmzPlanList) {
            if (optmzChnInfo.getPostId().equals(optmzChnInfo.getPPostId())) {
                multiMsgPlanGson.setChannel(optmzChnInfo.getChannelType()).setPostId(optmzChnInfo.getPostId()).setTarget(optmzChnInfo.getTargetType()).setMsgId(optmzChnInfo.getMsgId()).setChildren(new HashMap<String, MultiMsgPlanGson>());
                continue;
            }
            childMsgPlanGson = new MultiMsgPlanGson();
            childMsgPlanGson.setChannel(optmzChnInfo.getChannelType()).setTarget(optmzChnInfo.getTargetType()).setTimeUnit(optmzChnInfo.getWaitType()).setTimeValue(optmzChnInfo.getWaitType().equals("D") ? String.valueOf(optmzChnInfo.getWaitHour() / 24) : optmzChnInfo.getWaitHour() + "").setPostId(optmzChnInfo.getPostId()).setPPostId(optmzChnInfo.getPPostId()).setChildren(new HashMap<String, MultiMsgPlanGson>());
            if (multiMsgPlanGson.getPostId().equals(optmzChnInfo.getPPostId())) {
                multiMsgPlanGson.getChildren().put(optmzChnInfo.getPostId(), childMsgPlanGson);
                continue;
            }
            if (multiMsgPlanGson.getChildren().get(optmzChnInfo.getPPostId()) == null) continue;
            multiMsgPlanGson.getChildren().get(optmzChnInfo.getPPostId()).getChildren().put(optmzChnInfo.getPostId(), childMsgPlanGson);
        }
        log.info("multiMsgPlanGson : {}", (Object)multiMsgPlanGson.toString());
        return multiMsgPlanGson;
    }

    @Override
    public String selectMsgChnList(String msgId) {
        return this.campaignMultiManagerMapper.selectMsgChnList(msgId);
    }

    @Override
    public CampaignChannelInfo selectFirstMsgChn(String msgId) {
        return this.campaignMultiManagerMapper.selectFirstMsgChn(msgId);
    }

    @Override
    public CampaignMsgInfo getMsgInfo(String msgId) {
        return this.campaignMultiManagerMapper.getMsgInfo(msgId);
    }

    @Override
    public int multiMsgUpdate(CampaignMsgInfo campaignMsgInfo) {
        return this.campaignMultiManagerMapper.multiMsgUpdate(campaignMsgInfo);
    }

    @Override
    public String getFirstPostId(String msgId) {
        return this.campaignMultiManagerMapper.getFirstPostId(msgId);
    }

    @Override
    public String getFirstChannelType(String postId) {
        return this.campaignMultiManagerMapper.getFirstChannelType(postId);
    }

    @Override
    public String getResultPostId(String msgId) {
        return this.campaignMultiManagerMapper.getResultPostId(msgId);
    }

    @Override
    public List<Map<String, String>> maxTimeValue() {
        return this.campaignMultiManagerMapper.maxTimeValue();
    }

    @Override
    public String selectFirstFilterUseYn(String msgId) {
        return this.campaignMultiManagerMapper.selectFirstFilterUseYn(msgId);
    }

    @Override
    public int updateMultiChn(String msgId, String filterUseYn) {
        return this.campaignMultiManagerMapper.updateMultiChn(msgId, filterUseYn);
    }

    @Override
    public String getPpostId(String msgId) {
        return this.campaignMultiManagerMapper.getPpostId(msgId);
    }
}

