/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign.approval;

import com.humuson.tms.mapper.campaign.approval.CampaignApprovalMapper;
import com.humuson.tms.model.MessageInfo;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.campaign.approval.CampaignApprovalService;
import com.humuson.tms.service.excel.FillManagerApproval;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CampaignApprovalServiceImpl
implements CampaignApprovalService {
    @Autowired
    private CampaignApprovalMapper campaignApprovalMapper;

    @Override
    public List<MessageInfo> approvalPagingMsgList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        if (param.get("msg_search_period") != null) {
            String[] period = param.get("msg_search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null) {
            String[] period = param.get("search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.campaignApprovalMapper.approvalMsgChnTotal(param, tmsUserSession));
        return this.campaignApprovalMapper.approvalPagingMsgList(pageInfo, param, tmsUserSession);
    }

    @Override
    public Map<String, List<MessageInfo>> approvalMsgChnList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        String endDate;
        String startDate;
        String[] period;
        if (param.get("msg_search_period") != null) {
            period = param.get("msg_search_period").split("-");
            startDate = period[0].trim();
            endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null) {
            period = param.get("search_period").split("-");
            startDate = period[0].trim();
            endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.campaignApprovalMapper.approvalMsgChnTotal(param, tmsUserSession));
        List<MessageInfo> allMsgChnList = this.campaignApprovalMapper.approvalMsgChnList(pageInfo, param, tmsUserSession);
        ArrayList<MessageInfo> msgChnList = null;
        HashMap<String, List<MessageInfo>> msgChnMap = new HashMap<String, List<MessageInfo>>();
        for (MessageInfo messageInfo : allMsgChnList) {
            if (!msgChnMap.containsKey(messageInfo.getMsgId())) {
                msgChnList = new ArrayList<MessageInfo>();
                msgChnList.add(messageInfo);
                msgChnMap.put(messageInfo.getMsgId(), msgChnList);
                continue;
            }
            ((List)msgChnMap.get(messageInfo.getMsgId())).add(messageInfo);
        }
        return msgChnMap;
    }

    @Override
    public void downloadXLS(HttpServletResponse response, Map<String, String> param, PeriodInfo periodInfo, TmsUserSession tmsUserSession) {
        String title = "Approval-Request List";
        ArrayList<String> columnListMsg = new ArrayList<String>();
        columnListMsg.add("Message Name");
        columnListMsg.add("Channel");
        columnListMsg.add("Dates");
        columnListMsg.add("Job Status");
        columnListMsg.add("Total");
        columnListMsg.add("Success");
        columnListMsg.add("Open");
        columnListMsg.add("Click");
        columnListMsg.add("Fail");
        columnListMsg.add("Register");
        columnListMsg.add("Requester");
        List<MessageInfo> dataListMsg = this.campaignApprovalMapper.approvalPagingMsgList(null, param, tmsUserSession);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet[] worksheet = new HSSFSheet[]{workbook.createSheet("Message")};
        int startRowIndex = 0;
        int startColIndex = 0;
        Layouter.buildReport(worksheet[0], startRowIndex, startColIndex, title, columnListMsg, periodInfo);
        FillManagerApproval.fillReportMsg(worksheet[0], startRowIndex, startColIndex, dataListMsg);
        String fileName = title + ".xls";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        Writer.write(response, worksheet);
    }
}

