/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign;

import com.humuson.tms.common.util.FileExtentionUtil;
import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.mapper.campaign.CampaignAttachMapper;
import com.humuson.tms.model.TmsCampInfoAttach;
import com.humuson.tms.service.campaign.CampaignAttachService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CampaignAttachServiceImpl
implements CampaignAttachService {
    private static final Logger log = LoggerFactory.getLogger(CampaignAttachServiceImpl.class);
    @Value(value="${attach.path}")
    private String attachPath;
    @Value(value="${attach.url}")
    private String attachUrl;
    @Autowired
    private CampaignAttachMapper campaignAttachMapper;

    @Override
    public List<TmsCampInfoAttach> selectAttachFileList(String postId) {
        return this.selectAttachFileList(postId, null);
    }

    @Override
    public List<TmsCampInfoAttach> selectAttachFileList(String postId, String attachType) {
        TmsCampInfoAttach param = new TmsCampInfoAttach();
        param.setPostId(postId);
        param.setAttachType(attachType);
        return this.campaignAttachMapper.selectAttachFileList(param);
    }

    @Override
    public int updateAttachFileType(TmsCampInfoAttach tmsCampInfoAttach) {
        return this.campaignAttachMapper.updateAttachFileType(tmsCampInfoAttach);
    }

    @Override
    public int deleteAttachFile(String postId, String fileId) {
        return this.campaignAttachMapper.deleteAttachFile(postId, fileId);
    }

    @Override
    public int uploadAttachFile(TmsCampInfoAttach tmsCampInfoAttach) throws Exception {
        MultipartFile file = tmsCampInfoAttach.getAttachFile();
        String fileName = file.getOriginalFilename();
        String channelType = tmsCampInfoAttach.getChannelType();
        if (channelType.equals("EM") && !FileExtentionUtil.isValidExtention((String)fileName)) {
            return -1;
        }
        if (channelType.equals("SM") && !FileExtentionUtil.isImageFileExtention((String)fileName)) {
            return -1;
        }
        tmsCampInfoAttach.setContentName(fileName);
        List<TmsCampInfoAttach> attachInfoList = this.campaignAttachMapper.selectAttachFileList(tmsCampInfoAttach);
        log.info("attachInfoList size : {}", (Object)attachInfoList.size());
        if (attachInfoList.size() > 0) {
            log.info("attachInfoList size > 0");
            TmsCampInfoAttach attachInfo = attachInfoList.get(0);
            String attachName = attachInfo.getContentPath();
            File existFile = new File(attachName);
            existFile.delete();
        }
        String path = this.attachPath;
        try {
            String newFileName = FileUtil.uploadNew((InputStream)file.getInputStream(), (String)fileName, (String)(path + "/"));
            tmsCampInfoAttach.setFileId(newFileName);
            tmsCampInfoAttach.setContentPath(path + "/" + newFileName);
            tmsCampInfoAttach.setContentUrl(this.attachUrl + "/" + newFileName);
        }
        catch (IOException ie) {
            log.error("File writing error : {}", (Throwable)ie);
        }
        log.info("File upload success!");
        tmsCampInfoAttach.setAttachType("A");
        return this.campaignAttachMapper.insertAttachFileInfo(tmsCampInfoAttach);
    }
}

