/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.automation;

import com.humuson.tms.common.DynamicDatabaseDao;
import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.common.util.SiteUtil;
import com.humuson.tms.mapper.TmsAutoLinkInfoMapper;
import com.humuson.tms.mapper.TmsAutoSchdInfoMapper;
import com.humuson.tms.mapper.automation.AutoSpotSendListMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.automation.TmsAutoQryInfo;
import com.humuson.tms.model.automation.TmsAutoSpotSendListInfo;
import com.humuson.tms.model.system.TmsSysCodeInfo;
import com.humuson.tms.model.vo.AutoListInfo;
import com.humuson.tms.model.vo.AutoPreviewInfo;
import com.humuson.tms.model.vo.EntityMap;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.automation.AutoSpotSendListService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AutoSpotSendListServiceImpl
implements AutoSpotSendListService {
    @Autowired
    AutoSpotSendListMapper autoSpotSendListMapper;
    @Autowired
    TmsAutoSchdInfoMapper tmsAutoSchdInfoMapper;
    @Autowired
    TmsAutoLinkInfoMapper tmsAutoLinkInfoMapper;
    @Autowired
    DynamicDatabaseDao dynamicDao;
    @Value(value="${auto.content.path}")
    private String autoContentPath;

    @Override
    public List<TmsAutoSpotSendListInfo> selectSpotSendList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        pageInfo.calculate(this.selectSpotSendListTotal(param, tmsUserSession));
        return this.autoSpotSendListMapper.selectSpotSendList(pageInfo, param, tmsUserSession);
    }

    @Override
    public int selectSpotSendListTotal(Map<String, String> param, TmsUserSession tmsUserSession) {
        return this.autoSpotSendListMapper.selectSpotSendListTotal(param, tmsUserSession);
    }

    @Override
    public Map<String, String> autoSpotSendInfo(Map<String, String> param) {
        return this.autoSpotSendListMapper.autoSpotSendInfo(param);
    }

    @Override
    public List<EntityMap> autoSpotMailSendTargetCount(Map<String, String> param) {
        ArrayList<EntityMap> targetList = new ArrayList<EntityMap>();
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(param);
        List<TmsAutoQryInfo> dsInfoList = this.autoSpotSendListMapper.autoSpotMsgQueryInfo(entityMap);
        try {
            for (TmsAutoQryInfo dsInfo : dsInfoList) {
                DataSource ds = this.dynamicDao.createDataSource(dsInfo.getQueryDbDriver(), dsInfo.getQueryDbUrl(), dsInfo.getQueryUid(), dsInfo.getQueryPswd());
                String query = "select count(1) targetCnt from (" + dsInfo.getQuerySelect() + ") A ";
                Map<String, Object> result = this.dynamicDao.queryForMap(query, ds);
                EntityMap tempMap = new EntityMap();
                tempMap.put("CHANNEL_TYPE", (Object)dsInfo.getChannelType());
                tempMap.put("USE_YN", (Object)dsInfo.getUseYn());
                tempMap.put("TARGETCNT", result.get("TARGETCNT"));
                targetList.add(tempMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return targetList;
    }

    @Override
    public int insertAutoScheduleInfo(Map<String, String> param) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(param);
        this.autoSpotSendListMapper.insertAutoScheduleInfo(entityMap);
        return entityMap.getInt("NEW_SEQNO");
    }

    @Override
    public String selectAutoScheduleInfo(Map<String, String> param) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(param);
        String returnResult = null;
        returnResult = this.autoSpotSendListMapper.selectAutoScheduleInfo(entityMap);
        return returnResult;
    }

    @Override
    public List<TmsSysCodeInfo> selectMsgTypeList() {
        return this.autoSpotSendListMapper.selectMsgTypeList();
    }

    @Override
    public AutoPreviewInfo targetAutopreView(AutoListInfo autoListInfo) {
        AutoPreviewInfo autoPreview = this.autoSpotSendListMapper.targetAutopreView(autoListInfo);
        try {
            autoPreview.setContents(FileUtil.readUrl((String)autoPreview.getContents()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return autoPreview;
    }

    @Override
    public void insertPushClickUrl(int insertedSeqNo) throws Exception {
        String pushContentFilePath = this.tmsAutoSchdInfoMapper.selectTodaySchdContentBySeqNo(insertedSeqNo);
        String[] splitPushContentFilePath = pushContentFilePath.split("/");
        String pushContent = FileUtil.readLocal((String)(this.autoContentPath + "/" + splitPushContentFilePath[splitPushContentFilePath.length - 1]));
        String[] splitPushContent = pushContent.split("/\\*\\*PUSH_DELIM\\*\\*/");
        if (splitPushContent.length == 2) {
            int i;
            String pushPopupContent = splitPushContent[0];
            String inAppMsg = splitPushContent[1];
            Map popupContentLinkUrl = SiteUtil.getLinkFromHtml((String)pushPopupContent);
            Map inAppMsgLinkUrl = SiteUtil.getLinkFromHtml((String)inAppMsg);
            int clickInsertCnt = 0;
            for (i = 1; i <= popupContentLinkUrl.size(); ++i) {
                clickInsertCnt = this.tmsAutoLinkInfoMapper.insertLinkInfo(insertedSeqNo, "P" + String.format("%02d", i), (String)popupContentLinkUrl.get(i));
                if (clickInsertCnt != 0) continue;
                throw new Exception("Click Url Insert Fail Exception");
            }
            for (i = 1; i <= inAppMsgLinkUrl.size(); ++i) {
                clickInsertCnt = this.tmsAutoLinkInfoMapper.insertLinkInfo(insertedSeqNo, "M" + String.format("%02d", i), (String)inAppMsgLinkUrl.get(i));
                if (clickInsertCnt != 0) continue;
                throw new Exception("Click Url Insert Fail Exception");
            }
        }
    }
}

