/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.automation;

import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.mapper.automation.AutoCreateMapper;
import com.humuson.tms.model.SiteInfo;
import com.humuson.tms.model.TmsCodeInfo;
import com.humuson.tms.model.automation.TmsAutoQryInfo;
import com.humuson.tms.model.vo.EntityMap;
import com.humuson.tms.service.automation.AutoCreateService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AutoCreateServiceImpl
implements AutoCreateService {
    private static final Logger log = LoggerFactory.getLogger(AutoCreateServiceImpl.class);
    private static final String _UNDER_BAR_ = "_";
    @Autowired
    AutoCreateMapper autoCreateMapper;
    @Value(value="${auto.content.path}")
    private String autoContentPath;
    @Value(value="${auto.content.url}")
    private String autoContentUrl;

    @Override
    public SiteInfo selectEnableChannel(int siteId) {
        return this.autoCreateMapper.selectEnableChannel(siteId);
    }

    @Override
    public List<TmsCodeInfo> autoListTableTypeList(EntityMap entityMap) {
        return this.autoCreateMapper.autoListTableTypeList(entityMap);
    }

    @Override
    public List<EntityMap> selectAppGrpbySite(int siteId) {
        return this.autoCreateMapper.selectAppGrpbySite(siteId);
    }

    @Override
    public boolean isQueryRegisted(String msgType, String msgTypeSeq) {
        return this.autoCreateMapper.getRegistedAutoQueryCount(msgType, msgTypeSeq) > 0;
    }

    @Override
    public List<EntityMap> selectAutoMsg(EntityMap entityMap) {
        return this.autoCreateMapper.selectAutoMsg(entityMap);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public EntityMap insertAutoMsg(Map<String, String> param) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(param);
        log.debug("insertAutoMsg()... EntityMap: {}", (Object)entityMap);
        if (!entityMap.get("CHANNEL_TYPE").equals(ChannelType.EMAIL.getCode())) {
            entityMap.put("TRACKING_YN", (Object)"Y");
        }
        int count = this.autoCreateMapper.insertAutoMsg(entityMap);
        entityMap.put("MSG_TYPE_SEQ", (Object)String.valueOf(entityMap.get("NEW_MSG_TYPE_SEQ")));
        entityMap.put("INSERT", (Object)"Y");
        this.doSaveAutoChnMsg(entityMap);
        EntityMap resultMap = new EntityMap();
        resultMap.put("COUNT", (Object)count);
        resultMap.put("MSG_TYPE", entityMap.get("MSG_TYPE"));
        resultMap.put("MSG_TYPE_SEQ", entityMap.get("NEW_MSG_TYPE_SEQ"));
        resultMap.put("CONTENT", entityMap.get("CONTENT"));
        return resultMap;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public EntityMap updateAutoMsg(Map<String, String> param) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(param);
        log.debug("updateAutoMsg()... EntityMap: {}", (Object)entityMap);
        if (entityMap.get("CHANNEL_TYPE").equals(ChannelType.PUSH.getCode())) {
            entityMap.put("TRACKING_YN", (Object)"Y");
        }
        this.doSaveAutoChnMsg(entityMap);
        EntityMap resultMap = new EntityMap();
        resultMap.put("COUNT", (Object)this.autoCreateMapper.updateAutoMsg(entityMap));
        resultMap.put("MSG_TYPE_SEQ", (Object)entityMap.getString("MSG_TYPE_SEQ"));
        resultMap.put("CONTENT", entityMap.get("CONTENT"));
        return resultMap;
    }

    public void doSaveAutoChnMsg(EntityMap entityMap) {
        this.saveAutoChnMsg(entityMap);
    }

    public int saveAutoChnMsg(EntityMap entityMap) {
        String msgType = StringUtils.validString((Object)entityMap.get("MSG_TYPE"));
        String msgTypeSeq = StringUtils.validString((Object)entityMap.get("MSG_TYPE_SEQ"));
        String channelType = StringUtils.validString((Object)entityMap.get("CHANNEL_TYPE"));
        String content = StringUtils.validString((Object)entityMap.get("CONTENT"));
        try {
            FileUtil.makeUrl((String)this.autoContentPath);
        }
        catch (IOException e1) {
            log.error("makeUrl error : {}", (Throwable)e1);
        }
        if (channelType.equals(ChannelType.EMAIL.getCode())) {
            if ("H".equals(entityMap.get("CONTENT_UPLOAD_TYPE"))) {
                String htmlName = msgType + _UNDER_BAR_ + msgTypeSeq + ".html";
                String baseContentPath = this.autoContentPath + "/" + htmlName;
                try {
                    FileUtil.writeLocal((String)baseContentPath, (String)content, (boolean)false);
                    entityMap.put("CONTENT", (Object)(this.autoContentUrl + "/" + htmlName));
                }
                catch (Exception e) {
                    log.error("auto writeLocal error : {}", (Throwable)e);
                }
            }
        } else if (channelType.equals(ChannelType.SMS.getCode())) {
            String htmlName = msgType + _UNDER_BAR_ + msgTypeSeq + ".sms";
            entityMap.put("CONTENT_HTML", (Object)htmlName);
            String baseContentPath = this.autoContentPath + "/" + htmlName;
            try {
                FileUtil.writeLocal((String)baseContentPath, (String)content, (String)"utf-8", (boolean)false);
                entityMap.put("CONTENT", (Object)(this.autoContentUrl + "/" + htmlName));
            }
            catch (Exception e) {
                log.error("auto writeLocal error : {}", (Throwable)e);
            }
        } else if (channelType.equals(ChannelType.PUSH.getCode())) {
            String htmlName = msgType + _UNDER_BAR_ + msgTypeSeq + ".push";
            entityMap.put("CONTENT_HTML", (Object)htmlName);
            String baseContentPath = this.autoContentPath + "/" + htmlName;
            try {
                FileUtil.writeLocal((String)baseContentPath, (String)content, (boolean)false);
                entityMap.put("CONTENT", (Object)(this.autoContentUrl + "/" + htmlName));
            }
            catch (Exception e) {
                log.error("auto writeLocal error : {}", (Throwable)e);
            }
        } else if (channelType.equals(ChannelType.KAKAO.getCode())) {
            String htmlName = msgType + _UNDER_BAR_ + msgTypeSeq + ".kakao";
            entityMap.put("CONTENT_HTML", (Object)htmlName);
            String baseContentPath = this.autoContentPath + "/" + htmlName;
            try {
                FileUtil.writeLocal((String)baseContentPath, (String)content, (String)"utf-8", (boolean)false);
                entityMap.put("CONTENT", (Object)(this.autoContentUrl + "/" + htmlName));
            }
            catch (Exception e) {
                log.error("auto writeLocal error : {}", (Throwable)e);
            }
        }
        if (StringUtils.validString((Object)entityMap.get("USE_YN")).equals("N")) {
            entityMap.put("USE_YN", (Object)"N");
        }
        if (StringUtils.validString((Object)entityMap.get("ISCOPY")).equals("Y")) {
            entityMap.put("USE_YN", (Object)"N");
        }
        return this.autoCreateMapper.saveAutoChannelInfo(entityMap);
    }

    @Override
    public List<TmsAutoQryInfo> selectAutoQueryList(EntityMap entityMap) {
        return this.autoCreateMapper.selectAutoQueryList(entityMap);
    }

    @Override
    public int insertAutoMsgQuery(EntityMap entityMap) {
        return this.autoCreateMapper.insertAutoMsgQuery(entityMap);
    }

    @Override
    public int updateAutoMsgQuery(EntityMap entityMap) {
        return this.autoCreateMapper.updateAutoMsgQuery(entityMap);
    }

    @Override
    public int deleteAutoMsgQuery(EntityMap entityMap) {
        return this.autoCreateMapper.deleteAutoMsgQuery(entityMap);
    }

    @Override
    public String getMobileWebPage(String url) throws IOException {
        String inputLine;
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("User-Agent", "Apple iPhone: Mozilla/5.0 (iPhone; U; CPU iPhone OS 3_0 like Mac OS X; en-us) AppleWebKit/420.1 (KHTML, like Gecko) Version/3.0 Mobile/1A542a Safari/419.3");
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    @Override
    public String uploadContentFileAndGetUrl(MultipartFile file) throws IOException {
        String fileName = null;
        File f = null;
        int count = 0;
        do {
            fileName = FileUtil.makeName((String)String.valueOf(count++), (boolean)false);
        } while ((f = new File(this.autoContentPath + File.separator + fileName)).exists());
        FileUtil.upload((InputStream)file.getInputStream(), (String)f.getAbsolutePath());
        return this.autoContentUrl + "/" + fileName;
    }
}

