/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.account;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.mapper.account.UserMgrMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.SiteInfo;
import com.humuson.tms.model.SysUserMgrInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.account.PwdMgrService;
import com.humuson.tms.service.account.UserMgrService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.StandardPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserMgrServiceImpl
implements UserMgrService {
    @Autowired
    UserMgrMapper userMgrMapper;
    @Autowired
    StandardPasswordEncoder encoder;
    @Autowired
    PwdMgrService pwdMgrService;

    @Override
    public int userMgrListTotal(Map<String, String> param) {
        return this.userMgrMapper.userMgrListTotal(param);
    }

    @Override
    public List<Map<String, String>> getAuthList() {
        return this.userMgrMapper.getAuthList();
    }

    @Override
    public List<Map<String, String>> getRegUserList(TmsUserSession tmsUserSession, Integer siteId, String regId, String deptId) {
        return this.userMgrMapper.getRegUserList(tmsUserSession, siteId, regId, deptId);
    }

    @Override
    public int userMgrCreate(Map<String, String> param) {
        String passWord = this.encoder.encode((CharSequence)param.get("user_password"));
        param.put("USER_PWD", passWord);
        int cnt = this.userMgrMapper.userMgrCreate(param);
        this.userMgrMapper.deleteSiteAccessUser(param);
        String siteList = param.get("siteList");
        if (siteList != null && !siteList.equals("")) {
            String[] siteLists = param.get("siteList").split("\\|");
            for (int i = 0; i < siteLists.length; ++i) {
                param.put("site_id", siteLists[i]);
                this.userMgrMapper.insertUpdateSiteAccessUser(param);
            }
        }
        return cnt;
    }

    @Override
    public List<SysUserMgrInfo> userMgrList(PageInfo pageInfo, Map<String, String> param) {
        pageInfo.calculate(this.userMgrListTotal(param));
        List<SysUserMgrInfo> userMgrList = this.userMgrMapper.userMgrList(pageInfo, param);
        return userMgrList;
    }

    @Override
    public int userMgrCnt(Map<String, String> param) {
        return this.userMgrMapper.userMgrCnt(param);
    }

    @Override
    public int userMgrModify(Map<String, String> param) {
        if (param.get("passMode").equals("YES")) {
            if (!this.encoder.matches((CharSequence)StringUtils.validString((String)param.get("user_password")), StringUtils.validString((String)this.userMgrMapper.getUserPasswordByUserId(param.get("user_id"))))) {
                param.put("USER_PWD", this.encoder.encode((CharSequence)StringUtils.validString((String)param.get("user_password"))));
            } else {
                return -1;
            }
        }
        int cnt = this.userMgrMapper.userMgrModify(param);
        this.userMgrMapper.deleteSiteAccessUser(param);
        String siteList = param.get("siteList");
        if (siteList != null && !siteList.equals("")) {
            String[] siteLists = param.get("siteList").split("\\|");
            for (int i = 0; i < siteLists.length; ++i) {
                param.put("site_id", siteLists[i]);
                this.userMgrMapper.insertUpdateSiteAccessUser(param);
            }
        }
        return cnt;
    }

    @Override
    public int userMgrDelete(Map<String, String> param) {
        return this.userMgrMapper.userMgrDelete(param);
    }

    @Override
    public List<SiteInfo> searchSiteList(PageInfo pageInfo, Map<String, String> param) {
        pageInfo.calculate(this.siteListTotal(param));
        return this.userMgrMapper.searchSiteList(pageInfo, param);
    }

    public int siteListTotal(Map<String, String> param) {
        return this.userMgrMapper.siteListTotal(param);
    }

    @Override
    public int updateLockYN(String userId, String lockYN) {
        int errCnt = lockYN.equals("N") ? 0 : 5;
        return this.userMgrMapper.updateLockYN(userId, lockYN, errCnt);
    }

    @Override
    public int userMgrModifyCheck(Map<String, String> param) {
        int res = 1;
        if (param.get("passMode").equals("YES")) {
            res = this.pwdMgrService.checkPwd(param.get("user_id"), param.get("user_password")) ? 1 : 0;
        }
        return res;
    }

    @Override
    public int addAmcUserId(String userId, String amcUserId) {
        return this.userMgrMapper.addAmcUserId(userId, amcUserId);
    }
}

