/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.account;

import com.humuson.tms.mapper.TmsUserMapper;
import com.humuson.tms.mapper.account.AuthMgrMapper;
import com.humuson.tms.model.TmsAuthInfo;
import com.humuson.tms.model.TmsRoleInfo;
import com.humuson.tms.service.account.AuthMgrService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthMgrServiceImpl
implements AuthMgrService {
    @Autowired
    AuthMgrMapper authMgrMapper;
    @Autowired
    TmsUserMapper tmsUserMapper;

    @Override
    public List<TmsAuthInfo> getAuthList() {
        return this.authMgrMapper.getAuthList();
    }

    @Override
    public List<TmsRoleInfo> getRoleList() {
        return this.authMgrMapper.getRoleList();
    }

    @Override
    public List<Map<String, String>> getAuthRoleInfo(String authId) {
        return this.authMgrMapper.getAuthRoleInfo(authId);
    }

    @Override
    @Transactional
    public boolean registAuth(Map<String, String> param) {
        int authRegistCnt = this.authMgrMapper.registAuth(param);
        int resultCnt = 0;
        String authId = this.authMgrMapper.getMaxAuthId();
        List<String> codeList = this.tmsUserMapper.getUserRoleCode();
        if (authRegistCnt > 0) {
            for (String roleId : codeList) {
                int result = this.authMgrMapper.registAuthRole(authId, roleId, param.get(roleId), param.get("regId"));
                resultCnt += result;
            }
        }
        return codeList.size() == resultCnt;
    }

    @Override
    @Transactional
    public boolean updateAuth(Map<String, String> param) {
        int authUpdateCnt = this.authMgrMapper.updateAuth(param);
        int resultCnt = 0;
        List<String> codeList = this.tmsUserMapper.getUserRoleCode();
        if (authUpdateCnt > 0) {
            for (String roleId : codeList) {
                int result = this.authMgrMapper.upsertAuthRole(param.get("authId"), roleId, param.get(roleId), param.get("regId"));
                resultCnt += result;
            }
        }
        return codeList.size() <= resultCnt && codeList.size() != 0;
    }

    @Override
    public boolean checkDeleteAuth(String authId) {
        return this.authMgrMapper.checkDeleteAuth(authId) <= 0;
    }

    @Override
    public boolean deleteAuth(String authId) {
        return this.authMgrMapper.deleteAuth(authId) > 0;
    }
}

