/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.common.util.StringUtils;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FillManagerStat {
    private static final Logger log = LoggerFactory.getLogger(FillManagerStat.class);

    public static void fillReport(HSSFSheet worksheet, int startRowIndex, int startColIndex, List<List<String>> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        HSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            HSSFRow row = worksheet.createRow((short)i + 1);
            List<String> info = dataList.get(i - 2);
            for (int j = 0; j < info.size(); ++j) {
                String value = info.get(j);
                value = j == 0 ? value.substring(0, 4) + "/" + value.substring(4, 6) + "/" + value.substring(6, 8) : StringUtils.moneyForm((String)value);
                HSSFCell cell = row.createCell(startColIndex + j);
                cell.setCellValue(value);
                cell.setCellStyle(bodyCellStyle);
            }
            ++i;
        }
    }
}

