/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.model.MessageInfo;
import com.humuson.tms.model.SingleCampListInfo;
import com.humuson.tms.model.analytics.AnalyticsSendAmntInfo;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FillManagerSingleCamp {
    private static final Logger log = LoggerFactory.getLogger(FillManagerSingleCamp.class);

    public static void fillReport(HSSFSheet worksheet, int startRowIndex, int startColIndex, List<SingleCampListInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        HSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            HSSFRow row = worksheet.createRow((short)i + 1);
            SingleCampListInfo info = dataList.get(i - 2);
            HSSFCell cell1 = row.createCell(startColIndex + 0);
            cell1.setCellValue(info.getCampName());
            cell1.setCellStyle(bodyCellStyle);
            HSSFCell cell2 = row.createCell(startColIndex + 1);
            cell2.setCellValue(info.getRegDate());
            cell2.setCellStyle(bodyCellStyle);
            HSSFCell cell3 = row.createCell(startColIndex + 2);
            cell3.setCellValue(StringUtils.moneyForm((String)(info.getMailTotal() + "")));
            cell3.setCellStyle(bodyCellStyle);
            HSSFCell cell4 = row.createCell(startColIndex + 3);
            cell4.setCellValue(StringUtils.moneyForm((String)(info.getSmsTotal() + "")));
            cell4.setCellStyle(bodyCellStyle);
            HSSFCell cell5 = row.createCell(startColIndex + 4);
            cell5.setCellValue(StringUtils.moneyForm((String)(info.getPushTotal() + "")));
            cell5.setCellStyle(bodyCellStyle);
            HSSFCell cell6 = row.createCell(startColIndex + 5);
            cell6.setCellValue(StringUtils.moneyForm((String)(info.getPushedCnt() + "")));
            cell6.setCellStyle(bodyCellStyle);
            HSSFCell cell7 = row.createCell(startColIndex + 6);
            cell7.setCellValue(StringUtils.moneyForm((String)(info.getDeliveredCnt() + "")));
            cell7.setCellStyle(bodyCellStyle);
            HSSFCell cell8 = row.createCell(startColIndex + 7);
            cell8.setCellValue(StringUtils.moneyForm((String)(info.getOpenCnt() + "")));
            cell8.setCellStyle(bodyCellStyle);
            HSSFCell cell9 = row.createCell(startColIndex + 8);
            cell9.setCellValue(StringUtils.moneyForm((String)(info.getClickCnt() + "")));
            cell9.setCellStyle(bodyCellStyle);
            ++i;
        }
    }

    public static void fillReportMsg(HSSFSheet worksheet, int startRowIndex, int startColIndex, List<MessageInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        HSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            HSSFRow row = worksheet.createRow((short)i + 1);
            MessageInfo info = dataList.get(i - 2);
            HSSFCell cell1 = row.createCell(startColIndex + 0);
            cell1.setCellValue(info.getCampName());
            cell1.setCellStyle(bodyCellStyle);
            HSSFCell cell2 = row.createCell(startColIndex + 1);
            cell2.setCellValue(info.getMsgName());
            cell2.setCellStyle(bodyCellStyle);
            HSSFCell cell3 = row.createCell(startColIndex + 2);
            cell3.setCellValue(info.getRegDate());
            cell3.setCellStyle(bodyCellStyle);
            HSSFCell cell4 = row.createCell(startColIndex + 3);
            if (info.getChannelType().equals("EM")) {
                cell4.setCellValue("Mail");
            } else if (info.getChannelType().equals("SM")) {
                cell4.setCellValue("SMS");
            } else if (info.getChannelType().equals("PU")) {
                cell4.setCellValue("Push");
            } else {
                cell4.setCellValue(info.getChannelType());
            }
            cell4.setCellStyle(bodyCellStyle);
            HSSFCell cell5 = row.createCell(startColIndex + 4);
            cell5.setCellValue(info.getJobStatusName());
            cell5.setCellStyle(bodyCellStyle);
            HSSFCell cell6 = row.createCell(startColIndex + 5);
            cell6.setCellValue(StringUtils.moneyForm((String)(info.getPushedCnt() + "")));
            cell6.setCellStyle(bodyCellStyle);
            HSSFCell cell7 = row.createCell(startColIndex + 6);
            cell7.setCellValue(StringUtils.moneyForm((String)(info.getDeliveredCnt() + "")) + " (" + info.getDeliveredRate() + "%)");
            cell7.setCellStyle(bodyCellStyle);
            HSSFCell cell8 = row.createCell(startColIndex + 7);
            cell8.setCellValue(StringUtils.moneyForm((String)(info.getOpenCnt() + "")) + " (" + info.getOpenRate() + "%)");
            cell8.setCellStyle(bodyCellStyle);
            HSSFCell cell9 = row.createCell(startColIndex + 8);
            cell9.setCellValue(StringUtils.moneyForm((String)(info.getClickCnt() + "")) + " (" + info.getClickRate() + "%)");
            cell9.setCellStyle(bodyCellStyle);
            HSSFCell cell10 = row.createCell(startColIndex + 9);
            cell10.setCellValue(StringUtils.moneyForm((String)(info.getFailCnt() + "")) + " (" + info.getFailRate() + "%)");
            cell10.setCellStyle(bodyCellStyle);
            ++i;
        }
    }

    public static void fillReportAnalytics(HSSFSheet worksheet, int startRowIndex, int startColIndex, List<AnalyticsSendAmntInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        HSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            HSSFRow row = worksheet.createRow((short)i + 1);
            AnalyticsSendAmntInfo info = dataList.get(i - 2);
            HSSFCell cell1 = row.createCell(startColIndex + 0);
            cell1.setCellValue(info.getGubun());
            cell1.setCellStyle(bodyCellStyle);
            HSSFCell cell2 = row.createCell(startColIndex + 1);
            cell2.setCellValue((double)info.getMsgCnt());
            cell2.setCellStyle(bodyCellStyle);
            HSSFCell cell3 = row.createCell(startColIndex + 2);
            cell3.setCellValue(StringUtils.moneyForm((String)(info.getPushedCnt() + "")));
            cell3.setCellStyle(bodyCellStyle);
            HSSFCell cell4 = row.createCell(startColIndex + 3);
            cell4.setCellValue(StringUtils.moneyForm((String)(info.getDeliveredCnt() + "")) + " (" + info.getDeliveredRate() + "%)");
            cell4.setCellStyle(bodyCellStyle);
            HSSFCell cell5 = row.createCell(startColIndex + 4);
            cell5.setCellValue(StringUtils.moneyForm((String)(info.getFailCnt() + "")) + " (" + info.getFailRate() + "%)");
            cell5.setCellStyle(bodyCellStyle);
            HSSFCell cell6 = row.createCell(startColIndex + 5);
            cell6.setCellValue(StringUtils.moneyForm((String)(info.getOpenCnt() + "")) + " (" + info.getOpenRate() + "%)");
            cell6.setCellStyle(bodyCellStyle);
            HSSFCell cell7 = row.createCell(startColIndex + 6);
            cell7.setCellValue(StringUtils.moneyForm((String)(info.getClickCnt() + "")) + " (" + info.getClickRate() + "%)");
            cell7.setCellStyle(bodyCellStyle);
            HSSFCell cell8 = row.createCell(startColIndex + 7);
            cell8.setCellValue(info.getClickRatePerOpen() + "%");
            cell8.setCellStyle(bodyCellStyle);
            ++i;
        }
    }
}

