/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.model.SendResultInfo;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FillManagerAutoSendResult {
    private static final Logger log = LoggerFactory.getLogger(FillManagerAutoSendResult.class);
    private static final String MEMBER_ID = "memberId";
    private static final String MEMBER_NAME = "memberName";
    private static final String MEMBER_EMAIL = "memberEmail";
    private static final String MEMBER_PHONE = "memberPhone";
    private static final String MEMBER_TOKEN = "memberToken";
    private static final String SEND_TIME = "sendTime";
    private static final String DELIVER_TIME = "deliverTime";
    private static final String ERROR_CODE = "errorCode";
    private static final String CODE_NAME = "codeName";
    private static final String DEVICE = "device";
    private static final String MOBILE_TYPE = "mobileType";
    private static final String OPEN_CNT = "openCnt";
    private static final String OPEN_TIME = "openTime";
    private static final String CLICK_CNT = "clickCnt";
    private static final String CLICK_TIME = "clickTime";
    private static final String DELIVER_YN = "deliverYN";
    private static final String OPEN_YN = "openYN";
    private static final String CLICK_YN = "clickYN";
    private static final String FAIL_YN = "failYN";
    private static final String SWITCHED_ERROR_CODE = "switchedErrorCode";

    public static void fillReportSendResult(HSSFSheet worksheet, int startRowIndex, int startColIndex, List<SendResultInfo> dataList, List<String> columnListInfo) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        HSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            HSSFCell cell;
            HSSFRow row = worksheet.createRow((short)i + 1);
            SendResultInfo info = dataList.get(i - 2);
            int index = 0;
            if (columnListInfo.contains(MEMBER_ID)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMemberId());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(MEMBER_NAME)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMemberName());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(MEMBER_EMAIL)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMemberEmail());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(MEMBER_PHONE)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMemberPhone());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(MEMBER_TOKEN)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMemberToken());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(SEND_TIME)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getSendTime());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(SWITCHED_ERROR_CODE)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getSwitchedErrorCode());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(ERROR_CODE)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getErrorCode());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(CODE_NAME)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getCodeName());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(DELIVER_TIME)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getDeliverTime());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(DEVICE)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getDevice());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(MOBILE_TYPE)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMobileType());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(OPEN_CNT)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getOpenCnt());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(OPEN_TIME)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getOpenTime());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(CLICK_CNT)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getClickCnt());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(CLICK_TIME)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getClickTime());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(DELIVER_YN)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getDeliverYN());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(OPEN_YN)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getOpenYN());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(CLICK_YN)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getClickYN());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            if (columnListInfo.contains(FAIL_YN)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getFailYN());
                cell.setCellStyle(bodyCellStyle);
                ++index;
            }
            ++i;
        }
    }
}

