/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.security;

import com.humuson.tms.model.SiteInfo;
import com.humuson.tms.model.vo.TmsUser;
import com.humuson.tms.service.SiteService;
import com.humuson.tms.service.account.UserLogInsertService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

public class LoginSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(LoginSuccessHandler.class);
    @Value(value="${sns.use.yn}")
    private String snsUseYn;
    @Autowired
    UserLogInsertService userLogInsertService;
    @Autowired
    private SiteService siteService;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication auth) throws IOException, ServletException {
        String[] splitAllowIpBandWidth;
        String userIp = request.getHeader("X-FORWARDED-FOR");
        TmsUser tmsUser = (TmsUser)auth.getPrincipal();
        if (userIp == null) {
            userIp = request.getRemoteAddr();
        }
        boolean isAllowIp = true;
        String allowIp = tmsUser.getAllowIp();
        block0: for (String allow : splitAllowIpBandWidth = allowIp.split(",")) {
            String[] splitAllowIp = allow.split("\\.");
            String[] splitUserIp = userIp.split("\\.");
            if (splitAllowIp.length == 1) {
                splitAllowIp = allow.split(":");
            }
            if (splitUserIp.length == 1) {
                splitUserIp = userIp.split(":");
            }
            for (int i = 0; i < splitAllowIp.length; ++i) {
                if (splitAllowIp[i].equals(splitUserIp[i]) || "*".equals(splitAllowIp[i])) continue;
                isAllowIp = false;
                continue block0;
            }
        }
        if (!isAllowIp) {
            SecurityContextHolder.clearContext();
            request.getSession().invalidate();
            request.setAttribute("message", (Object)"Not Allow IP");
            request.getRequestDispatcher("/login").forward((ServletRequest)request, (ServletResponse)response);
        } else {
            String url;
            String targetInfo = "SUCCESS";
            if (log.isDebugEnabled()) {
                log.debug("\ub85c\uadf8\uc778 \uc131\uacf5");
            }
            if ((url = this.getTargetUrlParameter()) != null) {
                super.onAuthenticationSuccess(request, response, auth);
            } else {
                String lastLoginTime = "";
                String lastUserIp = "";
                Map<String, String> lastLoginMap = this.userLogInsertService.getLastLoginTime(tmsUser.getUsername());
                if (lastLoginMap == null) {
                    lastLoginTime = "";
                    lastUserIp = userIp;
                } else {
                    lastLoginTime = lastLoginMap.get("lastLoginTime");
                    lastUserIp = lastLoginMap.get("userIp");
                }
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("userId", tmsUser.getUsername());
                param.put("code", "10");
                param.put("userIp", userIp);
                param.put("targetInfo", targetInfo);
                this.userLogInsertService.userLogInsert(param);
                this.userLogInsertService.resetErrorCount(tmsUser.getUsername());
                int siteId = tmsUser.getSiteId();
                request.getSession().setAttribute("lastLoginTime", (Object)lastLoginTime);
                request.getSession().setAttribute("lastUserIp", (Object)lastUserIp);
                request.getSession().setAttribute("userId", (Object)tmsUser.getUsername());
                request.getSession().setAttribute("passwdEditDate", (Object)tmsUser.getPasswordEditDate());
                request.getSession().setAttribute("adminModifyFlag", (Object)tmsUser.getAdminModifyFlag());
                request.getSession().setAttribute("snsUseYn", (Object)this.snsUseYn);
                List<SiteInfo> siteList = tmsUser.getSiteList();
                if (tmsUser.getSiteList() == null || tmsUser.getSiteList().isEmpty()) {
                    siteList = this.siteService.selectSiteList(tmsUser.getUsername());
                    tmsUser.setSiteList(siteList);
                }
                boolean canUseDirectSite = false;
                if (siteList != null && siteId != 0) {
                    for (SiteInfo siteInfo : siteList) {
                        if (siteInfo.getSiteId() != siteId) continue;
                        canUseDirectSite = true;
                        tmsUser.setAmcSiteKey(siteInfo.getAmcSiteKey());
                        tmsUser.setAmcWebKey(siteInfo.getAmcWebKey());
                        break;
                    }
                }
                if (canUseDirectSite) {
                    request.setAttribute("siteId", (Object)tmsUser.getSiteId());
                    response.sendRedirect(request.getContextPath() + "/dashboard/index");
                } else {
                    response.sendRedirect(request.getContextPath() + "/site/index");
                }
            }
        }
    }
}

