/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.security;

import com.humuson.tms.common.util.ShowObject;
import com.humuson.tms.exception.UserExpirationDateException;
import com.humuson.tms.service.account.UserLogInsertService;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;

public class LoginFailureHandler
implements AuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(LoginFailureHandler.class);
    @Autowired
    UserLogInsertService userLogInsertService;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        ShowObject.show((Object)request.getParameterMap());
        log.info("AuthenticationException : {}", (Throwable)authException);
        String forwardUrl = "/login";
        if (authException.getCause() instanceof UserExpirationDateException) {
            request.setAttribute("message", (Object)authException.getCause().getMessage());
        } else if (authException instanceof AuthenticationServiceException && authException.getMessage().equals("USER_NOT_FOUND")) {
            request.setAttribute("message", (Object)"\uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \uc0ac\uc6a9\uc790\uc785\ub2c8\ub2e4.");
        } else if (authException instanceof AuthenticationServiceException && authException.getMessage().equals("LOCKED")) {
            request.setAttribute("message", (Object)"\uc7a0\uae08 \ucc98\ub9ac\ub41c \uacc4\uc815\uc785\ub2c8\ub2e4. \uad00\ub9ac\uc790\uc5d0\uac8c \ubb38\uc758\ud574\uc8fc\uc138\uc694.");
        } else if (authException instanceof SessionAuthenticationException) {
            request.setAttribute("message", (Object)"\ub2e4\ub978 \uc0ac\uc6a9\uc790\uac00 \ub85c\uadf8\uc778\ud558\uc5ec \uc0ac\uc6a9\uc911\uc785\ub2c8\ub2e4. \ub2e4\uc74c\uc5d0 \ub2e4\uc2dc \uc2dc\ub3c4\ud574\uc8fc\uc138\uc694.");
        } else {
            HashMap<String, String> param = new HashMap<String, String>();
            String userIp = request.getHeader("X-FORWARDED-FOR");
            String jUserName = request.getParameter("j_username");
            String targetInfo = "FAIL";
            if (userIp == null) {
                userIp = request.getRemoteAddr();
            }
            param.put("userId", jUserName);
            param.put("code", "10");
            param.put("userIp", userIp);
            param.put("targetInfo", targetInfo);
            this.userLogInsertService.userLogInsert(param);
            int errCnt = this.userLogInsertService.addLoginErrorCount(jUserName);
            if (errCnt >= 5) {
                this.userLogInsertService.accountLockUpdate(jUserName, "Y");
            }
            request.setAttribute("message", (Object)(errCnt + "\ud68c \ub85c\uadf8\uc778\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.(5\ud68c \uc2e4\ud328 \uc2dc \uc7a0\uae40)"));
        }
        request.getRequestDispatcher(forwardUrl).forward((ServletRequest)request, (ServletResponse)response);
    }
}

