/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.model.vo;

import org.springframework.data.domain.PageImpl;

public class PageInfoVo {
    public static int DEFAULT_PAGE_NUMBER = 1;
    public static int DEFAULT_PAGE_SIZE = 10;
    private int currentIndex;
    private int beginIndex;
    private int endIndex;
    private int totalElements;
    private int lastPageNumber;
    private int prevPageNumber;
    private int nextPageNumber;
    private int baseRowNumber;

    public PageInfoVo() {
    }

    public PageInfoVo(PageImpl<?> page) {
        this.setPageInfo(page);
    }

    public void setPageInfo(PageImpl<?> page) {
        this.currentIndex = 1 + page.getNumber();
        this.beginIndex = (int)(Math.floor((this.currentIndex * 1 - 1) / page.getSize()) * (double)page.getSize() + 1.0);
        this.endIndex = Math.min(this.beginIndex + 9, page.getTotalPages());
        this.totalElements = (int)page.getTotalElements();
        this.lastPageNumber = page.getTotalPages();
        this.prevPageNumber = this.currentIndex - 1;
        this.nextPageNumber = this.currentIndex + 1;
        this.baseRowNumber = (int)(page.getTotalElements() - (long)(page.getNumber() * page.getSize()));
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getLastPageNumber() {
        return this.lastPageNumber;
    }

    public int getPrevPageNumber() {
        return this.prevPageNumber;
    }

    public int getNextPageNumber() {
        return this.nextPageNumber;
    }

    public int getBaseRowNumber() {
        return this.baseRowNumber;
    }

    public int getTotalElements() {
        return this.totalElements;
    }
}

