/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.model.vo;

import com.humuson.tms.model.vo.EntityMap;
import com.humuson.tms.model.vo.Pagination;
import java.util.Map;

public class PageEntityMap
extends EntityMap
implements Pagination {
    private static final long serialVersionUID = 8391680254373650689L;

    public PageEntityMap() {
    }

    public PageEntityMap(Map<String, Object> entityMap) {
        super(entityMap);
        this.put("maxRows", (Object)(this.getPageNum() * this.getPageSize() + 1));
        this.put("startRow", (Object)(this.getMaxRows() - this.getPageSize()));
    }

    public PageEntityMap(int pageNum, int pageSize) {
        this.setPageNum(pageNum);
        this.setPageSize(pageSize);
        this.setChapterSize(10);
        this.put("maxRows", (Object)(pageNum * pageSize + 1));
        this.put("startRow", (Object)(this.getMaxRows() - pageSize));
        this.put("mySqlMaxRows", (Object)((Integer)this.get("maxRows") - 1));
        this.put("mySqlStartRow", (Object)((Integer)this.get("startRow") - 1));
    }

    public PageEntityMap(int pageNum, int pageSize, String orderBy) {
        this(pageNum, pageSize);
        this.setOrderBy(orderBy);
    }

    @Override
    public final int getPageSize() {
        Integer pageSize = (Integer)this.get("pageSize");
        if (pageSize == null) {
            return 10;
        }
        return pageSize;
    }

    @Override
    public final void setPageSize(int pageSize) {
        this.put("pageSize", (Object)pageSize);
        this.put("maxRows", (Object)(this.getPageNum() * pageSize + 1));
        this.put("startRow", (Object)(this.getMaxRows() - pageSize));
    }

    @Override
    public final int getPageNum() {
        Integer pageNum = (Integer)this.get("pageNum");
        if (pageNum == null) {
            return 1;
        }
        return pageNum;
    }

    public final void setTotalCount(int totalCount) {
        this.put("totalCount", (Object)totalCount);
        this.setMaxPage();
    }

    public final int getTotalCount() {
        Integer totalCount = (Integer)this.get("totalCount");
        if (totalCount == null) {
            return 0;
        }
        return totalCount;
    }

    @Override
    public final void setPageNum(int pageNum) {
        this.put("pageNum", (Object)pageNum);
        this.put("maxRows", (Object)(pageNum * this.getPageSize() + 1));
        this.put("startRow", (Object)(this.getMaxRows() - this.getPageSize()));
    }

    public final void setChapterSize(int chapterSize) {
        if (chapterSize > 0) {
            this.put("chapterSize", (Object)chapterSize);
        }
    }

    public final int getChapterSize() {
        Integer chapterSize = (Integer)this.get("chapterSize");
        if (chapterSize == null) {
            return 10;
        }
        return chapterSize;
    }

    @Override
    public final int getMaxRows() {
        return (Integer)this.get("maxRows");
    }

    @Override
    public final boolean hasMore(int resultSize) {
        return resultSize > this.getPageSize();
    }

    @Override
    public final String getOrderBy() {
        return this.containsKey("PaginationOrderBy") ? String.valueOf(this.get("PaginationOrderBy")) : null;
    }

    @Override
    public final void setOrderBy(String orderBy) {
        try {
            this.checkSqlInjection(orderBy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.put("PaginationOrderBy", (Object)orderBy);
    }

    @Override
    public final void clearOrderBy() {
        this.remove("PaginationOrderBy");
    }

    private void checkSqlInjection(String orderBy) throws Exception {
        if (orderBy.toLowerCase().contains("union")) {
            throw new Exception();
        }
    }

    public final int getStartRow() {
        Integer startRow = (Integer)this.get("startRow");
        if (startRow == null) {
            return 1;
        }
        return startRow;
    }

    public final void setMaxPage() {
        int total_cnt = this.getTotalCount();
        int page_cnt = this.getPageSize();
        int page = total_cnt / page_cnt;
        if (total_cnt % page_cnt > 0) {
            ++page;
        }
        this.put("maxPage", (Object)page);
    }

    public final int getMaxPage() {
        Integer maxPage = (Integer)this.get("maxPage");
        if (maxPage == null) {
            return 1;
        }
        return maxPage;
    }
}

