/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.util;

import com.humuson.tms.model.vo.AppInfo;
import net.sf.json.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class PrivateServerAppKeyManage {
    private static final Logger log = LoggerFactory.getLogger(PrivateServerAppKeyManage.class);
    @Value(value="${private.use.yn}")
    public String privateUseYn;
    @Value(value="${private.admin.list}")
    public String privateAdminList;
    public static final String RETURN_CODE_100 = "100";
    public static final String RETURN_CODE_200 = "200";
    public static final String RETURN_CODE_300 = "300";
    public static final String RETURN_CODE_400 = "400";

    public void appKeyRegistRedis(AppInfo appInfo) {
        RestTemplate restTemplate = new RestTemplate();
        log.info("private server use yn : {}]", (Object)this.privateUseYn);
        if ("Y".equals(this.privateUseYn)) {
            String[] privateUrl = this.privateAdminList.split(",");
            for (int i = 0; i < privateUrl.length; ++i) {
                String url = privateUrl[i].concat("/post/topic/").concat(appInfo.getAppKey()).concat("/").concat(appInfo.getAppName()).concat("/").concat(appInfo.getAppName());
                log.info("private server regist : [url:{}", (Object)url);
                String response = "";
                JSONParser parser = new JSONParser();
                JSONObject json = null;
                String returnCode = "";
                try {
                    response = (String)restTemplate.getForObject(url, String.class, new Object[0]);
                    json = (JSONObject)parser.parse(response);
                    returnCode = (String)json.get("result");
                }
                catch (Exception e) {
                    log.error("[appKeyRegistRedis exception] : {}", (Throwable)e);
                }
                if (RETURN_CODE_100.equals(returnCode)) {
                    log.info("appKeyRegistRedis success : {}]", (Object)returnCode);
                    continue;
                }
                log.info("[appKeyRegistRedis fail] : {}", (Object)returnCode);
            }
        }
    }
}

