/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.util;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.session.SqlSession;

public class MapperSqlUtil {
    public static String getQuery(SqlSession sqlSession, String queryId, Object sqlParam) {
        MappedStatement ms = sqlSession.getConfiguration().getMappedStatement(queryId);
        BoundSql boundSql = ms.getSqlSource().getBoundSql(sqlParam);
        String sql = boundSql.getSql();
        System.out.println("mapper util sql : ");
        System.out.println(sql);
        Object param = boundSql.getParameterObject();
        if (param == null) {
            sql = sql.replaceFirst("\\?", "''");
        } else if (param instanceof Integer || param instanceof Long || param instanceof Float || param instanceof Double) {
            sql = sql.replaceFirst("\\?", param.toString());
        } else if (param instanceof String) {
            sql = sql.replaceFirst("\\?", "'" + param + "'");
        } else if (param instanceof Map) {
            List paramMapping = boundSql.getParameterMappings();
            for (ParameterMapping mapping : paramMapping) {
                String propValue = mapping.getProperty();
                Object value = ((Map)param).get(propValue);
                if (value instanceof String) {
                    sql = sql.replaceFirst("\\?", "'" + value + "'");
                    continue;
                }
                sql = sql.replaceFirst("\\?", value.toString());
            }
        } else {
            try {
                List paramMapping = boundSql.getParameterMappings();
                Class<?> paramClass = param.getClass();
                for (ParameterMapping mapping : paramMapping) {
                    String propValue = mapping.getProperty();
                    Field field = paramClass.getDeclaredField(propValue);
                    field.setAccessible(true);
                    Class javaType = mapping.getJavaType();
                    if (String.class == javaType) {
                        sql = sql.replaceFirst("\\?", "'" + field.get(param) + "'");
                        continue;
                    }
                    sql = sql.replaceFirst("\\?", field.get(param).toString());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("sql param object parsing error", e);
            }
        }
        return sql;
    }
}

