/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.constant;

import org.springframework.http.HttpStatus;

public enum ApiStatus {
    OK("000", HttpStatus.OK),
    AuthenticationFail("E001", HttpStatus.BAD_REQUEST),
    UrlNotFound("E002", HttpStatus.NOT_FOUND),
    ParamNotValid("E003", HttpStatus.BAD_REQUEST),
    NoRegisteredValue("E004", HttpStatus.BAD_REQUEST),
    ContentTypeError("E005", HttpStatus.METHOD_NOT_ALLOWED),
    JsonParseError("E006", HttpStatus.BAD_REQUEST),
    NotReadableRequest("E007", HttpStatus.BAD_REQUEST),
    RequestMethodNotSupported("E008", HttpStatus.BAD_REQUEST),
    AccessDenied("E009", HttpStatus.FORBIDDEN),
    ServerError("E999", HttpStatus.INTERNAL_SERVER_ERROR);

    private String statusCode;
    private HttpStatus httpStatus;

    private ApiStatus(String statusCode, HttpStatus httpStatus) {
        this.statusCode = statusCode;
        this.httpStatus = httpStatus;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public static ApiStatus findApiStatusByCode(String statusCode) {
        for (ApiStatus error : ApiStatus.values()) {
            if (!error.getStatusCode().equals(statusCode)) continue;
            return error;
        }
        return null;
    }

    public static HttpStatus findHttpStatusByCode(String errCode) {
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        for (ApiStatus error : ApiStatus.values()) {
            if (!error.getStatusCode().equals(errCode)) continue;
            status = error.getHttpStatus();
            break;
        }
        return status;
    }
}

