/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.aop;

import com.google.gson.Gson;
import com.humuson.tms.common.aop.UserLog;
import com.humuson.tms.model.vo.TmsUser;
import com.humuson.tms.service.account.UserLogInsertService;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class UserLogAop {
    private static final Logger log = LoggerFactory.getLogger(UserLogAop.class);
    @Autowired
    UserLogInsertService userLogInsertService;

    @Before(value="@annotation(com.humuson.tms.common.aop.UserLog)")
    public void userLogInsert(JoinPoint joinPoint) {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest req = attr.getRequest();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        TmsUser tmsUser = (TmsUser)authentication.getPrincipal();
        log.info("userLogInsert Param : {}", (Object)req.getParameterMap());
        HashMap<String, String> param = new HashMap<String, String>();
        String code = null;
        String userIp = null;
        String paramString = null;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Class<?>[] parameterTypes = signature.getMethod().getParameterTypes();
        try {
            UserLog annotations = joinPoint.getTarget().getClass().getMethod(methodName, parameterTypes).getAnnotation(UserLog.class);
            code = annotations.code();
        }
        catch (NoSuchMethodException e) {
            log.error("NoSuchMethodException error ", (Throwable)e);
        }
        catch (SecurityException e) {
            log.error("SecurityException error ", (Throwable)e);
        }
        userIp = req.getHeader("X-FORWARDED-FOR");
        if (userIp == null) {
            userIp = req.getRemoteAddr();
        }
        Gson gson = new Gson();
        paramString = gson.toJson((Object)req.getParameterMap());
        param.put("userId", tmsUser.getUsername());
        param.put("code", code);
        param.put("userIp", userIp);
        param.put("param", paramString);
        this.userLogInsertService.userLogInsert(param);
    }
}

