/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.api.controller;

import com.humuson.tms.api.controller.BaseApiController;
import com.humuson.tms.model.BaseApiInfo;
import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.analytics.BaseAnalyticsApiInfo;
import com.humuson.tms.service.api.AnalyticsApiService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class AnalyticsBaseController
extends BaseApiController {
    public static final Locale DEFAULT_LOCALE = Locale.KOREAN;
    public static final int OPTION_SELECT_DEFAULT = 1;
    public static final int OPTION_SELECT_TOTAL = 2;
    public static final int OPTION_SELECT_LIST = 3;
    @Autowired
    private AnalyticsApiService analyticsApiService;

    @Override
    public String process(BaseApiInfo baseApiInfo, Map<String, String> params, int option) throws Exception {
        String result = "";
        JSONObject obj = new JSONObject();
        switch (option) {
            case 1: {
                List<BaseAnalyticsApiInfo> tList = this.selectData(baseApiInfo, params, 2);
                List<BaseAnalyticsApiInfo> lList = this.selectData(baseApiInfo, params, 3);
                obj.put((Object)"total", (Object)this.makeTotal(tList));
                obj.put((Object)"list", (Object)this.makeList(lList));
                result = obj.toString();
                break;
            }
            case 2: {
                List<BaseAnalyticsApiInfo> tList = this.selectData(baseApiInfo, params, 2);
                result = this.makeTotal(tList).toString();
                break;
            }
            case 3: {
                List<BaseAnalyticsApiInfo> lList = this.selectData(baseApiInfo, params, 3);
                result = this.makeList(lList).toString();
                break;
            }
        }
        return result;
    }

    protected List<BaseAnalyticsApiInfo> selectData(BaseApiInfo baseApiInfo, Map<String, String> params, int option) {
        String startDate = params.get("startDate");
        String endDate = params.get("endDate");
        PeriodInfo pi = new PeriodInfo();
        if (startDate != null && endDate != null) {
            pi.setStartDate(startDate);
            pi.setEndDate(endDate);
        }
        String dataType = params.get("dataType");
        List<BaseAnalyticsApiInfo> totalCount = null;
        List<BaseAnalyticsApiInfo> appVerTop5 = this.analyticsApiService.selectTop5(dataType, Integer.parseInt(baseApiInfo.getChannelId()), pi);
        if (!appVerTop5.isEmpty()) {
            appVerTop5.get(0).setTop5Size(appVerTop5.size());
        }
        ArrayList<BaseAnalyticsApiInfo> resultList = new ArrayList<BaseAnalyticsApiInfo>();
        switch (option) {
            case 2: {
                totalCount = this.analyticsApiService.selectWorkdayTotalCnt(dataType, Integer.parseInt(baseApiInfo.getChannelId()), pi);
                resultList.addAll(totalCount);
                resultList.addAll(appVerTop5);
                break;
            }
            case 3: {
                int workdayListSize = 0;
                String id = "";
                ArrayList<List<BaseAnalyticsApiInfo>> workdayAppVerStatList = new ArrayList<List<BaseAnalyticsApiInfo>>();
                for (int i = 0; i < appVerTop5.size(); ++i) {
                    BaseAnalyticsApiInfo info = appVerTop5.get(i);
                    id = Long.toString(info.getId());
                    List<BaseAnalyticsApiInfo> list = this.analyticsApiService.selectStat(id, Integer.parseInt(baseApiInfo.getChannelId()), pi);
                    if (workdayListSize == 0) {
                        workdayListSize = list.size();
                    }
                    workdayAppVerStatList.add(list);
                }
                ArrayList<BaseAnalyticsApiInfo> workdayStatList = new ArrayList<BaseAnalyticsApiInfo>(workdayListSize);
                for (int i = 0; i < workdayListSize; ++i) {
                    BaseAnalyticsApiInfo info = new BaseAnalyticsApiInfo();
                    ArrayList list = new ArrayList();
                    String workday = null;
                    for (int j = 0; j < workdayAppVerStatList.size(); ++j) {
                        List workdayDeviceList = (List)workdayAppVerStatList.get(j);
                        list.add(workdayDeviceList.get(i));
                        if (workday != null) continue;
                        workday = ((BaseAnalyticsApiInfo)workdayDeviceList.get(i)).getWorkday();
                    }
                    info.setStatList(list);
                    info.setWorkday(workday);
                    workdayStatList.add(0, info);
                }
                resultList.addAll(appVerTop5);
                resultList.addAll(workdayStatList);
                break;
            }
        }
        return resultList;
    }

    protected JSONObject makeList(List<BaseAnalyticsApiInfo> lList) {
        JSONObject obj = new JSONObject();
        int top5Size = 0;
        ArrayList<String> headerList = new ArrayList<String>();
        ArrayList dailyListTotal = new ArrayList();
        headerList.add("Dates");
        for (int i = 0; i < lList.size(); ++i) {
            if (i == 0) {
                top5Size = lList.get(i).getTop5Size();
            }
            if (i < top5Size) {
                headerList.add(lList.get(i).getName());
                continue;
            }
            ArrayList<String> dailyList = new ArrayList<String>();
            dailyList.add(lList.get(i).getWorkday());
            for (int j = 0; j < lList.get(i).getStatList().size(); ++j) {
                dailyList.add("" + lList.get(i).getStatList().get(j).getCnt());
            }
            dailyListTotal.add(dailyList);
        }
        obj.put((Object)"Header", headerList);
        obj.put((Object)"Data", dailyListTotal);
        return obj;
    }

    private JSONObject makeTotal(List<BaseAnalyticsApiInfo> tList) {
        JSONObject obj = new JSONObject();
        for (int i = 0; i < tList.size(); ++i) {
            String count = "";
            if (i == 1) {
                count = "1st:";
            } else if (i == 2) {
                count = "2nd:";
            } else if (i == 3) {
                count = "3rd:";
            } else if (i == 4) {
                count = "4th:";
            } else if (i == 5) {
                count = "5th:";
            }
            String key = "";
            String value = "";
            if (i == 0) {
                obj.put((Object)"sessCnt", (Object)tList.get(0).getSessCnt());
                continue;
            }
            key = count + tList.get(i).getName();
            value = "" + tList.get(i).getCnt() + "(" + String.format("%.0f", (double)tList.get(i).getCnt() / (double)tList.get(0).getSessCnt() * 100.0) + "%)";
            obj.put((Object)key, (Object)value);
        }
        return obj;
    }

    @Override
    public String pagingProcess(BaseApiInfo baseApiInfo, Map<String, String> params, int option) throws Exception {
        return null;
    }
}

