/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.api.component;

import com.humuson.tms.api.component.ApiResponseFormConverter;
import com.humuson.tms.common.constant.ApiStatus;
import com.humuson.tms.model.api.ApiResponseForm;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleResponse {
    public static final String MSG_RESERVED = "RESERVED";
    public static final String MSG_SUCCESS = "SUCCESS";
    public static ApiResponseFormConverter apiResponseFormConverter;

    @Autowired
    public void setApiResponseFormConverter(ApiResponseFormConverter apiResponseFormConverter) {
        SimpleResponse.apiResponseFormConverter = apiResponseFormConverter;
    }

    private static ApiResponseForm makeApiSuccessResponseForm(String msg, Object data) {
        return apiResponseFormConverter.makeApiResponseForm(ApiStatus.OK, msg, data);
    }

    private static ApiResponseForm get(String msg, Object data) {
        return SimpleResponse.makeApiSuccessResponseForm(msg, data);
    }

    private static ApiResponseForm get(String msg, String key, Object value) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        out.put(key, value);
        return SimpleResponse.makeApiSuccessResponseForm(msg, out);
    }

    public static ApiResponseForm success() {
        return SimpleResponse.get(MSG_SUCCESS, null);
    }

    public static ApiResponseForm reserved() {
        return SimpleResponse.get(MSG_RESERVED, null);
    }

    public static ApiResponseForm error(HttpServletRequest request, ApiStatus apiStatus, String msg, Object data) {
        return apiResponseFormConverter.makeApiResponseForm(request, apiStatus, msg, data);
    }

    public static ApiResponseForm error(ApiStatus apiStatus, String msg, Object data) {
        return apiResponseFormConverter.makeApiResponseForm(apiStatus, msg, data);
    }

    public static ApiResponseForm error(String msg, Object data) {
        return apiResponseFormConverter.makeApiResponseForm(ApiStatus.ServerError, msg, data);
    }

    public static ApiResponseForm error(HttpServletRequest request, String msg, Object data) {
        return apiResponseFormConverter.makeApiResponseForm(request, ApiStatus.ServerError, msg, data);
    }

    public static ApiResponseForm make(Object value) {
        return SimpleResponse.get(MSG_SUCCESS, value);
    }

    public static ApiResponseForm make(String key, Object value) {
        return SimpleResponse.get(MSG_SUCCESS, key, value);
    }

    public static builder builder() {
        return new builder();
    }

    public static class builder {
        ApiStatus apiStatus = ApiStatus.OK;
        String message = "SUCCESS";
        Map<String, Object> dataList = new HashMap<String, Object>();

        public builder setApiStatus(ApiStatus apiStatus) {
            this.apiStatus = apiStatus;
            return this;
        }

        public builder setMessage(HttpServletRequest request, String message) {
            this.message = apiResponseFormConverter.getMessage(message, request);
            return this;
        }

        public builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public builder add(String key, Object value) {
            this.dataList.put(key, value);
            return this;
        }

        public ApiResponseForm build() {
            return apiResponseFormConverter.makeApiResponseForm(this.apiStatus, this.message, this.dataList);
        }
    }
}

