/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign.multi;

import com.humuson.tms.convert.aop.ConvertTarget;
import com.humuson.tms.convert.bind.DecryptAndMasking;
import com.humuson.tms.mapper.campaign.multi.CampaignMultiMapper;
import com.humuson.tms.model.MassSendListInfo;
import com.humuson.tms.model.MessageInfo;
import com.humuson.tms.model.MultiCampListInfo;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.TmsCampInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.campaign.multi.CampaignMultiService;
import com.humuson.tms.service.excel.FillManagerMultiCamp;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CampaignMultiServiceImpl
implements CampaignMultiService {
    @Autowired
    private CampaignMultiMapper campaignMultiMapper;

    @Override
    public int multiCampTotal(Map<String, String> param, TmsUserSession tmsUserSession) {
        return this.campaignMultiMapper.multiCampTotal(param, tmsUserSession);
    }

    @Override
    public int multiMsgTotal(Map<String, String> param) {
        return this.campaignMultiMapper.multiMsgTotal(param);
    }

    @Override
    public List<MultiCampListInfo> multiCampList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        if (param.get("search_period") != null || param.get("search_period").equals("")) {
            String[] period = param.get("search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.multiCampTotal(param, tmsUserSession));
        return this.campaignMultiMapper.multiCampList(pageInfo, param, tmsUserSession);
    }

    @Override
    public List<MessageInfo> multiMsgList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        if (param.get("msg_search_period") != null) {
            String[] period = param.get("msg_search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null) {
            String[] period = param.get("search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.multiMsgTotal(param));
        return this.campaignMultiMapper.multiMsgList(pageInfo, param, tmsUserSession);
    }

    @Override
    public List<MessageInfo> multiPageingMsgList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        if (param.get("msg_search_period") != null) {
            String[] period = param.get("msg_search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null) {
            String[] period = param.get("search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.campaignMultiMapper.multiMsgChnTotal(param, tmsUserSession));
        return this.campaignMultiMapper.multiPageingMsgList(pageInfo, param, tmsUserSession);
    }

    @Override
    public Map<String, List<MessageInfo>> multiMsgChnList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        String endDate;
        String startDate;
        String[] period;
        if (param.get("msg_search_period") != null) {
            period = param.get("msg_search_period").split("-");
            startDate = period[0].trim();
            endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null) {
            period = param.get("search_period").split("-");
            startDate = period[0].trim();
            endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.campaignMultiMapper.multiMsgChnTotal(param, tmsUserSession));
        List<MessageInfo> allMsgChnList = this.campaignMultiMapper.multiMsgChnList(pageInfo, param, tmsUserSession);
        ArrayList<MessageInfo> msgChnList = null;
        HashMap<String, List<MessageInfo>> msgChnMap = new HashMap<String, List<MessageInfo>>();
        for (MessageInfo messageInfo : allMsgChnList) {
            if (!msgChnMap.containsKey(messageInfo.getMsgId())) {
                msgChnList = new ArrayList<MessageInfo>();
                msgChnList.add(messageInfo);
                msgChnMap.put(messageInfo.getMsgId(), msgChnList);
                continue;
            }
            ((List)msgChnMap.get(messageInfo.getMsgId())).add(messageInfo);
        }
        return msgChnMap;
    }

    @Override
    public int multiCampRegist(Map<String, String> param) {
        String[] period = param.get("campaign_period").split("-");
        String startDate = period[0].trim();
        String endDate = period[1].trim();
        param.put("start_date", startDate);
        param.put("end_date", endDate);
        int cnt = this.campaignMultiMapper.multiCampRegist(param);
        return cnt;
    }

    @Override
    public int multiCampDelete(Map<String, String> param) {
        int cnt = this.campaignMultiMapper.multiCampDelete(param);
        if (cnt > 0) {
            cnt += this.campaignMultiMapper.deletedCampSchdUpdate(param);
            cnt += this.campaignMultiMapper.deletedCampOptmzChnUpdate(param);
        }
        return cnt;
    }

    @Override
    public int deleteMsg(Map<String, String> param) {
        int cnt = this.campaignMultiMapper.deleteMsg(param);
        if (cnt > 0) {
            cnt += this.campaignMultiMapper.deletedMsgSchdUpdate(param);
            cnt += this.campaignMultiMapper.deletedMsgOptmzChnUpdate(param);
        }
        return cnt;
    }

    @Override
    public TmsCampInfo getCampInfo(Map<String, String> param) {
        return this.campaignMultiMapper.getCampInfo(param);
    }

    @Override
    public int multiCampModify(Map<String, String> param) {
        if (param.get("campaign_period") != null) {
            String[] period = param.get("campaign_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        return this.campaignMultiMapper.multiCampModify(param);
    }

    @Override
    public void downloadXLS(HttpServletResponse response, Map<String, String> param, PeriodInfo periodInfo, TmsUserSession tmsUserSession) {
        String title = "Multi Campaign";
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("Campaign Name");
        columnList.add("Dates");
        columnList.add("Message ");
        columnList.add("Total");
        columnList.add("Success");
        columnList.add("Open");
        columnList.add("Click");
        ArrayList<String> columnListMsg = new ArrayList<String>();
        columnListMsg.add("Campaign Name");
        columnListMsg.add("Message Name");
        columnListMsg.add("Dates");
        columnListMsg.add("Job Status");
        columnListMsg.add("Total");
        columnListMsg.add("Success");
        columnListMsg.add("Open");
        columnListMsg.add("Click");
        columnListMsg.add("Fail");
        List<MultiCampListInfo> dataList = this.campaignMultiMapper.multiCampList(null, param, tmsUserSession);
        List<MessageInfo> dataListMsg = this.campaignMultiMapper.multiMsgList(null, param, tmsUserSession);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet[] worksheet = new HSSFSheet[]{workbook.createSheet("Campaign"), workbook.createSheet("Message")};
        int startRowIndex = 0;
        int startColIndex = 0;
        Layouter.buildReport(worksheet[0], startRowIndex, startColIndex, title, columnList, periodInfo);
        Layouter.buildReport(worksheet[1], startRowIndex, startColIndex, title, columnListMsg, periodInfo);
        FillManagerMultiCamp.fillReport(worksheet[0], startRowIndex, startColIndex, dataList);
        FillManagerMultiCamp.fillReportMsg(worksheet[1], startRowIndex, startColIndex, dataListMsg);
        String fileName = title + ".xls";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        Writer.write(response, worksheet);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public MassSendListInfo getPreviewContent(String msgId, String postId) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.setPOST_ID(postId);
        ms.targetListTable();
        return this.campaignMultiMapper.getPreviewContent(ms);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> randomTargetList(String msgId, String postId) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.setPOST_ID(postId);
        ms.targetListTable();
        List<MassSendListInfo> massSendList = this.campaignMultiMapper.randomTargetList(ms);
        return massSendList;
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> previewSearch(String msgId, String postId, String searchType, String searchValue) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.setPOST_ID(postId);
        ms.targetListTable();
        List<MassSendListInfo> massSendList = this.campaignMultiMapper.previewSearch(ms, searchType, searchValue);
        return massSendList;
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> randomTargetListByMemberId(String msgId, String postId, String memberId) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.setPOST_ID(postId);
        ms.setMEMBER_ID(memberId);
        ms.targetListTable();
        List<MassSendListInfo> massSendList = this.campaignMultiMapper.randomTargetListByMemberId(ms);
        return massSendList;
    }
}

