/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign;

import com.humuson.tms.common.util.MapperSqlUtil;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.config.TmsConfig;
import com.humuson.tms.constrants.RelTargetCondType;
import com.humuson.tms.constrants.StatusType;
import com.humuson.tms.constrants.TargetStatus;
import com.humuson.tms.constrants.TargetType;
import com.humuson.tms.mapper.TmsCampLinkInfoMapper;
import com.humuson.tms.mapper.campaign.TmsCampChnInfoMapper;
import com.humuson.tms.mapper.campaign.TmsCampMsgInfoMapper;
import com.humuson.tms.mapper.campaign.single.CampaignSingleManagerMapper;
import com.humuson.tms.mapper.targeting.RelTargetMapper;
import com.humuson.tms.mapper.targeting.TmsCampTargetInfoMapper;
import com.humuson.tms.mapper.targeting.TmsCampTargetRelMapper;
import com.humuson.tms.mapper.targeting.TmsTargetServerMapper;
import com.humuson.tms.model.MessageInfo;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.RelTargetCondForm;
import com.humuson.tms.model.RelTargetForm;
import com.humuson.tms.model.TargetServerInfo;
import com.humuson.tms.model.TmsCampChnInfo;
import com.humuson.tms.model.TmsCampLinkInfo;
import com.humuson.tms.model.TmsCampMsgInfo;
import com.humuson.tms.model.targeting.TmsCampTargetInfo;
import com.humuson.tms.model.targeting.TmsCampTargetRel;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.CommonCodeService;
import com.humuson.tms.service.campaign.RelTargetService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RelTargetServiceImpl
implements RelTargetService {
    @Autowired
    TmsConfig tmsConfig;
    @Autowired
    SqlSession sqlSession;
    @Autowired
    TmsCampMsgInfoMapper tmsCampMsgInfoMapper;
    @Autowired
    TmsCampChnInfoMapper tmsCampChnInfoMapper;
    @Autowired
    TmsCampTargetInfoMapper tmsCampTargetInfoMapper;
    @Autowired
    TmsCampTargetRelMapper tmsCampTargetRelMapper;
    @Autowired
    TmsCampLinkInfoMapper tmsCampLinkInfoMapper;
    @Autowired
    TmsTargetServerMapper tmsTargetServerMapper;
    @Autowired
    CommonCodeService commonCodeService;
    @Autowired
    RelTargetMapper relTargetMapper;
    @Autowired
    CampaignSingleManagerMapper campaignSingleManagerMapper;

    private TmsCampTargetInfo getDefaultRelTargetInfo(String msgId, TmsCampMsgInfo msgInfo, TmsCampChnInfo chnInfo) {
        TmsCampTargetInfo tmsTargetInfo = new TmsCampTargetInfo();
        tmsTargetInfo.setMsgId(msgId).setPostId(chnInfo.getPostId()).setChannelType(chnInfo.getChannelType()).setTargetType(TargetType.REL.getCode()).setTargetStatus(TargetStatus.RESERVE.getCode()).setAbTestYn(msgInfo.getAbTestYn()).setEncryptYN(this.tmsConfig.getEncryptYN());
        return tmsTargetInfo;
    }

    private String getQueryAboutRelMember(RelTargetCondType relTargetCondType, String tableName, List<TmsCampTargetRel> relTargetCondList) {
        String mapperName = TmsCampTargetRelMapper.class.getName();
        String sqlId = null;
        if (RelTargetCondType.TARGET == relTargetCondType) {
            sqlId = mapperName + ".selectRelMemberByTarget";
        } else if (RelTargetCondType.SUCCESS == relTargetCondType) {
            sqlId = mapperName + ".selectRelMemberBySuccess";
        } else if (RelTargetCondType.FAIL == relTargetCondType) {
            sqlId = mapperName + ".selectRelMemberByTarget";
        } else if (RelTargetCondType.OPEN == relTargetCondType) {
            sqlId = mapperName + ".selectRelMemberByOpen";
        } else if (RelTargetCondType.CLICK == relTargetCondType) {
            sqlId = mapperName + ".selectRelMemberByClick";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("table", tableName);
        if (RelTargetCondType.CLICK == relTargetCondType) {
            StringBuilder postIdBuilder = new StringBuilder();
            StringBuilder allClickPostIds = new StringBuilder();
            StringBuilder clickIdsBuilder = new StringBuilder();
            for (TmsCampTargetRel relTargetCond : relTargetCondList) {
                if (relTargetCond.getValue().equals("ALL")) {
                    allClickPostIds.append(",'").append(relTargetCond.getPostId()).append('\'');
                    continue;
                }
                postIdBuilder.append(",'").append(relTargetCond.getPostId()).append('\'');
                for (String clickId : relTargetCond.getValue().split(",")) {
                    clickIdsBuilder.append(",'").append(clickId).append('\'');
                }
            }
            String postIds = postIdBuilder.length() > 0 ? postIdBuilder.substring(1) : null;
            String allTargetPostIds = allClickPostIds.length() > 0 ? allClickPostIds.substring(1) : null;
            String clickIds = clickIdsBuilder.length() > 0 ? clickIdsBuilder.substring(1) : null;
            params.put("postIds", postIds);
            params.put("allClickPostIds", allTargetPostIds);
            params.put("clickIds", clickIds);
        } else {
            StringBuilder postIdBuilder = new StringBuilder();
            for (TmsCampTargetRel relTargetCond : relTargetCondList) {
                postIdBuilder.append(",'").append(relTargetCond.getPostId()).append('\'');
            }
            params.put("postIds", postIdBuilder.substring(1));
        }
        return MapperSqlUtil.getQuery(this.sqlSession, sqlId, params);
    }

    @Override
    public String getRelTargetSql(List<TmsCampTargetRel> relTargetCondList, String channelType, int siteId, String mktYn) {
        HashMap tableMap = new HashMap();
        HashMap<String, String> openTableMap = new HashMap<String, String>();
        StringBuilder clickTypeAllPostId = null;
        StringBuilder clickTypePartPostId = null;
        StringBuilder clickIds = null;
        HashMap clickTableMap = new HashMap();
        for (TmsCampTargetRel relTargetCond : relTargetCondList) {
            String postIdList;
            String table = StringUtils.getSendListTable((String)relTargetCond.getPostId());
            String type = relTargetCond.getType();
            String postId = relTargetCond.getPostId();
            if (RelTargetCondType.CLICK.same(type)) {
                int i;
                String[] split;
                HashMap<String, String> clickMap = (HashMap<String, String>)clickTableMap.get(table);
                if (clickMap == null) {
                    clickMap = new HashMap<String, String>();
                    if ("ALL".equalsIgnoreCase(relTargetCond.getValue())) {
                        if (clickTypeAllPostId == null) {
                            clickTypeAllPostId = new StringBuilder();
                            clickTypeAllPostId.append("'").append(postId).append("'");
                        } else {
                            clickTypePartPostId.append(",'").append(postId).append("'");
                        }
                        clickMap.put("ALL", clickTypeAllPostId.toString());
                    } else {
                        if (clickTypePartPostId == null) {
                            clickTypePartPostId = new StringBuilder();
                            clickTypePartPostId.append("'").append(postId).append("'");
                        } else {
                            clickTypePartPostId.append(",'").append(postId).append("'");
                        }
                        if (clickIds == null) {
                            clickIds = new StringBuilder();
                            split = relTargetCond.getValue().split(",");
                            clickIds.append("'").append(split[0]).append('\'');
                            for (i = 1; i < split.length; ++i) {
                                if (i != 0) continue;
                                clickIds.append(",'").append(split[i]).append('\'');
                            }
                        } else {
                            for (String clickId : relTargetCond.getValue().split(",")) {
                                clickIds.append(",'").append(clickId).append('\'');
                            }
                        }
                        clickMap.put("PART", clickTypePartPostId.toString());
                    }
                } else if ("ALL".equalsIgnoreCase(relTargetCond.getValue())) {
                    if (clickTypeAllPostId == null) {
                        clickTypeAllPostId = new StringBuilder();
                        clickTypeAllPostId.append("'").append(postId).append("'");
                    } else {
                        clickTypePartPostId.append(",'").append(postId).append("'");
                    }
                    clickMap.put("ALL", clickTypeAllPostId.toString());
                } else {
                    if (clickTypePartPostId == null) {
                        clickTypePartPostId = new StringBuilder();
                        clickTypePartPostId.append("'").append(postId).append("'");
                    } else {
                        clickTypePartPostId.append(",'").append(postId).append("'");
                    }
                    if (clickIds == null) {
                        clickIds = new StringBuilder();
                        split = relTargetCond.getValue().split(",");
                        clickIds.append("'").append(split[0]).append('\'');
                        for (i = 1; i < split.length; ++i) {
                            if (i != 0) continue;
                            clickIds.append(",'").append(split[i]).append('\'');
                        }
                    } else {
                        for (String clickId : relTargetCond.getValue().split(",")) {
                            clickIds.append(",'").append(clickId).append('\'');
                        }
                    }
                    clickMap.put("PART", clickTypePartPostId.toString());
                }
                clickTableMap.put(table, clickMap);
                continue;
            }
            if (RelTargetCondType.OPEN.same(type)) {
                String postIds = (String)openTableMap.get(table);
                postIds = postIds == null ? "'" + postId + "'" : postIds + ",'" + postId + "'";
                openTableMap.put(table, postIds);
                continue;
            }
            HashMap<String, String> typeMap = (HashMap<String, String>)tableMap.get(table);
            if (typeMap == null) {
                typeMap = new HashMap<String, String>();
                postIdList = "'" + postId + "'";
                typeMap.put(type, postIdList);
            } else {
                postIdList = (String)typeMap.get(type);
                postIdList = postIdList == null ? "'" + postId + "'" : postIdList + ",'" + postId + "'";
                typeMap.put(type, postIdList);
            }
            tableMap.put(table, typeMap);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableMap", tableMap);
        params.put("openTableMap", openTableMap);
        params.put("clickTableMap", clickTableMap);
        params.put("clickIds", clickIds);
        params.put("channelType", channelType);
        params.put("mktYn", mktYn);
        params.put("siteId", siteId);
        String mapperName = TmsCampTargetRelMapper.class.getName();
        String sqlId = mapperName + ".selectRelMember";
        String sql = MapperSqlUtil.getQuery(this.sqlSession, sqlId, params);
        return sql.replaceAll("[\\r\\n\\t]+", " ");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertRelTargetInfo(RelTargetForm relTargetForm, String regId, int siteId) {
        ArrayList<TmsCampTargetRel> tmsCampTargetRelList = new ArrayList<TmsCampTargetRel>();
        for (RelTargetCondForm targetCondForm : relTargetForm.getRelTargetCond()) {
            TmsCampTargetRel tmsCampTargetRel = new TmsCampTargetRel();
            tmsCampTargetRel.setMsgId(relTargetForm.getMsgId()).setPostId(targetCondForm.getPostId()).setType(targetCondForm.getType()).setValue(targetCondForm.getValue());
            tmsCampTargetRelList.add(tmsCampTargetRel);
            this.tmsCampTargetRelMapper.insert(tmsCampTargetRel);
        }
        TmsCampMsgInfo msgInfo = this.tmsCampMsgInfoMapper.selectCampMsgInfo(relTargetForm.getMsgId());
        TmsCampChnInfo chnInfo = this.tmsCampChnInfoMapper.selectParentCampChnInfoByMsgId(relTargetForm.getMsgId());
        TmsCampTargetInfo tmsTargetInfo = this.getDefaultRelTargetInfo(relTargetForm.getMsgId(), msgInfo, chnInfo);
        tmsTargetInfo.setRegId(regId);
        tmsTargetInfo.setTargetDbQuery(this.getRelTargetSql(tmsCampTargetRelList, relTargetForm.getChannelType(), siteId, msgInfo.getMktYn()));
        tmsTargetInfo.setDeduplicationYn(relTargetForm.getDeduplicationYn());
        String msgId = tmsTargetInfo.getMsgId();
        String postId = tmsTargetInfo.getPostId();
        String maxPostId = this.selectMaxPostId(msgId);
        if (!"Y".equalsIgnoreCase(msgInfo.getAbTestYn())) {
            for (TargetServerInfo server : relTargetForm.getServer()) {
                server.setMsgId(msgId);
                server.setPostId(postId);
                this.tmsTargetServerMapper.insertTargetServer(server);
            }
        } else {
            this.insertTargetAbTestTask(relTargetForm.getServer(), msgId);
        }
        tmsTargetInfo.setPostId(maxPostId);
        this.tmsCampTargetInfoMapper.insert(tmsTargetInfo);
    }

    public int insertTargetAbTestTask(List<TargetServerInfo> serverList, String msgId) {
        int insertCnt = 0;
        this.deleteTargetServer(msgId);
        List<TmsCampChnInfo> postList = this.tmsCampChnInfoMapper.selectCampChnInfoByMsgId(msgId);
        for (TmsCampChnInfo postMap : postList) {
            for (TargetServerInfo server : serverList) {
                server.setPostId(postMap.getPostId());
                server.setMsgId(msgId);
                if (server.getParticipationRate() == 0) continue;
                insertCnt += this.tmsTargetServerMapper.insertTargetServer(server);
            }
        }
        return insertCnt;
    }

    public int deleteTargetServer(String msgId) {
        return this.campaignSingleManagerMapper.deleteTargetServer(msgId);
    }

    public String selectMaxPostId(String msgId) {
        return this.campaignSingleManagerMapper.selectMaxPostId(msgId);
    }

    @Override
    public List<MessageInfo> getCompletedSendMsgList(String channelType, String searchWord, PageInfo pageInfo, TmsUserSession tmsUserSession, String regId, String deptId) {
        ArrayList<String> jobStatusList = new ArrayList<String>();
        jobStatusList.add(StatusType.COMPLETE.getCode());
        pageInfo.calculate(this.relTargetMapper.selectSuccessMsgSchdListCnt(channelType, searchWord, tmsUserSession, regId, deptId));
        return this.relTargetMapper.selectSuccessMsgSchdList(channelType, searchWord, pageInfo, tmsUserSession, regId, deptId);
    }

    @Override
    public List<TmsCampLinkInfo> getClickInfoList(String postId) {
        return this.tmsCampLinkInfoMapper.selectClickListByPostId(postId);
    }
}

