/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.automation;

import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.mapper.automation.AutoAlimTalkMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.automation.TmsAutoAlimTalkInfo;
import com.humuson.tms.model.automation.TmsAutoAlimTalkSchInfo;
import com.humuson.tms.model.automation.TmsAutoAlimTalkSendInfo;
import com.humuson.tms.model.automation.TmsAutoChnInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.automation.AutoAlimtalkService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AutoAlimtalkServiceImpl
implements AutoAlimtalkService {
    @Autowired
    AutoAlimTalkMapper autoAlimtalkListMapper;

    @Override
    public List<TmsAutoAlimTalkInfo> selectAutoAlimTalkList(PageInfo pg, TmsAutoAlimTalkInfo tmsAutoAlimTalkInfo, TmsUserSession tmsUserSession) {
        pg.calculate(this.totalCnt(tmsAutoAlimTalkInfo, tmsUserSession));
        tmsAutoAlimTalkInfo.calculateDate();
        return this.autoAlimtalkListMapper.selectAutoAlimTalkList(pg, tmsAutoAlimTalkInfo, tmsUserSession);
    }

    @Override
    public List<TmsAutoAlimTalkSchInfo> selectAutoScheAlimTalkList(TmsAutoAlimTalkInfo tmsAutoAlimTalkInfo, PageInfo pageInfo) {
        tmsAutoAlimTalkInfo.calculateDate();
        pageInfo.calculate(this.autoAlimtalkListMapper.selectAutoScheAlimTalkListCnt(tmsAutoAlimTalkInfo));
        return this.autoAlimtalkListMapper.selectAutoScheAlimTalkList(tmsAutoAlimTalkInfo, pageInfo);
    }

    @Override
    public int totalCnt(TmsAutoAlimTalkInfo tmsAutoAlimTalkInfo, TmsUserSession tmsUserSession) {
        return this.autoAlimtalkListMapper.totalCnt(tmsAutoAlimTalkInfo, tmsUserSession);
    }

    @Override
    public int updateAutoMsgYn(TmsAutoAlimTalkInfo tmsAutoAlimTalkInfo) {
        return this.autoAlimtalkListMapper.updateAutoMsgYn(tmsAutoAlimTalkInfo);
    }

    @Override
    public int updateAutoChnYn(TmsAutoAlimTalkInfo tmsAutoAlimTalkInfo) {
        return this.autoAlimtalkListMapper.updateAutoChnYn(tmsAutoAlimTalkInfo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteAutoMsg(Map<String, String> param) {
        TmsAutoAlimTalkInfo info = new TmsAutoAlimTalkInfo();
        info.setMsgType(param.get("msgType"));
        info.setMsgTypeSeq(param.get("msgTypeSeq"));
        info.setUseYn("N");
        if (this.autoAlimtalkListMapper.updateAutoMsgYn(info) <= 0) {
            throw new RuntimeException("delete auto msg error");
        }
        if (this.autoAlimtalkListMapper.updateAutoChnYn(info) <= 0) {
            throw new RuntimeException("delete auto msg error");
        }
        if (this.autoAlimtalkListMapper.deleteAutoMsg(param) <= 0) {
            throw new RuntimeException("delete auto msg error");
        }
    }

    @Override
    public TmsAutoChnInfo selectAlimtalkContent(TmsAutoAlimTalkInfo tmsAutoAlimTalkInfo) {
        return this.autoAlimtalkListMapper.selectAlimtalkContent(tmsAutoAlimTalkInfo);
    }

    @Override
    public int selectAlimtalkSendCount(TmsAutoAlimTalkInfo tmsAutoAlimTalkInfo) {
        return this.autoAlimtalkListMapper.selectAlimtalkSendCount(tmsAutoAlimTalkInfo);
    }

    @Override
    public List<TmsAutoAlimTalkSendInfo> selectAlimtalkSendList(TmsAutoAlimTalkInfo tmsAutoAlimTalkInfo, PageInfo pageInfo, String randomListing, String searchCond, String searchWord) {
        tmsAutoAlimTalkInfo.calculateDate();
        pageInfo.calculate(this.selectAlimtalkSendCount(tmsAutoAlimTalkInfo));
        return this.autoAlimtalkListMapper.selectAlimtalkSendList(tmsAutoAlimTalkInfo, pageInfo, randomListing, searchCond, searchWord);
    }

    @Override
    public String getMappedAlimTalkContent(Map<String, String> param) {
        Map<String, String> mapData = this.autoAlimtalkListMapper.selectForMappingAlimTalkContent(param);
        String content = mapData.get("content");
        String selectQry = mapData.get("querySelect");
        String mapping = mapData.get("mapping");
        String alimTalkContent = content;
        try {
            Pattern patternSelect;
            Matcher matcherSelect;
            alimTalkContent = FileUtil.readUrl((String)content);
            Pattern patternFrom = Pattern.compile("\\s([Ff][Rr][Oo][Mm])\\s");
            Matcher matcherFrom = patternFrom.matcher(selectQry);
            if (matcherFrom.find()) {
                selectQry = selectQry.substring(0, matcherFrom.start());
            }
            if ((matcherSelect = (patternSelect = Pattern.compile("([Ss][Ee][Ll][Ee][Cc][Tt])\\s")).matcher(selectQry)).find()) {
                selectQry = selectQry.substring(matcherSelect.end());
            }
            String[] splitQry = selectQry.split(",");
            String[] mapHeader = new String[splitQry.length];
            for (int i = 0; i < splitQry.length; ++i) {
                splitQry[i] = splitQry[i].trim();
                splitQry[i] = splitQry[i].replaceAll("\\t+", " ");
                splitQry[i] = splitQry[i].replaceAll("\\s+", " ");
                String[] temp = splitQry[i].split("\\s");
                if (temp.length == 1) {
                    if (temp[0].contains(".")) {
                        mapHeader[i] = temp[0].substring(temp[0].indexOf(".") + 1).toUpperCase();
                        continue;
                    }
                    mapHeader[i] = temp[0].toUpperCase();
                    continue;
                }
                mapHeader[i] = temp[temp.length - 1].toUpperCase();
            }
            String[] mapValue = mapping.split("\\|");
            if (!StringUtils.isNull((String)alimTalkContent)) {
                for (int k = 0; k < mapHeader.length; ++k) {
                    if (k >= mapValue.length || mapHeader[k] == null || mapValue[k] == null) continue;
                    alimTalkContent = StringUtils.parseSQL((String)alimTalkContent, (String)mapHeader[k], (String)mapValue[k]);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return alimTalkContent;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public int removeSchdList(Map<String, String> params) {
        params.put("jobStatus", "99");
        return this.autoAlimtalkListMapper.updateJobStatusSchdInfo(params);
    }
}

