/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.analytics;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.CampType;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.mapper.analytics.AnalyticsSendAmntMapper;
import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.SysUserMgrInfo;
import com.humuson.tms.model.TmsCampInfo;
import com.humuson.tms.model.analytics.AnalyticsSendAmntInfo;
import com.humuson.tms.model.form.SendAmntStatForm;
import com.humuson.tms.service.account.DeptMgrService;
import com.humuson.tms.service.analytics.AnalyticsSendAmntService;
import com.humuson.tms.service.excel.FillManagerSingleCamp;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnalysticsSendAmntServiceImpl
implements AnalyticsSendAmntService {
    @Autowired
    AnalyticsSendAmntMapper sendAmntStatMapper;
    @Autowired
    DeptMgrService deptMgrService;

    @Override
    public List<SysUserMgrInfo> selectUserList() {
        return this.sendAmntStatMapper.selectUserList();
    }

    private Map<String, String> getUserNameMap() {
        HashMap<String, String> userMap = new HashMap<String, String>();
        List<SysUserMgrInfo> userList = this.selectUserList();
        for (SysUserMgrInfo info : userList) {
            userMap.put(info.getUserId(), info.getUserName());
        }
        return userMap;
    }

    @Override
    public List<TmsCampInfo> selectCampList(String siteId, String campType) {
        return this.sendAmntStatMapper.selectCampList(siteId, campType);
    }

    private Map<String, String> getCampNameMap(String siteId, String campType) {
        HashMap<String, String> campNameMap = new HashMap<String, String>();
        List<TmsCampInfo> campInfo = this.selectCampList(siteId, campType);
        for (TmsCampInfo info : campInfo) {
            campNameMap.put(info.getCampId(), info.getCampName());
        }
        return campNameMap;
    }

    @Override
    public List<AnalyticsSendAmntInfo> selectAutoSendAmntList(SendAmntStatForm sendAmntStatForm) {
        return this.sendAmntStatMapper.selectAutoSendAmntList(sendAmntStatForm);
    }

    @Override
    public List<AnalyticsSendAmntInfo> selectCampSendAmntList(SendAmntStatForm sendAmntStatForm) {
        return this.sendAmntStatMapper.selectCampSendAmntList(sendAmntStatForm);
    }

    @Override
    public void downloadXLS(HttpServletResponse response, int siteId, SendAmntStatForm sendAmntStatForm, PeriodInfo periodInfo) {
        String title = "Analytics";
        ArrayList<String> columnList = new ArrayList<String>();
        StringBuilder builder2 = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getTimeType())) {
            builder2.append("Time/");
        }
        if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getDept())) {
            builder2.append("Dept/");
        }
        if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getUser())) {
            builder2.append("User/");
        }
        if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getCampaign())) {
            builder2.append("Campaign/");
        }
        if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getMsgGroup())) {
            builder2.append("MsgGroup/");
        }
        if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getChannelType())) {
            builder2.append("Channel/");
        }
        if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getMsg())) {
            builder2.append("Msg/");
        }
        columnList.add(builder2.substring(0, builder2.length() - 1));
        columnList.add("Message Count");
        columnList.add("Sending Count");
        columnList.add("Success");
        columnList.add("Fail");
        columnList.add("Open");
        columnList.add("Click");
        columnList.add("ClickRatePerOpen");
        List<AnalyticsSendAmntInfo> sendAmntStatList = null;
        String msgType = sendAmntStatForm.getMsgType();
        sendAmntStatList = CampType.SINGLE.same(msgType) || CampType.MULTI.same(msgType) ? this.sendAmntStatMapper.selectCampSendAmntList(sendAmntStatForm) : this.sendAmntStatMapper.selectAutoSendAmntList(sendAmntStatForm);
        Map<String, String> deptMap = this.deptMgrService.getDeptMap();
        Map<String, String> userNameMap = this.getUserNameMap();
        Map<String, String> campNameMsp = this.getCampNameMap(String.valueOf(siteId), msgType);
        AnalyticsSendAmntInfo sendAmntSummary = new AnalyticsSendAmntInfo();
        AnalyticsSendAmntInfo amntInfo = null;
        for (int i = 0; i < sendAmntStatList.size(); ++i) {
            amntInfo = sendAmntStatList.get(i);
            amntInfo.work();
            sendAmntSummary.setMsgCnt(sendAmntSummary.getMsgCnt() + amntInfo.getMsgCnt());
            sendAmntSummary.setPushedCnt(sendAmntSummary.getPushedCnt() + amntInfo.getPushedCnt());
            sendAmntSummary.setDeliveredCnt(sendAmntSummary.getDeliveredCnt() + amntInfo.getDeliveredCnt());
            sendAmntSummary.setFailCnt(sendAmntSummary.getFailCnt() + amntInfo.getFailCnt());
            sendAmntSummary.setOpenCnt(sendAmntSummary.getOpenCnt() + amntInfo.getOpenCnt());
            sendAmntSummary.setClickCnt(sendAmntSummary.getClickCnt() + amntInfo.getClickCnt());
            builder2.setLength(0);
            if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getTimeType())) {
                builder2.append(amntInfo.getDate()).append("/");
            }
            if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getDept())) {
                builder2.append(deptMap.get(amntInfo.getDeptId())).append("/");
            }
            if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getUser())) {
                builder2.append(userNameMap.get(amntInfo.getRegId())).append("/");
            }
            if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getCampaign())) {
                builder2.append(campNameMsp.get(amntInfo.getCampId())).append("/");
            }
            if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getMsgGroup())) {
                builder2.append(amntInfo.getMsgGroupName()).append("/");
            }
            if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getChannelType())) {
                builder2.append(ChannelType.findName((String)amntInfo.getChannelType())).append("/");
            }
            if (StringUtils.isNotEmpty((CharSequence)sendAmntStatForm.getMsg())) {
                builder2.append(amntInfo.getMsgName()).append("/");
            }
            amntInfo.setGubun(builder2.substring(0, builder2.length() - 1));
        }
        sendAmntSummary.work();
        sendAmntSummary.setGubun("SUM");
        sendAmntStatList.add(sendAmntSummary);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet[] worksheet = new HSSFSheet[]{workbook.createSheet("Analytics")};
        int startRowIndex = 0;
        int startColIndex = 0;
        Layouter.buildReport(worksheet[0], startRowIndex, startColIndex, title, columnList, periodInfo);
        FillManagerSingleCamp.fillReportAnalytics(worksheet[0], startRowIndex, startColIndex, sendAmntStatList);
        String fileName = title + ".xls";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        Writer.write(response, worksheet);
    }
}

