/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.access.authority;

import com.humuson.tms.constrants.StatusType;
import com.humuson.tms.constrants.TargetStatus;
import com.humuson.tms.exception.StatusDataNotFoundException;
import com.humuson.tms.mapper.access.authority.MsgAccessAuthorityMapper;
import com.humuson.tms.service.access.authority.MsgAccessAuthService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgAccessAuthServiceImpl
implements MsgAccessAuthService {
    @Autowired
    MsgAccessAuthorityMapper campaignAccessAuthorityMapper;

    private boolean checkTargetServerAccessByTargetStatus(String targetStatus) {
        return !TargetStatus.isIn((String)targetStatus, (TargetStatus[])new TargetStatus[]{TargetStatus.RESERVE, TargetStatus.CANCEL_COMPLETE, TargetStatus.COMPLETE, TargetStatus.ERROR, TargetStatus.SPOOL_ERROR});
    }

    private boolean checkTargetServerAccess(String msgId) {
        String targetStatus = this.campaignAccessAuthorityMapper.selectTargetStatus(msgId, null);
        return this.checkTargetServerAccessByTargetStatus(targetStatus);
    }

    private boolean checkTargetServerAccessByPostId(String postId) {
        String targetStatus = this.campaignAccessAuthorityMapper.selectTargetStatus(null, postId);
        return this.checkTargetServerAccessByTargetStatus(targetStatus);
    }

    private boolean checkSendServerAccessByJobStatus(String jobStatus) {
        return !StatusType.isIn((String)jobStatus, (StatusType[])new StatusType[]{StatusType.PENDDING, StatusType.STOP_SEND_COMPLETE, StatusType.COMPLETE, StatusType.ERROR});
    }

    private boolean checkSendServerAccess(List<String> jobStatusList) {
        for (String jobStatus : jobStatusList) {
            if (!this.checkSendServerAccessByJobStatus(jobStatus)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSendServerAccess(String msgId) {
        List<String> jobStatusList = this.campaignAccessAuthorityMapper.selectJobStatus(msgId, null, null);
        return this.checkSendServerAccess(jobStatusList);
    }

    private boolean checkSendServerAccessByPostId(String postId) {
        List<String> jobStatusList = this.campaignAccessAuthorityMapper.selectJobStatus(null, postId, null);
        return this.checkSendServerAccess(jobStatusList);
    }

    @Override
    public boolean canAccessMsgStep(String msgId) {
        return true;
    }

    @Override
    public boolean canEditMsg(String postId) {
        if (postId == null) {
            return true;
        }
        List<String> jobStatusList = this.campaignAccessAuthorityMapper.selectJobStatus(null, postId, null);
        if (jobStatusList == null || jobStatusList.size() == 0) {
            return true;
        }
        return !this.isSendComplete(jobStatusList) && !this.checkSendServerAccess(jobStatusList);
    }

    @Override
    public boolean isMsgSaved(String postId) {
        String contentHtml = this.campaignAccessAuthorityMapper.selectContentHtmlByPostId(postId);
        if (contentHtml != null) {
            return true;
        }
        return true;
    }

    @Override
    public boolean isMsgAllSaved(String msgId) {
        List<String> contentHtmlList = this.campaignAccessAuthorityMapper.selectContentHtmlByMsgIdWithoutRealMsg(msgId);
        if (contentHtmlList == null || contentHtmlList.size() == 0) {
            return false;
        }
        for (String contentHtml : contentHtmlList) {
            if (contentHtml != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canAccessTargetStep(String msgId) {
        return this.isMsgAllSaved(msgId);
    }

    @Override
    public boolean canEditTarget(String msgId) {
        List<String> jobStatusList = this.campaignAccessAuthorityMapper.selectJobStatus(msgId, null, null);
        String targetStatus = this.campaignAccessAuthorityMapper.selectTargetStatus(msgId, null);
        if (jobStatusList == null || jobStatusList.size() == 0) {
            throw new StatusDataNotFoundException();
        }
        if (targetStatus == null) {
            return true;
        }
        return !this.checkTargetServerAccessByTargetStatus(targetStatus) && !this.checkSendServerAccess(jobStatusList) && !this.isSendComplete(jobStatusList);
    }

    @Override
    public boolean canStopTargeting(String msgId) {
        List<String> jobStatusList = this.campaignAccessAuthorityMapper.selectJobStatus(msgId, null, null);
        String targetStatus = this.campaignAccessAuthorityMapper.selectTargetStatus(msgId, null);
        if (targetStatus == null || jobStatusList == null || jobStatusList.size() == 0) {
            throw new StatusDataNotFoundException();
        }
        return !this.checkTargetServerAccessByTargetStatus(targetStatus) && !this.checkSendServerAccess(jobStatusList) && !this.isSendComplete(jobStatusList);
    }

    @Override
    public boolean isTargetComplete(String msgId) {
        String targetStatus = this.campaignAccessAuthorityMapper.selectTargetStatus(msgId, null);
        if (targetStatus == null) {
            return false;
        }
        int targetCnt = this.campaignAccessAuthorityMapper.selectTargetCnt(msgId);
        return TargetStatus.COMPLETE.same(targetStatus) && targetCnt > 0;
    }

    @Override
    public boolean canMakeSamplingPreview(String msgId) {
        return this.isMsgAllSaved(msgId) && this.isTargetComplete(msgId);
    }

    @Override
    public boolean canAccessTestStep(String msgId) {
        return this.isMsgAllSaved(msgId);
    }

    @Override
    public boolean canSendTestMsg(String msgId) {
        return this.isMsgAllSaved(msgId);
    }

    @Override
    public boolean canAccessSendStep(String msgId) {
        return this.isMsgAllSaved(msgId) && this.isTargetComplete(msgId);
    }

    @Override
    public boolean canSendMsg(String msgId) {
        List<String> jobStatusList = this.campaignAccessAuthorityMapper.selectJobStatus(msgId, null, null);
        if (jobStatusList == null || jobStatusList.size() == 0) {
            return false;
        }
        return this.isMsgAllSaved(msgId) && this.isTargetComplete(msgId) && !this.isSendComplete(jobStatusList) && !this.checkSendServerAccess(jobStatusList);
    }

    @Override
    public boolean canCancelSend(String msgId) {
        List<String> jobStatusList = this.campaignAccessAuthorityMapper.selectJobStatus(msgId, null, null);
        if (jobStatusList == null || jobStatusList.size() == 0) {
            throw new StatusDataNotFoundException();
        }
        return !this.checkSendServerAccess(jobStatusList) && !this.isSendComplete(jobStatusList);
    }

    @Override
    public boolean canStopSend(String msgId, String serverId) {
        List<String> jobStatusList = this.campaignAccessAuthorityMapper.selectJobStatus(msgId, null, serverId);
        if (jobStatusList == null || jobStatusList.size() == 0) {
            throw new StatusDataNotFoundException();
        }
        for (String jobStatus : jobStatusList) {
            if (StatusType.SENDING.same(jobStatus) && StatusType.RESEND.same(jobStatus)) continue;
            return false;
        }
        return true;
    }

    private boolean isSendComplete(List<String> jobStatusList) {
        for (String jobStatus : jobStatusList) {
            if (StatusType.COMPLETE.same(jobStatus)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSendComplete(String msgId) {
        List<String> jobStatusList = this.campaignAccessAuthorityMapper.selectJobStatus(msgId, null, null);
        return this.isSendComplete(jobStatusList);
    }

    @Override
    public boolean canDeleteSingleMsg(String postId) {
        return !this.checkTargetServerAccessByPostId(postId) && !this.checkSendServerAccessByPostId(postId);
    }

    @Override
    public boolean canDeleteAllMsg(String msgId) {
        return !this.checkTargetServerAccess(msgId) && !this.checkSendServerAccess(msgId);
    }
}

