/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl;

import com.humuson.tms.common.util.FileExtentionUtil;
import com.humuson.tms.exception.FileUploadFailException;
import com.humuson.tms.exception.InvalidFileTypeException;
import com.humuson.tms.model.ImgInfo;
import com.humuson.tms.service.TempImgUploadService;
import java.io.File;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TempImgUploadServiceImpl
implements TempImgUploadService {
    @Value(value="${img.upload.path}")
    String uploadPath;
    @Value(value="${img.upload.url}")
    String urlBasePath;

    private String makeTempImgFileName(String originalFileName) {
        return UUID.randomUUID().toString() + "." + FilenameUtils.getExtension((String)originalFileName);
    }

    private String getTempImgUrl(String tempImgFileName) {
        return this.urlBasePath + "/" + tempImgFileName;
    }

    @Override
    public ImgInfo uploadTempImage(MultipartFile imgFile) {
        String oriName = imgFile.getOriginalFilename();
        String newFileName = this.makeTempImgFileName(oriName);
        if (!FileExtentionUtil.isImageFileExtention((String)oriName)) {
            throw new InvalidFileTypeException();
        }
        try {
            newFileName = this.makeTempImgFileName(oriName);
            imgFile.transferTo(new File(this.uploadPath + File.separator + newFileName));
        }
        catch (Exception e) {
            throw new FileUploadFailException();
        }
        return new ImgInfo().setContentType(imgFile.getContentType()).setName(newFileName).setSize(imgFile.getSize()).setUrl(this.getTempImgUrl(newFileName));
    }

    @Override
    public boolean moveTempImgToPath(String tempImgFileName, String fullPath) {
        try {
            return new File(tempImgFileName).renameTo(new File(fullPath));
        }
        catch (Exception e) {
            throw new FileUploadFailException();
        }
    }
}

