/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.model.PeriodInfo;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Layouter {
    Logger logger = LoggerFactory.getLogger(Layouter.class);

    public static void buildReport(HSSFSheet worksheet, int startRowIndex, int startColIndex, String title, List<String> columnList, String workday) {
        int listCount = columnList.size();
        for (int i = 0; i < listCount; ++i) {
            worksheet.setColumnWidth(i, 5000);
        }
        Layouter.buildTitle(worksheet, startRowIndex, startColIndex, title, workday);
        Layouter.buildHeaders(worksheet, startRowIndex, startColIndex, columnList);
    }

    public static void buildTitle(HSSFSheet worksheet, int startRowIndex, int startColIndex, String title, String workday) {
        HSSFFont fontTitle = worksheet.getWorkbook().createFont();
        fontTitle.setBoldweight((short)700);
        fontTitle.setFontHeight((short)280);
        HSSFCellStyle cellStyleTitle = worksheet.getWorkbook().createCellStyle();
        cellStyleTitle.setAlignment((short)2);
        cellStyleTitle.setWrapText(true);
        cellStyleTitle.setFont((Font)fontTitle);
        HSSFRow rowTitle = worksheet.createRow((int)((short)startRowIndex));
        rowTitle.setHeight((short)500);
        HSSFCell cellTitle = rowTitle.createCell(startColIndex);
        cellTitle.setCellValue(title);
        cellTitle.setCellStyle(cellStyleTitle);
        HSSFCell cellDueDate = rowTitle.createCell(startColIndex + 1);
        cellDueDate.setCellValue("( " + workday + " )");
        HSSFRow dateTitle = worksheet.createRow((short)startRowIndex + 1);
        HSSFCell cellDate = dateTitle.createCell(startColIndex);
        cellDate.setCellValue("This report was generated at " + new Date());
    }

    public static void buildReport(HSSFSheet worksheet, int startRowIndex, int startColIndex, String title, List<String> columnList, PeriodInfo periodInfo) {
        int listCount = columnList.size();
        for (int i = 0; i < listCount; ++i) {
            worksheet.setColumnWidth(i, 5000);
            if (i != 0) continue;
            worksheet.setColumnWidth(i, 10000);
        }
        Layouter.buildTitle(worksheet, startRowIndex, startColIndex, title, periodInfo);
        Layouter.buildHeaders(worksheet, startRowIndex, startColIndex, columnList);
    }

    public static void buildTitle(HSSFSheet worksheet, int startRowIndex, int startColIndex, String title, PeriodInfo periodInfo) {
        HSSFFont fontTitle = worksheet.getWorkbook().createFont();
        fontTitle.setBoldweight((short)700);
        fontTitle.setFontHeight((short)280);
        HSSFCellStyle cellStyleTitle = worksheet.getWorkbook().createCellStyle();
        cellStyleTitle.setAlignment((short)2);
        cellStyleTitle.setWrapText(true);
        cellStyleTitle.setFont((Font)fontTitle);
        HSSFRow rowTitle = worksheet.createRow((int)((short)startRowIndex));
        rowTitle.setHeight((short)500);
        HSSFCell cellTitle = rowTitle.createCell(startColIndex);
        cellTitle.setCellValue(title);
        cellTitle.setCellStyle(cellStyleTitle);
        if (periodInfo.getStartDate() != null) {
            HSSFCell cellDueDate = rowTitle.createCell(startColIndex + 1);
            cellDueDate.setCellValue("( " + periodInfo.getStartDate() + " ~ " + periodInfo.getEndDate() + " )");
        }
        HSSFRow dateTitle = worksheet.createRow((short)startRowIndex + 1);
        HSSFCell cellDate = dateTitle.createCell(startColIndex);
        cellDate.setCellValue("This report was generated at " + new Date());
    }

    public static void buildHeaders(HSSFSheet worksheet, int startRowIndex, int startColIndex, List<String> columnList) {
        HSSFFont font = worksheet.getWorkbook().createFont();
        font.setBoldweight((short)700);
        HSSFCellStyle headerCellStyle = worksheet.getWorkbook().createCellStyle();
        headerCellStyle.setFillBackgroundColor((short)22);
        headerCellStyle.setFillPattern((short)2);
        headerCellStyle.setAlignment((short)2);
        headerCellStyle.setVerticalAlignment((short)1);
        headerCellStyle.setWrapText(true);
        headerCellStyle.setFont((Font)font);
        headerCellStyle.setBorderBottom((short)1);
        HSSFRow rowHeader = worksheet.createRow((short)startRowIndex + 2);
        rowHeader.setHeight((short)500);
        int listCount = columnList.size();
        for (int i = 0; i < listCount; ++i) {
            String columnName = columnList.get(i);
            HSSFCell cell = rowHeader.createCell(startColIndex + i);
            cell.setCellValue(columnName);
            cell.setCellStyle(headerCellStyle);
        }
    }
}

