/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.model.analytics.AnalyticsUserApiInfo;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FillManagerUser {
    private static final Logger log = LoggerFactory.getLogger(FillManagerUser.class);

    public static void fillReport(HSSFSheet worksheet, int startRowIndex, int startColIndex, List<AnalyticsUserApiInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        HSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            HSSFRow row = worksheet.createRow((short)i + 1);
            AnalyticsUserApiInfo info = dataList.get(i - 2);
            HSSFCell cell1 = row.createCell(startColIndex + 0);
            cell1.setCellValue(info.getWorkday().substring(0, 4) + "/" + info.getWorkday().substring(4, 6) + "/" + info.getWorkday().substring(6, 8));
            cell1.setCellStyle(bodyCellStyle);
            HSSFCell cell2 = row.createCell(startColIndex + 1);
            cell2.setCellValue(StringUtils.moneyForm((String)(info.getUqSessCnt() + "")));
            cell2.setCellStyle(bodyCellStyle);
            HSSFCell cell3 = row.createCell(startColIndex + 2);
            cell3.setCellValue(StringUtils.moneyForm((String)(info.getNewSessCnt() + "")));
            cell3.setCellStyle(bodyCellStyle);
            HSSFCell cell4 = row.createCell(startColIndex + 3);
            cell4.setCellValue(StringUtils.moneyForm((String)(info.getRtSessCnt() + "")));
            cell4.setCellStyle(bodyCellStyle);
            ++i;
        }
    }
}

