/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.model;

public class PageInfo {
    public static final int PAGE_DAFAULT_SIZE = 5;
    public static final int PAGE_BLOCK_DAFAULT_SIZE = 5;
    private int totalPage;
    private int size = 5;
    private int startId;
    private int currentId = 1;
    private int endId;
    private int totalCnt;
    private int pageBlockSize = 5;
    private int currentRow;
    private int secondRow;
    private int endRow;

    public PageInfo() {
    }

    public PageInfo(int currentId, int size) {
        this.currentId = Math.max(1, currentId);
        this.size = size;
    }

    public void calculate(int totalCnt) {
        this.totalCnt = totalCnt;
        this.totalPage = Math.max(1, (int)Math.ceil((double)totalCnt / (double)this.size));
        this.startId = (this.currentId - 1) / this.pageBlockSize * this.pageBlockSize + 1;
        this.endId = Math.min((this.currentId - 1) / this.pageBlockSize * this.pageBlockSize + this.pageBlockSize, this.totalPage);
        this.currentRow = (this.currentId - 1) * this.size;
        this.secondRow = (this.currentId + 1) * this.size;
        this.endRow = this.currentRow + this.size;
    }

    public void setCurrentId(int currentId) {
        this.currentId = Math.max(1, currentId);
    }

    public void setSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be grater than zero");
        }
        this.size = size;
    }

    public void setPageBlockSize(int pageBlockSize) {
        if (pageBlockSize <= 0) {
            throw new IllegalArgumentException("pageBlockSize must be grater than zero");
        }
        this.pageBlockSize = pageBlockSize;
    }

    public void setPage(int page) {
        this.currentId = Math.max(1, page);
    }

    public int getPage() {
        return this.currentId;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public int getSize() {
        return this.size;
    }

    public int getStartId() {
        return this.startId;
    }

    public int getCurrentId() {
        return this.currentId;
    }

    public int getEndId() {
        return this.endId;
    }

    public int getTotalCnt() {
        return this.totalCnt;
    }

    public int getPageBlockSize() {
        return this.pageBlockSize;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public int getSecondRow() {
        return this.secondRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public void setStartId(int startId) {
        this.startId = startId;
    }

    public void setEndId(int endId) {
        this.endId = endId;
    }

    public void setTotalCnt(int totalCnt) {
        this.totalCnt = totalCnt;
    }

    public void setCurrentRow(int currentRow) {
        this.currentRow = currentRow;
    }

    public void setSecondRow(int secondRow) {
        this.secondRow = secondRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageInfo)) {
            return false;
        }
        PageInfo other = (PageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getStartId() != other.getStartId()) {
            return false;
        }
        if (this.getCurrentId() != other.getCurrentId()) {
            return false;
        }
        if (this.getEndId() != other.getEndId()) {
            return false;
        }
        if (this.getTotalCnt() != other.getTotalCnt()) {
            return false;
        }
        if (this.getPageBlockSize() != other.getPageBlockSize()) {
            return false;
        }
        if (this.getCurrentRow() != other.getCurrentRow()) {
            return false;
        }
        if (this.getSecondRow() != other.getSecondRow()) {
            return false;
        }
        return this.getEndRow() == other.getEndRow();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalPage();
        result = result * 59 + this.getSize();
        result = result * 59 + this.getStartId();
        result = result * 59 + this.getCurrentId();
        result = result * 59 + this.getEndId();
        result = result * 59 + this.getTotalCnt();
        result = result * 59 + this.getPageBlockSize();
        result = result * 59 + this.getCurrentRow();
        result = result * 59 + this.getSecondRow();
        result = result * 59 + this.getEndRow();
        return result;
    }

    public String toString() {
        return "PageInfo(totalPage=" + this.getTotalPage() + ", size=" + this.getSize() + ", startId=" + this.getStartId() + ", currentId=" + this.getCurrentId() + ", endId=" + this.getEndId() + ", totalCnt=" + this.getTotalCnt() + ", pageBlockSize=" + this.getPageBlockSize() + ", currentRow=" + this.getCurrentRow() + ", secondRow=" + this.getSecondRow() + ", endRow=" + this.getEndRow() + ")";
    }
}

