/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.jstl;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.model.vo.TmsUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.tagext.TagSupport;
import org.springframework.security.core.context.SecurityContextHolder;

public class JstlFunction
extends TagSupport {
    private static final long serialVersionUID = -4812749184475182037L;

    public static String monthAddZeroFn(String month) {
        if (month.length() == 1) {
            month = "0" + month;
        }
        return month;
    }

    public static String TimeAddZeroFn(String time) {
        if (time.length() == 1) {
            time = "0" + time;
        }
        return time;
    }

    public static String cntFormFn(String cnt) {
        return StringUtils.moneyForm((String)cnt);
    }

    public static String subStr(String str, String startIndex, String endIndex, String addStr) {
        int length = str.length();
        int sIndex = Integer.parseInt(startIndex);
        int eIndex = Integer.parseInt(endIndex);
        str = length <= eIndex ? str.substring(sIndex, length) : str.substring(sIndex, eIndex) + addStr;
        return str;
    }

    public static int parseInt(String str) {
        int result = 0;
        try {
            result = Integer.parseInt(str);
        }
        catch (Exception e) {
            System.out.print("JstlFunction class exception : " + e);
        }
        return result;
    }

    public static int rateFormFn(String s, String s1) {
        return Integer.parseInt(StringUtils.getRate((String)s, (String)s1));
    }

    public static String replaceAllFormFn(String strValue, String strOld, String strNew) {
        return StringUtils.replaceAllData((String)strValue, (String)strOld, (String)strNew);
    }

    public static String replaceAllFormFn(String strValue) {
        return StringUtils.replaceAllData((String)strValue, (String)"\n", (String)"<br/>");
    }

    public static String previewFormFn(String result, Map<String, String> map) {
        if (map != null) {
            result = StringUtils.replaceAllData((String)result, (String)"${TMS_M_ID}", (String)StringUtils.validString((String)map.get("MEMBER_ID")));
            result = StringUtils.replaceAllData((String)result, (String)"${EMS_M_ID}", (String)StringUtils.validString((String)map.get("MEMBER_ID")));
            result = StringUtils.replaceAllData((String)result, (String)"${TMS_M_NAME}", (String)StringUtils.validString((String)map.get("MEMBER_NAME")));
            result = StringUtils.replaceAllData((String)result, (String)"${EMS_M_NAME}", (String)StringUtils.validString((String)map.get("MEMBER_NAME")));
            result = StringUtils.replaceAllData((String)result, (String)"${TMS_M_EMAIL}", (String)StringUtils.validString((String)map.get("MEMBER_EMAIL")));
            result = StringUtils.replaceAllData((String)result, (String)"${EMS_M_EMAIL}", (String)StringUtils.validString((String)map.get("MEMBER_EMAIL")));
            result = StringUtils.replaceAllData((String)result, (String)"${TMS_M_PHONE}", (String)StringUtils.validString((String)map.get("MEMBER_PHONE")));
            result = StringUtils.replaceAllData((String)result, (String)"${EMS_M_PHONE}", (String)StringUtils.validString((String)map.get("MEMBER_PHONE")));
            result = StringUtils.replaceAllData((String)result, (String)"${TMS_M_PUSH}", (String)StringUtils.validString((String)map.get("MEMBER_TOKEN")));
            result = StringUtils.replaceAllData((String)result, (String)"${EMS_M_PUSH}", (String)StringUtils.validString((String)map.get("MEMBER_TOKEN")));
            result = StringUtils.replaceAllData((String)result, (String)"${FIELD1}", (String)StringUtils.validString((String)map.get("FIELD1")));
            result = StringUtils.replaceAllData((String)result, (String)"${FIELD2}", (String)StringUtils.validString((String)map.get("FIELD2")));
            result = StringUtils.replaceAllData((String)result, (String)"${FIELD3}", (String)StringUtils.validString((String)map.get("FIELD3")));
            result = StringUtils.replaceAllData((String)result, (String)"${FIELD4}", (String)StringUtils.validString((String)map.get("FIELD4")));
            result = StringUtils.replaceAllData((String)result, (String)"${FIELD5}", (String)StringUtils.validString((String)map.get("FIELD5")));
            result = StringUtils.replaceAllData((String)result, (String)"${FIELD6}", (String)StringUtils.validString((String)map.get("FIELD6")));
            result = StringUtils.replaceAllData((String)result, (String)"${FIELD7}", (String)StringUtils.validString((String)map.get("FIELD7")));
            result = StringUtils.replaceAllData((String)result, (String)"${FIELD8}", (String)StringUtils.validString((String)map.get("FIELD8")));
        }
        return result;
    }

    public static String hourChDateFormFn(String str) {
        String result = "0";
        if (!StringUtils.validString((String)str).equals("")) {
            int hours = Integer.parseInt(str);
            int date = hours / 24;
            int hour = hours % 24;
            result = date + "d " + hour + "h";
        }
        return result;
    }

    public static Object sessionUser(String property) {
        TmsUser user = (TmsUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (property.equals("name")) {
            return user.getRealName();
        }
        if (property.equals("id")) {
            return user.getUsername();
        }
        if (property.equals("dept")) {
            return user.getDeptName();
        }
        if (property.equals("dept_id")) {
            return user.getDeptId();
        }
        return user.getRealName();
    }

    public static String chageCodeName(String code) {
        String name = "";
        if ((code = StringUtils.validString((String)code)).equals("EM")) {
            name = "EMAIL";
        } else if (code.equals("SM")) {
            name = "SMS";
        } else if (code.equals("PU")) {
            name = "PUSH";
        }
        return name;
    }

    public static List<String> changeListType(String type) {
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.validString((String)type).equals("")) {
            String[] types;
            for (String changeType : types = type.split("\\|")) {
                list.add(changeType);
            }
        }
        return list;
    }

    public static String getOriginalTargetFileName(String targetFileName) {
        int firstIndex = targetFileName.indexOf("_");
        return targetFileName.substring(targetFileName.indexOf("_", firstIndex + 1) + 1, targetFileName.length());
    }

    public static String findChannelTypeCode(String str) {
        return ChannelType.findChannelTypeCode((String)str);
    }
}

