/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.exception.handler;

import com.fasterxml.jackson.core.JsonParseException;
import com.humuson.tms.api.component.ApiResponseFormConverter;
import com.humuson.tms.common.constant.ApiStatus;
import com.humuson.tms.config.WebApiBean;
import com.humuson.tms.model.api.ApiResponseForm;
import com.humuson.tms.model.api.FieldErrorForm;
import com.humuson.tms.model.api.FieldErrorSimpleForm;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@WebApiBean
@ControllerAdvice
public class GlobalApiExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalApiExceptionHandler.class);
    @Autowired
    ApiResponseFormConverter apiResponseFormConverter;

    private ApiResponseForm setStatusAndGetApiResponseForm(HttpServletRequest request, HttpServletResponse response, ApiStatus apiStatus, String message, Object data) {
        response.setStatus(apiStatus.getHttpStatus().value());
        return this.apiResponseFormConverter.makeApiResponseForm(request, apiStatus, message, data);
    }

    private ArrayList<FieldErrorForm> makeValidationErrorData(BindingResult result) {
        List fieldErrors = result.getFieldErrors();
        ArrayList<FieldErrorForm> fieldErrorResources = new ArrayList<FieldErrorForm>();
        for (FieldError fieldError : fieldErrors) {
            FieldErrorForm fieldErrorResource = new FieldErrorForm();
            fieldErrorResource.setResource(fieldError.getObjectName());
            fieldErrorResource.setField(fieldError.getField());
            fieldErrorResource.setMessage(fieldError.getDefaultMessage());
            fieldErrorResources.add(fieldErrorResource);
        }
        return fieldErrorResources;
    }

    private FieldErrorSimpleForm makeValidationErrorSummaryData(BindingResult result) {
        List fieldErrors = result.getFieldErrors();
        FieldErrorSimpleForm additionMsg = new FieldErrorSimpleForm();
        int errorCount = result.getFieldErrorCount();
        int msgCount = Math.min(10, errorCount);
        FieldErrorForm[] fieldErrorResources = new FieldErrorForm[msgCount];
        for (int i = msgCount - 1; i >= 0; --i) {
            FieldError fieldError = (FieldError)fieldErrors.get(i);
            FieldErrorForm fieldErrorResource = new FieldErrorForm();
            fieldErrorResource.setResource(fieldError.getObjectName());
            fieldErrorResource.setField(fieldError.getField());
            fieldErrorResource.setMessage(fieldError.getDefaultMessage());
            fieldErrorResources[i] = fieldErrorResource;
        }
        additionMsg.setSummarize(fieldErrorResources);
        additionMsg.setErrorCount(result.getFieldErrorCount());
        return additionMsg;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public ApiResponseForm handleNotSupportMethodException(HttpServletRequest request, HttpServletResponse response, HttpRequestMethodNotSupportedException ex) {
        log.error("GlobalApiExceptionHandler e : {}", (Throwable)ex);
        return this.setStatusAndGetApiResponseForm(request, response, ApiStatus.RequestMethodNotSupported, "method type not supported", null);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ApiResponseForm handleValidException(HttpServletRequest request, HttpServletResponse response, MethodArgumentNotValidException ex) {
        log.error("GlobalApiExceptionHandler e : {}", (Throwable)ex);
        FieldErrorSimpleForm filedErrorMsg = this.makeValidationErrorSummaryData(ex.getBindingResult());
        return this.setStatusAndGetApiResponseForm(request, response, ApiStatus.ParamNotValid, "method argument not valid", filedErrorMsg);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public ApiResponseForm handleBindException(HttpServletRequest request, HttpServletResponse response, BindException ex) {
        log.error("GlobalApiExceptionHandler e : {}", (Throwable)ex);
        FieldErrorSimpleForm filedErrorMsg = this.makeValidationErrorSummaryData(ex.getBindingResult());
        return this.setStatusAndGetApiResponseForm(request, response, ApiStatus.ParamNotValid, "param not valid", filedErrorMsg);
    }

    @ExceptionHandler(value={JsonParseException.class})
    @ResponseBody
    public ApiResponseForm handleJsonParseException(HttpServletRequest request, HttpServletResponse response, JsonParseException ex) {
        log.error("GlobalApiExceptionHandler e : {}", (Throwable)ex);
        return this.setStatusAndGetApiResponseForm(request, response, ApiStatus.JsonParseError, "param not valid", null);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public ApiResponseForm handleJsonParseException(HttpServletRequest request, HttpServletResponse response, HttpMessageNotReadableException ex) {
        log.error("GlobalApiExceptionHandler e : {}", (Throwable)ex);
        return this.setStatusAndGetApiResponseForm(request, response, ApiStatus.JsonParseError, "param not valid", null);
    }

    @ExceptionHandler(value={ServletRequestBindingException.class})
    @ResponseBody
    public ApiResponseForm handleCustomException(HttpServletRequest request, HttpServletResponse response, ServletRequestBindingException ex) {
        log.error("GlobalApiExceptionHandler e : {}", (Throwable)ex);
        return this.setStatusAndGetApiResponseForm(request, response, ApiStatus.NotReadableRequest, "servlet request bind error", null);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseBody
    public ApiResponseForm handleAllException(HttpServletRequest request, HttpServletResponse response, HttpMediaTypeNotSupportedException ex) {
        log.error("GlobalApiExceptionHandler e : {}", (Throwable)ex);
        return this.setStatusAndGetApiResponseForm(request, response, ApiStatus.ContentTypeError, "media type not supported", null);
    }

    @ExceptionHandler(value={MalformedURLException.class})
    @ResponseBody
    public ApiResponseForm handleAllException(HttpServletRequest request, HttpServletResponse response, MalformedURLException ex) {
        log.error("GlobalApiExceptionHandler e : {}", (Throwable)ex);
        return this.setStatusAndGetApiResponseForm(request, response, ApiStatus.ParamNotValid, "param not valid", null);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseBody
    public ApiResponseForm handleAllException(HttpServletRequest request, HttpServletResponse response, AccessDeniedException ex) {
        log.error("GlobalApiExceptionHandler e : {}", (Throwable)ex);
        return this.setStatusAndGetApiResponseForm(request, response, ApiStatus.AccessDenied, "", null);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ApiResponseForm handleAllException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        log.error("GlobalApiExceptionHandler e : {}", (Throwable)ex);
        return this.setStatusAndGetApiResponseForm(request, response, ApiStatus.ServerError, "", null);
    }
}

