/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.convert.handler;

import com.humuson.tms.convert.ConvertInfoResolver;
import com.humuson.tms.convert.handler.ConvertInfoHandleCheckable;
import com.humuson.tms.convert.handler.ConvertInfoHandler;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModelConvertHandler
implements ConvertInfoHandleCheckable,
ConvertInfoHandler<Object, Annotation> {
    private static final Logger log = LoggerFactory.getLogger(ModelConvertHandler.class);
    @Autowired
    ConvertInfoResolver resolver;

    @Override
    public Object convert(Annotation annotation, Object bean, Collection<Annotation> annotations, Map<String, Object> context) {
        ConvertInfoResolver.ModelConvertInfoDescriptor modelDescriptor = this.resolver.getModelDescriptor(bean.getClass());
        Object target = null;
        List<Field> li = modelDescriptor.getFieldByAnnotation(annotation);
        if (li != null) {
            for (Field field : modelDescriptor.getFieldByAnnotation(annotation)) {
                try {
                    PropertyDescriptor propDescriptor = BeanUtils.getPropertyDescriptor(bean.getClass(), (String)field.getName());
                    target = propDescriptor.getReadMethod().invoke(bean, new Object[0]);
                    if (target == null) continue;
                    propDescriptor.getWriteMethod().invoke(bean, this.resolver.convert(annotation, target, annotations, context));
                }
                catch (Exception e) {
                    log.error("\n ModelConvertHandler field convert error\n annotation: {}, class : {}, field : {}, value : {}, error : {} \n\n", new Object[]{annotations, bean.getClass().getName(), field.getName(), target, e.getMessage()});
                }
            }
        }
        return bean;
    }

    @Override
    public boolean isHandlePossible(Object obj, Annotation annotation) {
        return !BeanUtils.isSimpleProperty(obj.getClass());
    }
}

