/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.convert.handler;

import com.humuson.tms.convert.ConvertInfoResolver;
import com.humuson.tms.convert.handler.ConvertInfoHandleCheckable;
import com.humuson.tms.convert.handler.ConvertInfoHandler;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class MapConvertHandler
implements ConvertInfoHandleCheckable,
ConvertInfoHandler<Map, Annotation> {
    public static final String KEY_CONTEXT_PROPS = "props";
    public static final String KEY_CHECK_PROPERTY = "prop";
    @Autowired
    ConvertInfoResolver resolver;

    @Override
    public Object convert(Annotation annotation, Map map, Collection<Annotation> annotations, Map<String, Object> context) {
        String[] props = this.getPropFromContext(annotations, context);
        Object val = null;
        for (String prop : props) {
            val = map.get(prop);
            if (val == null) continue;
            map.put(prop, this.resolver.convert(annotation, val, annotations, context));
        }
        return map;
    }

    @Override
    public boolean isHandlePossible(Object obj, Annotation annotation) {
        return obj instanceof Map;
    }

    public String[] getPropFromContext(Collection<Annotation> annotations, Map<String, Object> context) {
        Object cachedProps = context.get(KEY_CONTEXT_PROPS);
        if (cachedProps == null) {
            Object p = null;
            String[] props = null;
            for (Annotation anno : annotations) {
                p = AnnotationUtils.getValue((Annotation)anno, (String)KEY_CHECK_PROPERTY);
                if (p == null || !(p instanceof String[])) continue;
                props = (String[])p;
                break;
            }
            if (props == null) {
                return null;
            }
            context.put(KEY_CONTEXT_PROPS, props);
            return props;
        }
        if (cachedProps instanceof String[]) {
            return (String[])cachedProps;
        }
        return null;
    }
}

