/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.config;

import com.humuson.tms.constrants.ChannelType;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

@Configuration
public class TmsConfig
implements ApplicationListener<ContextRefreshedEvent> {
    @Value(value="${user.field.encrypt.yn}")
    String encryptYn;
    @Value(value="${enable.chn}")
    private String enableChannel;
    @Value(value="${amc.api.enabled.yn:N}")
    private String amcApiEnabled;
    boolean pushEnabled = true;
    boolean emailEnabled = true;
    boolean smsEnabled = true;
    boolean kakaoEnabled = true;

    public boolean isMemberFieldEncrypted() {
        return "Y".equalsIgnoreCase(this.encryptYn);
    }

    public String getEncryptYN() {
        return this.isMemberFieldEncrypted() ? "Y" : "N";
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public void setPushEnabled(boolean pushEnabled) {
        this.pushEnabled = pushEnabled;
    }

    public boolean isEmailEnabled() {
        return this.emailEnabled;
    }

    public void setEmailEnabled(boolean emailEnabled) {
        this.emailEnabled = emailEnabled;
    }

    public boolean isSmsEnabled() {
        return this.smsEnabled;
    }

    public void setSmsEnabled(boolean smsEnabled) {
        this.smsEnabled = smsEnabled;
    }

    public boolean isKakaoEnabled() {
        return this.kakaoEnabled;
    }

    public void setKakaoEnabled(boolean kakaoEnabled) {
        this.kakaoEnabled = kakaoEnabled;
    }

    public boolean isAmcApiEnabled() {
        return "Y".equalsIgnoreCase(this.amcApiEnabled);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (StringUtils.isNotEmpty((String)this.enableChannel)) {
            this.emailEnabled = this.enableChannel.indexOf(ChannelType.EMAIL.getCode()) >= 0;
            this.pushEnabled = this.enableChannel.indexOf(ChannelType.PUSH.getCode()) >= 0;
            this.smsEnabled = this.enableChannel.indexOf(ChannelType.SMS.getCode()) >= 0;
            this.kakaoEnabled = this.enableChannel.indexOf(ChannelType.KAKAO.getCode()) >= 0;
        }
    }
}

