/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.view.xls;

import com.humuson.tms.common.util.MessageUtil;
import com.humuson.tms.model.vo.EntityMap;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.document.AbstractExcelView;

public class ExcelView
extends AbstractExcelView {
    private static final Logger log = LoggerFactory.getLogger(ExcelView.class);

    protected void buildExcelDocument(Map model, HSSFWorkbook workbook, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        List list = (List)model.get("list");
        EntityMap title = (EntityMap)model.get("title");
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)list.toString());
        }
        this.buildExcelSheet(workbook, list, title);
        Date now = new Date();
        String uri = request.getRequestURI();
        StringBuilder filename = new StringBuilder();
        filename.append(uri.replaceAll(".+/([\\w]+)/([\\w]+)/export.+", "$1_$2_")).append(format.format(now)).append(".xls");
        filename.insert(0, "attachment; filename=\"");
        filename.append("\"");
        response.setHeader("Content-Disposition", filename.toString());
    }

    private void buildExcelSheet(HSSFWorkbook workbook, List<EntityMap> list, EntityMap title) {
        HSSFSheet sheet = workbook.createSheet();
        HSSFCell cell = null;
        HSSFCellStyle cs = workbook.createCellStyle();
        cs.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"text"));
        int rowNum = 0;
        HSSFRow row = sheet.createRow(rowNum++);
        this.writeTitle((Row)row, (Cell)cell, (CellStyle)cs, title);
        if (list == null) {
            HSSFRow r = sheet.createRow(rowNum++);
            cell = r.createCell(0);
            cell.setCellStyle((CellStyle)cs);
            cell.setCellValue(MessageUtil.getMessage((String)"label.empty.list"));
        } else {
            for (EntityMap mapRow : list) {
                HSSFRow r = sheet.createRow(rowNum++);
                int i = 0;
                for (String key : title.keySet()) {
                    cell = r.createCell(i);
                    cell.setCellStyle((CellStyle)cs);
                    cell.setCellValue(String.valueOf(mapRow.get(key)));
                    if ("null".equals(cell.getStringCellValue())) {
                        cell.setCellValue("");
                    }
                    ++i;
                }
            }
        }
    }

    private void writeTitle(Row row, Cell cell, CellStyle cs, EntityMap title) {
        int i = 0;
        for (String key : title.keySet()) {
            cell = row.createCell(i);
            cell.setCellStyle(cs);
            cell.setCellValue(title.getString(key));
            ++i;
        }
    }
}

