/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.aop;

import com.humuson.tms.model.vo.TmsUser;
import com.humuson.tms.service.security.TmsUserDetailsService;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Aspect
public class RenewalUserDetailsAop {
    private static final Logger log = LoggerFactory.getLogger(RenewalUserDetailsAop.class);
    @Autowired
    TmsUserDetailsService tmsUserDetailsService;

    @After(value="@annotation(com.humuson.tms.common.aop.RenewalUserDetails)")
    public void targetMethod(JoinPoint joinPoint) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal() instanceof TmsUser) {
            TmsUser tmsUser = (TmsUser)authentication.getPrincipal();
            log.info("Renewal UserDetails. user id : {}", (Object)tmsUser.getUsername());
            UsernamePasswordAuthenticationToken newAuth = new UsernamePasswordAuthenticationToken((Object)this.tmsUserDetailsService.loadUserByUsername(tmsUser.getUsername()), (Object)tmsUser.getPassword(), tmsUser.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)newAuth);
        }
    }
}

