/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class DynamicDatabaseDao {
    private static final Logger log = LoggerFactory.getLogger(DynamicDatabaseDao.class);

    public String connectTest(String driver, String url, String id, String pwd) {
        String errorMsg = "";
        try {
            Class.forName(driver);
            Connection conn = DriverManager.getConnection(url, id, pwd);
            conn.close();
        }
        catch (ClassNotFoundException e) {
            log.error("driver class not found error", (Throwable)e);
            errorMsg = e.getMessage();
        }
        catch (SQLException e) {
            log.error("SQL error", (Throwable)e);
            errorMsg = e.getMessage();
        }
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkConnection(String driver, String url, String id, String pass) {
        Connection conn = null;
        try {
            Class.forName(driver);
            DriverManager.setLogWriter(new PrintWriter(System.err));
            log.info("Getting Connection");
            conn = DriverManager.getConnection(url, id, pass);
            for (SQLWarning warn = conn.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                log.info("SQLState: {}", (Object)warn.getSQLState());
                log.info("Message:  {}", (Object)warn.getMessage());
                log.info("Vendor:   {}", (Object)warn.getErrorCode());
            }
        }
        catch (Exception e) {
            log.error("Runtime Exception", (Throwable)e);
            String string = e.toString();
            return string;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return "";
    }

    public DataSource createDataSource(String driverName, String url, String username, String password) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(driverName);
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        return dataSource;
    }

    public List<Map<String, Object>> queryForList(String query, DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        return jdbcTemplate.queryForList(query);
    }

    public Map<String, Object> queryForMap(String query, DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        return jdbcTemplate.queryForMap(query);
    }
}

