/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.command;

import com.humuson.tms.model.vo.PageInfoVo;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.data.domain.PageRequest;

public class PageParamCommand {
    private int pageNumber;
    private int pageSize;

    public PageRequest pageRequestInit() {
        return this.pageRequestInit(PageInfoVo.DEFAULT_PAGE_NUMBER, PageInfoVo.DEFAULT_PAGE_SIZE);
    }

    public PageRequest pageRequestInit(int defaultPageNumber, int defaultPageSize) {
        if (this.pageNumber <= 0) {
            this.pageNumber = defaultPageNumber;
        }
        if (this.pageSize <= 0) {
            this.pageSize = defaultPageSize;
        }
        return new PageRequest(this.pageNumber == 0 ? 0 : this.pageNumber - 1, this.pageSize);
    }

    public String toString() {
        ToStringStyle style = ToStringStyle.MULTI_LINE_STYLE;
        ReflectionToStringBuilder tsb = new ReflectionToStringBuilder((Object)this, style);
        return tsb.toString();
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public PageParamCommand setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public PageParamCommand setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageParamCommand)) {
            return false;
        }
        PageParamCommand other = (PageParamCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNumber() != other.getPageNumber()) {
            return false;
        }
        return this.getPageSize() == other.getPageSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageParamCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNumber();
        result = result * 59 + this.getPageSize();
        return result;
    }
}

