/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.api.controller;

import com.humuson.tms.exception.ApiException;
import com.humuson.tms.model.BaseApiDefiner;
import com.humuson.tms.model.BaseApiInfo;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.MultiValueMap;

public abstract class BaseApiController
implements BaseApiDefiner {
    private static final int LOGGER_PARAM_SIZE = 6;
    private static final int LOGGER_PARAM_FIRST_INDEX = 0;
    @Autowired
    private DataSourceTransactionManager transactionManager;
    @Inject
    public MessageSource messagesource;
    private String lang = "ko";
    public Locale DEFAULT_LOCALE = Locale.KOREAN;

    public Locale getLocale() {
        String[] key = new String[]{"en", "fr", "de", "it", "ja", "ko", "zh", "zh_CN", "tw"};
        Locale[] locales = new Locale[]{Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN, Locale.ITALIAN, Locale.JAPANESE, Locale.KOREAN, Locale.CHINESE, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE};
        Locale locale = Locale.KOREAN;
        for (int i = 0; i < key.length; ++i) {
            if (!key[i].equals(this.lang)) continue;
            locale = locales[i];
            break;
        }
        return locale;
    }

    public void initData(BaseApiInfo baseApiInfo, Map<String, String> params) throws Exception {
        this.setRequiredValue(baseApiInfo, params);
        this.setParams(baseApiInfo, params);
    }

    public void setRequiredValue(BaseApiInfo baseApiInfo, Map<String, String> params) throws Exception {
    }

    public void setParams(BaseApiInfo baseApiInfo, Map<String, String> params) throws Exception {
        int maxResults = 2;
        int pageToken = 1;
        maxResults = params.containsKey("maxResults") ? Integer.parseInt(params.get("maxResults")) : 2;
        pageToken = params.containsKey("pageToken") ? Integer.parseInt(params.get("pageToken")) : 1;
        baseApiInfo.setMaxResults(maxResults);
        baseApiInfo.setPageToken(pageToken);
    }

    public String getResultBody(String code, String msg, String result, String pageInfo) {
        JSONObject obj = new JSONObject();
        JSONObject resultObj = new JSONObject();
        resultObj.put((Object)"code", (Object)code);
        resultObj.put((Object)"msg", (Object)msg);
        obj.put((Object)"result", (Object)resultObj);
        obj.put((Object)"data", (Object)result);
        obj.put((Object)"pageInfo", (Object)pageInfo);
        return obj.toString();
    }

    public void prnLog(Object ... args) {
        Logger logger = null;
        Object[] useArgs = new Object[6];
        for (int index = 0; index < args.length; ++index) {
            if (args[index] == null) continue;
            useArgs[index] = args[index];
            if (index != 0) continue;
            logger = (Logger)args[0];
        }
        if (logger != null) {
            logger.info(String.format("[%s.%s] [resultCode:%s, resultMsg:%s] [param:%s]", useArgs[1].getClass().getSimpleName(), useArgs[2], useArgs[3], useArgs[4], useArgs[5]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ResponseEntity<String> getResponseEntity(BaseApiInfo baseApiInfo, Map<String, String> params, int option, Logger logger) {
        String code = "000";
        String msg = "SUCCESS";
        String result = "";
        String pageInfo = "";
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("getResponseEntity");
        def.setPropagationBehavior(0);
        TransactionStatus transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            this.prnLog(logger, this, baseApiInfo.getExecutionMsg() + " START..", "", "", params);
            this.initData(baseApiInfo, params);
            result = this.process(baseApiInfo, params, option);
            pageInfo = this.pagingProcess(baseApiInfo, params, option);
            this.transactionManager.commit(transactionStatus);
        }
        catch (ApiException apie) {
            code = apie.getCode();
            msg = apie.getMessage();
            this.transactionManager.rollback(transactionStatus);
            this.prnLog(logger, this, baseApiInfo.getExecutionMsg() + " FINISH..", code, msg, params);
        }
        catch (Exception e) {
            code = "110";
            msg = e.getMessage();
            e.printStackTrace();
            this.transactionManager.rollback(transactionStatus);
            {
                catch (Throwable throwable) {
                    this.prnLog(logger, this, baseApiInfo.getExecutionMsg() + " FINISH..", code, msg, params);
                    throw throwable;
                }
            }
            this.prnLog(logger, this, baseApiInfo.getExecutionMsg() + " FINISH..", code, msg, params);
        }
        this.prnLog(logger, this, baseApiInfo.getExecutionMsg() + " FINISH..", code, msg, params);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Access-Control-Allow-Origin", "*");
        return new ResponseEntity((Object)this.getResultBody(code, msg, result, pageInfo), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    public abstract String process(BaseApiInfo var1, Map<String, String> var2, int var3) throws Exception;

    public abstract String pagingProcess(BaseApiInfo var1, Map<String, String> var2, int var3) throws Exception;
}

