/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.api.controller;

import com.google.gson.Gson;
import com.humuson.tms.api.controller.BaseApiController;
import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.model.BaseApiInfo;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.vo.AppApiInfo;
import com.humuson.tms.model.vo.ChannelApiInfo;
import com.humuson.tms.model.vo.SiteApiInfo;
import com.humuson.tms.service.api.AppApiService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AppApiController
extends BaseApiController {
    public static final Locale DEFAULT_LOCALE = Locale.KOREAN;
    private static final Logger logger = LoggerFactory.getLogger(AppApiController.class);
    public static final int OPTION_SELECT_APP_INFO = 1;
    public static final int OPTION_SELECT_CHANNEL_INFO = 2;
    public static final int OPTION_SELECT_SITE_INFO = 3;
    @Value(value="${db.enc.key}")
    private String dbEncKey;
    int endIndex = 100;
    int pageIndex = 1;
    String url = "";
    @Autowired
    private AppApiService appApiService;
    @Autowired
    private Gson gson;

    @RequestMapping(value={"/api/apps"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectAll(ModelMap model, @RequestParam Map<String, String> params, HttpServletRequest request) {
        this.url = request.getRequestURL().toString();
        BaseApiInfo baseApiInfo = new BaseApiInfo("", "selectAll()");
        return this.getResponseEntity(baseApiInfo, params, 1, logger);
    }

    @RequestMapping(value={"/api/apps/user/{registerId}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectByUser(@PathVariable(value="registerId") String registerId, ModelMap model, @RequestParam Map<String, String> params, HttpServletRequest request) {
        this.url = request.getRequestURL().toString();
        BaseApiInfo baseApiInfo = new BaseApiInfo(registerId, "selectAppGrpsByUser()", 0);
        return this.getResponseEntity(baseApiInfo, params, 1, logger);
    }

    @RequestMapping(value={"/api/apps/channel/{channelKey}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectByParam(@PathVariable(value="channelKey") String channelKey, ModelMap model, @RequestParam Map<String, String> params, HttpServletRequest request) {
        this.url = request.getRequestURL().toString();
        BaseApiInfo baseApiInfo = new BaseApiInfo(channelKey, "selectByParam()");
        return this.getResponseEntity(baseApiInfo, params, 1, logger);
    }

    @RequestMapping(value={"/api/apps/site/{siteKey}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectBySiteParam(@PathVariable(value="siteKey") String siteKey, ModelMap model, @RequestParam Map<String, String> params, HttpServletRequest request) {
        this.url = request.getRequestURL().toString();
        BaseApiInfo baseApiInfo = new BaseApiInfo(siteKey);
        return this.getResponseEntity(baseApiInfo, params, 1, logger);
    }

    @RequestMapping(value={"/api/channels"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectAllChannels(ModelMap model, @RequestParam Map<String, String> params, HttpServletRequest request) {
        this.url = request.getRequestURL().toString();
        BaseApiInfo baseApiInfo = new BaseApiInfo("", "selectAllAppGrps()", 0);
        return this.getResponseEntity(baseApiInfo, params, 2, logger);
    }

    @RequestMapping(value={"/api/channels/user/{registerId}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectChannelsByUser(@PathVariable(value="registerId") String registerId, ModelMap model, @RequestParam Map<String, String> params, HttpServletRequest request) {
        this.url = request.getRequestURL().toString();
        BaseApiInfo baseApiInfo = new BaseApiInfo(registerId, "selectAppGrpsByUser()", 0);
        return this.getResponseEntity(baseApiInfo, params, 2, logger);
    }

    @RequestMapping(value={"/api/channels/channel/{channelKey}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectChannelsByChannel(@PathVariable(value="channelKey") String channelKey, ModelMap model, @RequestParam Map<String, String> params, HttpServletRequest request) {
        this.url = request.getRequestURL().toString();
        BaseApiInfo baseApiInfo = new BaseApiInfo(channelKey, "selectByChannel()");
        return this.getResponseEntity(baseApiInfo, params, 2, logger);
    }

    @RequestMapping(value={"/api/channels/site/{siteKey}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectChannelsBySite(@PathVariable(value="siteKey") String siteKey, ModelMap model, @RequestParam Map<String, String> params, HttpServletRequest request) {
        this.url = request.getRequestURL().toString();
        BaseApiInfo baseApiInfo = new BaseApiInfo(siteKey);
        return this.getResponseEntity(baseApiInfo, params, 2, logger);
    }

    @RequestMapping(value={"/api/sites"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectAllSites(ModelMap model, @RequestParam Map<String, String> params, HttpServletRequest request) {
        this.url = request.getRequestURL().toString();
        BaseApiInfo baseApiInfo = new BaseApiInfo("", "selectAllsites()", 0);
        return this.getResponseEntity(baseApiInfo, params, 3, logger);
    }

    @RequestMapping(value={"/api/sites/user/{registerId}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectSitesByUser(@PathVariable(value="registerId") String registerId, ModelMap model, @RequestParam Map<String, String> params, HttpServletRequest request) {
        this.url = request.getRequestURL().toString();
        BaseApiInfo baseApiInfo = new BaseApiInfo(registerId, "selectAppGrpsByUser()", 0);
        return this.getResponseEntity(baseApiInfo, params, 3, logger);
    }

    @RequestMapping(value={"/api/sites/site/{siteKey}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectSitesBySite(@PathVariable(value="siteKey") String siteKey, ModelMap model, @RequestParam Map<String, String> params, HttpServletRequest request) {
        this.url = request.getRequestURL().toString();
        BaseApiInfo baseApiInfo = new BaseApiInfo(siteKey);
        return this.getResponseEntity(baseApiInfo, params, 3, logger);
    }

    @Override
    public String process(BaseApiInfo baseApiInfo, Map<String, String> params, int option) throws Exception {
        String result = "";
        if (!StringUtils.isEmpty((CharSequence)params.get("pagingSize"))) {
            this.endIndex = Integer.parseInt(params.get("pagingSize"));
        }
        if (!StringUtils.isEmpty((CharSequence)params.get("page"))) {
            this.pageIndex = Integer.parseInt(params.get("page"));
        }
        switch (option) {
            case 1: {
                List<AppApiInfo> appList = this.appApiService.selectAppInfo(new AppApiInfo(baseApiInfo.getChannelKey(), baseApiInfo.getSiteKey(), baseApiInfo.getRegisterId()), new PageInfo(this.pageIndex, this.endIndex));
                for (AppApiInfo appInfo : appList) {
                    appInfo.setEnc2Pa(HumusonDecryptor.decrypt((String)appInfo.getEnc2Pa(), (String)this.dbEncKey));
                }
                result = this.gson.toJson(appList, ArrayList.class);
                break;
            }
            case 2: {
                List<ChannelApiInfo> channelList = this.appApiService.selectChannelInfo(new ChannelApiInfo(baseApiInfo.getRegisterId(), baseApiInfo.getSiteKey(), baseApiInfo.getChannelKey()), new PageInfo(this.pageIndex, this.endIndex));
                result = this.gson.toJson(channelList, ArrayList.class);
                break;
            }
            case 3: {
                List<SiteApiInfo> siteList = this.appApiService.selectSiteInfo(new SiteApiInfo(baseApiInfo.getRegisterId(), baseApiInfo.getSiteKey()), new PageInfo(this.pageIndex, this.endIndex));
                result = this.gson.toJson(siteList, ArrayList.class);
                break;
            }
        }
        return result;
    }

    @Override
    public String pagingProcess(BaseApiInfo baseApiInfo, Map<String, String> params, int option) throws Exception {
        String result = "";
        int next = 0;
        int prev = 0;
        int totalPage = 0;
        if (!StringUtils.isEmpty((CharSequence)params.get("pagingSize"))) {
            this.endIndex = Integer.parseInt(params.get("pagingSize"));
        }
        if (!StringUtils.isEmpty((CharSequence)params.get("page"))) {
            this.pageIndex = Integer.parseInt(params.get("page"));
        }
        next = this.pageIndex + 1;
        prev = this.pageIndex - 1;
        JSONObject pagingObj = new JSONObject();
        switch (option) {
            case 1: {
                List<AppApiInfo> totalList = this.appApiService.selectAppInfo(new AppApiInfo(baseApiInfo.getChannelKey(), baseApiInfo.getSiteKey(), baseApiInfo.getRegisterId()), new PageInfo(0, 0));
                int totalRow = totalList.size();
                totalPage = totalRow % this.endIndex == 0 ? totalRow / this.endIndex : totalRow / this.endIndex + 1;
                pagingObj.put((Object)"pagingSize", (Object)this.endIndex);
                pagingObj.put((Object)"totalRow", (Object)totalRow);
                pagingObj.put((Object)"totalPage", (Object)totalPage);
                pagingObj.put((Object)"curPage", (Object)this.pageIndex);
                pagingObj.put((Object)"nextURL", (Object)(this.url + "?page=" + next + "&pagingSize=" + this.endIndex));
                if (this.pageIndex != 1) {
                    pagingObj.put((Object)"prevURL", (Object)(this.url + "?page=" + prev + "&pagingSize=" + this.endIndex));
                } else {
                    pagingObj.put((Object)"prevURL", (Object)"");
                }
                result = pagingObj.toString();
                break;
            }
            case 2: {
                List<ChannelApiInfo> channelList = this.appApiService.selectChannelInfo(new ChannelApiInfo(baseApiInfo.getRegisterId(), baseApiInfo.getSiteKey(), baseApiInfo.getChannelKey()), new PageInfo(0, 0));
                int totalRow = channelList.size();
                totalPage = totalRow % this.endIndex == 0 ? totalRow / this.endIndex : totalRow / this.endIndex + 1;
                pagingObj.put((Object)"pagingSize", (Object)this.endIndex);
                pagingObj.put((Object)"totalRow", (Object)totalRow);
                pagingObj.put((Object)"totalPage", (Object)totalPage);
                pagingObj.put((Object)"curPage", (Object)this.pageIndex);
                pagingObj.put((Object)"nextURL", (Object)(this.url + "?page=" + next + "&pagingSize=" + this.endIndex));
                if (this.pageIndex != 1) {
                    pagingObj.put((Object)"prevURL", (Object)(this.url + "/?page=" + prev + "&pagingSize=" + this.endIndex));
                } else {
                    pagingObj.put((Object)"prevURL", (Object)"");
                }
                result = pagingObj.toString();
                break;
            }
            case 3: {
                List<SiteApiInfo> siteList = this.appApiService.selectSiteInfo(new SiteApiInfo(baseApiInfo.getRegisterId(), baseApiInfo.getSiteKey()), new PageInfo(0, 0));
                int totalRow = siteList.size();
                totalPage = totalRow % this.endIndex == 0 ? totalRow / this.endIndex : totalRow / this.endIndex + 1;
                pagingObj.put((Object)"pagingSize", (Object)this.endIndex);
                pagingObj.put((Object)"totalRow", (Object)totalRow);
                pagingObj.put((Object)"totalPage", (Object)totalPage);
                pagingObj.put((Object)"curPage", (Object)this.pageIndex);
                pagingObj.put((Object)"nextURL", (Object)(this.url + "?page=" + next + "&pagingSize=" + this.endIndex));
                if (this.pageIndex != 1) {
                    pagingObj.put((Object)"prevURL", (Object)(this.url + "?page=" + prev + "&pagingSize=" + this.endIndex));
                } else {
                    pagingObj.put((Object)"prevURL", (Object)"");
                }
                result = pagingObj.toString();
                break;
            }
        }
        return result;
    }
}

