/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.api.component;

import com.humuson.tms.common.constant.ApiStatus;
import com.humuson.tms.exception.ApiResponseDataProvider;
import com.humuson.tms.model.api.ApiResponseForm;
import com.humuson.tms.model.api.ApiStatusForm;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.LocaleResolver;

@Component
public class ApiResponseFormConverter {
    public static final String MESSAGE_NULL_VALUE = "";
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LocaleResolver localeResolver;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setLocaleResolver(LocaleResolver resolver) {
        this.localeResolver = resolver;
    }

    public String getMessage(String messageCode, HttpServletRequest request) {
        if (messageCode == null || MESSAGE_NULL_VALUE.equals(messageCode)) {
            return MESSAGE_NULL_VALUE;
        }
        Locale locale = this.localeResolver.resolveLocale(request);
        return this.messageSource.getMessage(messageCode, null, messageCode, locale);
    }

    public ApiResponseForm makeApiResponseForm(HttpServletRequest request, ApiResponseDataProvider e) {
        ApiStatus apiStatus = e.getApiStatus();
        String message = this.getMessage(e.getMessage(), request);
        return new ApiResponseForm(new ApiStatusForm(apiStatus.getStatusCode(), message), e.getData());
    }

    public ApiResponseForm makeApiResponseForm(ApiStatus apiStatus, String message, Object data) {
        return new ApiResponseForm(new ApiStatusForm(apiStatus.getStatusCode(), message), data);
    }

    public ApiResponseForm makeApiResponseForm(HttpServletRequest request, ApiStatus apiStatus, String message, Object data) {
        String msg = this.getMessage(message, request);
        return new ApiResponseForm(new ApiStatusForm(apiStatus.getStatusCode(), msg), data);
    }
}

