/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.util;

import com.humuson.tms.common.lang.Locale;
import com.humuson.tms.common.util.NumberUtils;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final Logger log = LoggerFactory.getLogger(StringUtils.class);
    private static DecimalFormat numberFormatter = new DecimalFormat();

    public static boolean hasText(String str) {
        return org.springframework.util.StringUtils.hasText((CharSequence)str);
    }

    public static String validString(String strSource) {
        if (strSource == null) {
            return "";
        }
        return strSource.trim();
    }

    public static String validString(Object obj) {
        if (obj == null) {
            log.info("validString obj is null");
            return "";
        }
        if (obj instanceof String) {
            return ((String)obj).trim();
        }
        return obj.toString();
    }

    public static String getSendListTable(String post_id) {
        if (post_id == null || post_id.length() < 6) {
            return "";
        }
        return "TMS_CAMP_SEND_LIST_" + post_id.substring(4, 6);
    }

    public static final boolean isNull(String src) {
        return src == null || src.trim().length() < 1;
    }

    public static String queryCheck(String source) {
        if (source == null) {
            return source;
        }
        source = StringUtils.replace(source, "'", "''");
        source = StringUtils.replace(source, "\"", "");
        source = StringUtils.replace(source, ";", "");
        source = StringUtils.replace(source, "\\", "");
        source = StringUtils.replace(source, "--", "");
        source = StringUtils.replace(source, "+", "");
        return source;
    }

    public static String nvl(String src) {
        return StringUtils.nvl(src, "");
    }

    public static String nvl(String src, String tgt) {
        String res = tgt;
        if (tgt == null) {
            res = "";
        }
        if (src == null) {
            return res;
        }
        if (src.equals("")) {
            return res;
        }
        return src;
    }

    public static String nvl(Object obj) {
        return StringUtils.nvl(obj, "");
    }

    public static String nvl(Object obj, String def) {
        if (obj == null) {
            return def;
        }
        return obj.toString();
    }

    public static String rpad(String str, int len, char pad) {
        String result = str;
        int templen = len - result.getBytes().length;
        for (int i = 0; i < templen; ++i) {
            result = result + pad;
        }
        return result;
    }

    public static String lpad(String str, int len, char pad) {
        String result = str;
        int templen = len - result.getBytes().length;
        for (int i = 0; i < templen; ++i) {
            result = pad + result;
        }
        return result;
    }

    public static String makePostType(String postno) {
        if (postno == null || postno.length() == 0) {
            return "";
        }
        if (postno.length() != 6) {
            return postno;
        }
        String postno1 = postno.substring(0, 3);
        String postno2 = postno.substring(3, 6);
        return postno1 + "-" + postno2;
    }

    public static String makeTelType(String tel) {
        if (tel == null || tel.length() == 0) {
            return "";
        }
        String DELEMETER = "-";
        StringBuffer sb = new StringBuffer();
        String tnum = "";
        if (tel.startsWith("02")) {
            sb.append("02").append(DELEMETER);
            tnum = tel.substring(2);
        } else {
            sb.append(tel.substring(0, 3)).append(DELEMETER);
            tnum = tel.substring(3);
        }
        if (tnum.length() == 7) {
            sb.append(tnum.substring(0, 3)).append(DELEMETER).append(tnum.substring(3));
        } else if (tnum.length() == 8) {
            sb.append(tnum.substring(0, 4)).append(DELEMETER).append(tnum.substring(4));
        } else {
            return tel;
        }
        return sb.toString();
    }

    public static String makeJuminType(String jumin) {
        if (jumin == null || jumin.length() == 0) {
            return "";
        }
        if (jumin.length() != 13) {
            return jumin;
        }
        String postno1 = jumin.substring(0, 6);
        String postno2 = jumin.substring(6);
        return postno1 + "-" + postno2;
    }

    public static String getPostCode1(String postcode) {
        if (postcode == null || postcode.length() == 0) {
            return "";
        }
        if (postcode.length() == 6) {
            return postcode.substring(0, 3);
        }
        return postcode;
    }

    public static String getPostCode2(String postcode) {
        if (postcode == null || postcode.length() == 0) {
            return "";
        }
        if (postcode.length() == 6) {
            return postcode.substring(3);
        }
        return postcode;
    }

    public static String getTelNum1(String tel) {
        if (tel == null || tel.length() <= 3) {
            return "";
        }
        if (tel.startsWith("02")) {
            return "02";
        }
        return tel.substring(0, 3);
    }

    public static String getTelNum2(String tel) {
        if (tel == null || tel.length() == 0) {
            return "";
        }
        if (tel.startsWith("02")) {
            if (tel.length() - 2 == 7) {
                return tel.substring(2, 5);
            }
            if (tel.length() - 2 == 8) {
                return tel.substring(2, 6);
            }
            return tel;
        }
        if (tel.length() - 3 == 7) {
            return tel.substring(3, 6);
        }
        if (tel.length() - 3 == 8) {
            return tel.substring(3, 7);
        }
        return tel;
    }

    public static String getTelNum3(String tel) {
        if (tel == null || tel.length() == 0) {
            return "";
        }
        if (tel.startsWith("02")) {
            if (tel.length() - 2 == 7) {
                return tel.substring(5);
            }
            if (tel.length() - 2 == 8) {
                return tel.substring(6);
            }
            return tel;
        }
        if (tel.length() - 3 == 7) {
            return tel.substring(6);
        }
        if (tel.length() - 3 == 8) {
            return tel.substring(7);
        }
        return tel;
    }

    public static String getGender(String gender) {
        if (gender == null || gender.length() == 0) {
            return "";
        }
        String gen = gender.toUpperCase();
        if (gen.equals("F") || gen.equals("FEMAIL") || gen.equals("W") || gender.equals("WOMAN")) {
            return "\uc5ec\uc790";
        }
        if (gen.equals("M") || gen.equals("MAIL") || gender.equals("MAN")) {
            return "\ub0a8\uc790";
        }
        return gender;
    }

    public String encodeSpace(String str) {
        StringTokenizer st = new StringTokenizer(str);
        String spString = "";
        while (st.hasMoreTokens()) {
            spString = spString + st.nextToken() + "_";
        }
        return spString;
    }

    public String decodeSpace(String str) {
        StringTokenizer st = new StringTokenizer(str, "_");
        String returnStr = "";
        while (st.hasMoreTokens()) {
            returnStr = returnStr + st.nextToken() + " ";
        }
        return returnStr;
    }

    public static String remove(String str, String tok) {
        return StringUtils.replaceAll(str, tok, "");
    }

    public static String replace(String str, int off, int len, String replace) {
        StringBuffer buff = new StringBuffer(str);
        buff.replace(off, off + len, replace);
        return buff.toString();
    }

    public static String replace(String str1, int off, String str2, String replace) {
        if ((off = str1.indexOf(str2, off)) == -1) {
            return str1;
        }
        StringBuffer buff = new StringBuffer(str1);
        buff.replace(off, off + str2.length(), replace);
        return buff.toString();
    }

    public static String replaceAll(String str1, int off, String str2, String replace) {
        if (str1 == null || str2 == null || replace == null) {
            return str1;
        }
        off = str1.indexOf(str2, off);
        StringBuffer buff = new StringBuffer(str1);
        while (off != -1) {
            buff.replace(off, off + str2.length(), replace);
            str1 = buff.toString();
            if (off + str2.length() < str1.length()) {
                off = str1.indexOf(str2, off + replace.length());
                continue;
            }
            off = -1;
        }
        return str1;
    }

    public static String replaceAll(String str1, String str2, String replace) {
        return StringUtils.replaceAll(str1, 0, str2, replace);
    }

    public static String getShortString(String p_str, int p_len) {
        boolean chkFlag = false;
        String strName = p_str.trim();
        byte[] arName = strName.getBytes();
        if (arName.length > p_len) {
            for (int idx = 0; idx < p_len; ++idx) {
                chkFlag = arName[idx] < 0 ? !chkFlag : false;
            }
            strName = chkFlag ? new String(arName, 0, p_len + 1) : new String(arName, 0, p_len);
        } else {
            strName = new String(arName, 0, arName.length);
        }
        return strName;
    }

    public static String getShortStatement(String str, int maxNum) {
        return str.length() > maxNum ? StringUtils.getShortString(str, maxNum) + "..." : str;
    }

    public static String getRawDigit(String str) {
        char[] c = str.toCharArray();
        StringBuffer buff = new StringBuffer();
        try {
            for (int i = 0; i < c.length; ++i) {
                if (!Character.isDigit(c[i])) continue;
                buff.append(c[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buff.toString();
    }

    public static String changeEmptyStringToNULL(String inStr) {
        if (inStr == null) {
            return null;
        }
        if (inStr.equals("")) {
            return null;
        }
        return inStr;
    }

    public static String changeEntityReference(String text) {
        String result = text;
        result = StringUtils.replaceAll(result, "&", "&amp;");
        result = StringUtils.replaceAll(result, "'", "&apos;");
        result = StringUtils.replaceAll(result, "\"", "&quot;");
        result = StringUtils.replaceAll(result, "<", "&lt;");
        result = StringUtils.replaceAll(result, ">", "&gt;");
        return result;
    }

    public static String changeNormalText(String text) {
        String result = text;
        result = StringUtils.replaceAll(result, "&gt;", ">");
        result = StringUtils.replaceAll(result, "&lt;", "<");
        result = StringUtils.replaceAll(result, "&quot;", "\"");
        result = StringUtils.replaceAll(result, "&apos;", "'");
        result = StringUtils.replaceAll(result, "&amp;", "&");
        return result;
    }

    public static String getRandomString(int minValue, int maxValue, int fixLength) {
        double value = NumberUtils.getRandom(minValue, maxValue);
        String str = Double.toString(value);
        int index = str.indexOf(".");
        str = str.substring(0, index);
        if (fixLength == -1) {
            return str;
        }
        for (index = str.length(); index < fixLength; ++index) {
            str = "0" + str;
        }
        return str;
    }

    public static String[] split(String source, char s) {
        int i;
        Vector<String> v = new Vector<String>();
        int cnt = 0;
        int last = 0;
        boolean quotationOpen = false;
        boolean quotationClose = false;
        if (source == null || source.equals("")) {
            return null;
        }
        char[] cArray = source.toCharArray();
        for (i = 0; i < cArray.length; ++i) {
            ++cnt;
            if (cArray[i] == '\"') {
                if (!quotationOpen) {
                    ++last;
                    --cnt;
                    quotationOpen = true;
                    quotationClose = false;
                } else {
                    quotationOpen = false;
                    quotationClose = true;
                }
            }
            if ((cArray[i] != s || quotationOpen) && !quotationClose) continue;
            String tmp = new String(cArray, last, cnt - 1);
            v.addElement(tmp);
            cnt = 0;
            last = i + 1;
            quotationClose = false;
        }
        if (last < cArray.length) {
            v.addElement(source.substring(last));
        }
        if (source.charAt(source.length() - 1) == s) {
            v.addElement("");
        }
        String[] result = new String[v.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = (String)v.elementAt(i);
        }
        return result;
    }

    public static boolean checkEnumString(String[] list, String val) {
        if (val == null) {
            return false;
        }
        for (String s : list) {
            if (s == null || !s.equals(val)) continue;
            return true;
        }
        return false;
    }

    public static String encode(String src) {
        if (StringUtils.nvl(src).equals("")) {
            return "";
        }
        return new String(Base64.encodeBase64((byte[])Base64.encodeBase64((byte[])Base64.encodeBase64((byte[])src.getBytes()))));
    }

    public static String decode(String src) {
        if (StringUtils.nvl(src).equals("")) {
            return "";
        }
        return new String(Base64.decodeBase64((byte[])Base64.decodeBase64((byte[])Base64.decodeBase64((String)src))));
    }

    public static String getRate(String s, String s1) {
        int i = 0;
        int j = 0;
        if (s == null || s1 == null) {
            return "0";
        }
        try {
            i = Integer.parseInt(s);
            j = Integer.parseInt(s1);
        }
        catch (NumberFormatException nfe) {
            return "0";
        }
        return StringUtils.getRate(i, j);
    }

    public static String replaceAllData(String strValue, String strOld, String strNew) {
        if (strValue == null || strValue.length() == 0) {
            return strValue;
        }
        StringBuffer stringBuffer = new StringBuffer(strValue);
        int iOldSize = strOld.length();
        int iNewSize = strNew.length();
        int iBegin = 0;
        int iIndex = stringBuffer.indexOf(strOld, iBegin);
        while (iIndex >= 0) {
            stringBuffer.delete(iIndex, iIndex + iOldSize);
            stringBuffer.insert(iIndex, strNew);
            iBegin = iIndex + iNewSize;
            if (iBegin < stringBuffer.length()) {
                iIndex = stringBuffer.indexOf(strOld, iBegin);
                continue;
            }
            iIndex = -1;
        }
        return stringBuffer.toString();
    }

    public static String replaceAllSection(String strValue, String sOld, String eOld, String strNew) {
        if (strValue == null || strValue.length() == 0) {
            return strValue;
        }
        String temp = strValue;
        int so = 0;
        int eo = 0;
        String subStr = "";
        while (so > -1 || eo > -1) {
            so = temp.indexOf(sOld);
            eo = temp.indexOf(eOld, so);
            if (so <= -1 || eo <= -1) continue;
            subStr = temp.substring(so, eo + 1);
            temp = temp.replace(subStr, strNew);
        }
        return temp;
    }

    public static String replaceHTMLTag(String htmlString) {
        if (StringUtils.isEmpty((CharSequence)htmlString)) {
            return "";
        }
        String noHTMLString = htmlString.replaceAll(";", "\uff1b");
        noHTMLString = noHTMLString.replaceAll("%3B", "\uff1b");
        noHTMLString = noHTMLString.replaceAll("%27", "&#39;");
        noHTMLString = noHTMLString.replaceAll("<", "&lt;");
        noHTMLString = noHTMLString.replaceAll(">", "&gt;");
        noHTMLString = noHTMLString.replaceAll("\\(", "&#40;");
        noHTMLString = noHTMLString.replaceAll("\\)", "&#41;");
        noHTMLString = noHTMLString.replaceAll("\r\n", "<br/>");
        noHTMLString = noHTMLString.replaceAll("\r", "<br/>");
        noHTMLString = noHTMLString.replaceAll("\n", "<br/>");
        noHTMLString = noHTMLString.replaceAll("'", "&#39;");
        noHTMLString = noHTMLString.replaceAll("\"", "&quot;");
        return noHTMLString;
    }

    public static String replacedStringToHtmlTag(String replatedString) {
        if (StringUtils.isEmpty((CharSequence)replatedString)) {
            return "";
        }
        String htmlString = replatedString.replaceAll("\uff1b", ";");
        htmlString = htmlString.replaceAll("&lt;", "<");
        htmlString = htmlString.replaceAll("&gt;", ">");
        htmlString = htmlString.replaceAll("&#40;", "(");
        htmlString = htmlString.replaceAll("&#41;", ")");
        htmlString = htmlString.replaceAll("&#39;", "'");
        htmlString = htmlString.replaceAll("<br/>", "\r\n");
        htmlString = htmlString.replaceAll("&#39;", "'");
        htmlString = htmlString.replaceAll("&quot;", "\"");
        return htmlString;
    }

    public static final String getDomain(String str) {
        if (str == null) {
            return "";
        }
        int index = str.indexOf(64);
        if (index < 0) {
            return "";
        }
        return str.substring(index + 1);
    }

    public static final String getTeleCom(String str) {
        if (str == null || str.length() < 10) {
            return "";
        }
        return str.substring(0, 3);
    }

    public static final boolean isEmailError(String inemail) {
        if (inemail == null) {
            return false;
        }
        String email = inemail.trim();
        if (email.indexOf(64) < 0) {
            return true;
        }
        return !StringUtils.isValidHost(StringUtils.getDomain(email));
    }

    public static final boolean isSmsError(String inSms) {
        if (inSms == null) {
            return false;
        }
        String SMS = inSms.trim();
        return !Pattern.matches("^(01[016789]{1}|02|0[3-9]{1}[0-9]{1,2})-?[0-9]{3,4}-?[0-9]{4}$", SMS);
    }

    public static final boolean isValidHost(String host) {
        if (host.indexOf("@") > 0 || host.indexOf(".") < 0 || host.indexOf(" ") > 0 || host.startsWith(".") || host.endsWith(".") || host.indexOf("..") > 0 || host.startsWith("-")) {
            return false;
        }
        for (int i = 0; i < host.length(); ++i) {
            char ch = host.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '-' || ch == '.' || ch == '_') continue;
            return false;
        }
        return true;
    }

    public static String convertMappingString(String input, String mappingSymbol, String mapData) {
        return input.replace(mappingSymbol, mapData);
    }

    public static String substring(String input, int idx, int length) {
        if (input.getBytes().length <= idx) {
            return "";
        }
        if (input.getBytes().length <= length) {
            return input;
        }
        int totallen = 0;
        int i = idx;
        for (i = idx; i < input.length() && length >= (totallen += input.substring(i, i + 1).getBytes().length); ++i) {
        }
        return input.substring(idx, i);
    }

    public static String substring(String input, int length) {
        return StringUtils.substring(input, 0, length);
    }

    public static String moneyForm(String number) {
        if (number == null || number.trim().length() == 0) {
            return " ";
        }
        return StringUtils.toFormatedNumber(number, "#,##0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String toFormatedNumber(String number, String pattern) {
        if (number == null) {
            return " ";
        }
        double src = 0.0;
        try {
            src = Double.parseDouble(number);
        }
        catch (Exception e) {
            return number;
        }
        String returnValue = null;
        DecimalFormat decimalFormat = numberFormatter;
        synchronized (decimalFormat) {
            try {
                numberFormatter.applyPattern(pattern);
                returnValue = numberFormatter.format(src);
            }
            catch (Exception e) {
                return number;
            }
        }
        return returnValue == null ? " " : returnValue;
    }

    public static String trimNull(String str) {
        return str == null ? null : str.trim();
    }

    public static String getRate(float i, float j) {
        float f = 0.0f;
        if (j == 0.0f) {
            return "0.00000";
        }
        f = i / j * 100.0f;
        String ret = String.valueOf(f);
        int idx = ret.indexOf(".");
        if (idx != -1) {
            if (ret.length() - idx >= 3) {
                ret = ret.substring(0, idx + 3);
            }
        } else {
            ret = ret + ".00";
        }
        return ret;
    }

    public static boolean checkNum(String str) {
        if (StringUtils.isNull(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && '9' >= c) continue;
            return false;
        }
        return true;
    }

    public static String getRandomPassword(int length) {
        int index = 0;
        char[] charSet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            index = (int)((double)charSet.length * Math.random());
            sb.append(charSet[index]);
        }
        if (log.isDebugEnabled()) {
            log.debug("getRandowmPassword : {}", (Object)sb.toString());
        }
        return sb.toString();
    }

    public static String replace(String target, String from, String to) {
        int idx2;
        if (target == null || from == null || to == null) {
            return null;
        }
        int idx1 = 0;
        while ((idx2 = target.indexOf(from, idx1)) != -1) {
            target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
            idx1 = idx2 + to.length();
        }
        return target;
    }

    public static String getCurrentDate(String format) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(cal.getTime());
    }

    public static String changeDayFromToday(String format, int changeDay) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        cal.add(5, changeDay);
        return sdf.format(cal.getTime());
    }

    public static String parseSQL(String source, String mapping, String value, boolean sql) {
        if (mapping == null || source == null) {
            return source;
        }
        if (sql) {
            value = StringUtils.replace(value, "'", "''");
        }
        return StringUtils.replace(source, "${" + mapping + "}", Locale.toDb(value));
    }

    public static String parseSQL(String source, String mapping, String value) {
        return StringUtils.parseSQL(source, mapping, value, true);
    }

    public static String parseSQL(String source, Map<?, ?> map, boolean sql) {
        if (map == null) {
            return source;
        }
        Set<?> kSet = map.keySet();
        for (String key : kSet) {
            String value = (String)map.get(key);
            source = StringUtils.parseSQL(source, key, value, sql);
        }
        return source;
    }

    public static String removeBOM(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        if (str.startsWith("\ufeff")) {
            str = str.substring(1);
        } else if (str.startsWith("\ufffe")) {
            str = str.substring(1);
        } else if (str.startsWith("\uefbbBF")) {
            str = str.substring(1);
        } else if (str.startsWith("\u0000FEFF")) {
            str = str.substring(1);
        } else if (str.startsWith("\ufffe0000")) {
            str = str.substring(1);
        } else if (str.startsWith("\u0000FEFF")) {
            str = str.substring(1);
        }
        return str;
    }

    public static Map convertObjectToMap(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            try {
                map.put(fields[i].getName(), fields[i].get(obj));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.getDomain("0a0Y9z69gqYBFCmbVja035GROOoxP5abotYTgLC5Q6xoK+oZcDU2X0fh8DfJTRsU"));
    }
}

